/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.ArmoredInputException;
import org.bouncycastle.bcpg.CRC24;
import org.bouncycastle.bcpg.FastCRC24;
import org.bouncycastle.util.StringList;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArmoredInputStream
extends InputStream {
    private static final byte[] decodingTable;
    private boolean detectMissingChecksum = false;
    private final CRC24 crc;
    InputStream in;
    boolean start = true;
    byte[] outBuf = new byte[3];
    int bufPtr = 3;
    boolean crcFound = false;
    boolean hasHeaders = true;
    String header = null;
    boolean newLineFound = false;
    boolean clearText = false;
    boolean restart = false;
    StringList headerList = Strings.newList();
    int lastC = 0;
    boolean isEndOfStream;
    private boolean validateAllowedHeaders = false;
    private List<String> allowedHeaders = ArmoredInputStream.defaultAllowedHeaders();

    private static int decode(int n, int n2, int n3, int n4, byte[] byArray) throws IOException {
        if (n4 < 0) {
            throw new EOFException("unexpected end of file in armored stream.");
        }
        if (n3 == 61) {
            int n5 = decodingTable[n] & 0xFF;
            int n6 = decodingTable[n2] & 0xFF;
            if ((n5 | n6) < 0) {
                throw new ArmoredInputException("invalid armor");
            }
            byArray[2] = (byte)(n5 << 2 | n6 >> 4);
            return 2;
        }
        if (n4 == 61) {
            byte by = decodingTable[n];
            byte by2 = decodingTable[n2];
            byte by3 = decodingTable[n3];
            if ((by | by2 | by3) < 0) {
                throw new ArmoredInputException("invalid armor");
            }
            byArray[1] = (byte)(by << 2 | by2 >> 4);
            byArray[2] = (byte)(by2 << 4 | by3 >> 2);
            return 1;
        }
        byte by = decodingTable[n];
        byte by4 = decodingTable[n2];
        byte by5 = decodingTable[n3];
        byte by6 = decodingTable[n4];
        if ((by | by4 | by5 | by6) < 0) {
            throw new ArmoredInputException("invalid armor");
        }
        byArray[0] = (byte)(by << 2 | by4 >> 4);
        byArray[1] = (byte)(by4 << 4 | by5 >> 2);
        byArray[2] = (byte)(by5 << 6 | by6);
        return 0;
    }

    public ArmoredInputStream(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public ArmoredInputStream(InputStream inputStream, boolean bl) throws IOException {
        this.in = inputStream;
        this.hasHeaders = bl;
        this.crc = new FastCRC24();
        if (bl) {
            this.parseHeaders();
        }
        this.start = false;
    }

    private ArmoredInputStream(InputStream inputStream, Builder builder) throws IOException {
        this.in = inputStream;
        this.hasHeaders = builder.hasHeaders;
        this.detectMissingChecksum = builder.detectMissingCRC;
        this.crc = builder.ignoreCRC ? null : new FastCRC24();
        this.validateAllowedHeaders = builder.validateAllowedHeaders;
        this.allowedHeaders = builder.allowedHeaders;
        if (this.hasHeaders) {
            this.parseHeaders();
        }
        if (this.validateAllowedHeaders) {
            this.rejectUnknownHeadersInCSFMessages();
        }
        this.start = false;
    }

    private void rejectUnknownHeadersInCSFMessages() throws ArmoredInputException {
        Iterator iterator = this.headerList.iterator();
        String string = (String)iterator.next();
        if (!string.startsWith("-----BEGIN PGP SIGNED MESSAGE-----")) {
            return;
        }
        block0: while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Iterator<String> iterator2 = this.allowedHeaders.iterator();
            while (iterator2.hasNext()) {
                if (!string2.startsWith(iterator2.next() + ": ")) continue;
                continue block0;
            }
            throw new ArmoredInputException("Illegal ASCII armor header line in clearsigned message encountered: " + string2);
        }
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    private boolean parseHeaders() throws IOException {
        int n;
        this.header = null;
        int n2 = 0;
        boolean bl = false;
        this.headerList = Strings.newList();
        if (this.restart) {
            bl = true;
        } else {
            while ((n = this.in.read()) >= 0) {
                if (n == 45 && (n2 == 0 || n2 == 10 || n2 == 13)) {
                    bl = true;
                    break;
                }
                n2 = n;
            }
        }
        if (bl) {
            int n3;
            boolean bl2 = false;
            boolean bl3 = false;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(45);
            if (this.restart) {
                byteArrayOutputStream.write(45);
            }
            while ((n = this.in.read()) >= 0) {
                if (n2 == 13 && n == 10) {
                    bl3 = true;
                }
                if (bl2 && n2 != 13 && n == 10 || bl2 && n == 13) break;
                if (n == 13 || n2 != 13 && n == 10) {
                    String string;
                    try {
                        string = Strings.fromUTF8ByteArray((byte[])byteArrayOutputStream.toByteArray());
                    }
                    catch (Exception exception) {
                        throw new ArmoredInputException(exception.getMessage());
                    }
                    if (string.trim().length() == 0) break;
                    if (this.headerList.size() != 0 && string.indexOf(58) < 0) {
                        throw new ArmoredInputException("invalid armor header");
                    }
                    this.headerList.add(string);
                    byteArrayOutputStream.reset();
                }
                if (n != 10 && n != 13) {
                    byteArrayOutputStream.write(n);
                    bl2 = false;
                } else if (n == 13 || n2 != 13 && n == 10) {
                    bl2 = true;
                }
                n2 = n;
            }
            if (bl3 && (n3 = this.in.read()) != 10) {
                throw new ArmoredInputException("inconsistent line endings in headers");
            }
        }
        if (this.headerList.size() > 0) {
            this.header = this.headerList.get(0);
        }
        this.clearText = "-----BEGIN PGP SIGNED MESSAGE-----".equals(this.header);
        this.newLineFound = true;
        return bl;
    }

    public boolean isClearText() {
        return this.clearText;
    }

    public boolean isEndOfStream() {
        return this.isEndOfStream;
    }

    public String getArmorHeaderLine() {
        return this.header;
    }

    public String[] getArmorHeaders() {
        if (this.headerList.size() <= 1) {
            return null;
        }
        return this.headerList.toStringArray(1, this.headerList.size());
    }

    private int readIgnoreSpace() throws IOException {
        int n = this.in.read();
        while (n == 32 || n == 9 || n == 12 || n == 11) {
            n = this.in.read();
        }
        if (n >= 128) {
            throw new ArmoredInputException("invalid armor");
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        if (this.start) {
            if (this.hasHeaders) {
                this.parseHeaders();
            }
            if (this.crc != null) {
                this.crc.reset();
            }
            this.start = false;
        }
        if (this.clearText) {
            int n = this.in.read();
            if (n == 13 || n == 10 && this.lastC != 13) {
                this.newLineFound = true;
            } else if (this.newLineFound && n == 45) {
                n = this.in.read();
                if (n == 45) {
                    this.clearText = false;
                    this.start = true;
                    this.restart = true;
                } else {
                    n = this.in.read();
                }
                this.newLineFound = false;
            } else if (n != 10 && this.lastC != 13) {
                this.newLineFound = false;
            }
            this.lastC = n;
            if (n < 0) {
                this.isEndOfStream = true;
            }
            return n;
        }
        if (this.bufPtr > 2 || this.crcFound) {
            int n = this.readIgnoreSpace();
            if (n == 13 || n == 10) {
                n = this.readIgnoreSpace();
                while (n == 10 || n == 13) {
                    n = this.readIgnoreSpace();
                }
                if (n == 61) {
                    int n2;
                    this.bufPtr = ArmoredInputStream.decode(this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
                    if (this.bufPtr != 0) {
                        throw new ArmoredInputException("malformed crc in armored message");
                    }
                    this.crcFound = true;
                    if (this.crc != null && (n2 = (this.outBuf[0] & 0xFF) << 16 | (this.outBuf[1] & 0xFF) << 8 | this.outBuf[2] & 0xFF) != this.crc.getValue()) {
                        throw new ArmoredInputException("crc check failed in armored message");
                    }
                    return this.read();
                }
                if (n == 45) {
                    while ((n = this.in.read()) >= 0 && n != 10 && n != 13) {
                    }
                    if (!this.crcFound && this.detectMissingChecksum) {
                        throw new ArmoredInputException("crc check not found");
                    }
                    this.crcFound = false;
                    this.start = true;
                    this.bufPtr = 3;
                    if (n < 0) {
                        this.isEndOfStream = true;
                    }
                    return -1;
                }
            }
            if (n < 0) {
                this.isEndOfStream = true;
                return -1;
            }
            this.bufPtr = ArmoredInputStream.decode(n, this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
            if (this.crc != null) {
                if (this.bufPtr == 0) {
                    this.crc.update3(this.outBuf, 0);
                } else {
                    for (int i = this.bufPtr; i < 3; ++i) {
                        this.crc.update(this.outBuf[i] & 0xFF);
                    }
                }
            }
        }
        return this.outBuf[this.bufPtr++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.checkIndexSize(byArray.length, n, n2);
        if (n2 == 0) {
            return 0;
        }
        int n4 = this.read();
        if (n4 == -1) {
            return -1;
        }
        byArray[n] = (byte)n4;
        for (n3 = 1; n3 < n2 && (n4 = this.read()) != -1; ++n3) {
            byArray[n + n3] = (byte)n4;
        }
        return n3;
    }

    private void checkIndexSize(int n, int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            throw new IndexOutOfBoundsException("Offset and length cannot be negative.");
        }
        if (n2 > n - n3) {
            throw new IndexOutOfBoundsException("Invalid offset and length.");
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public void setDetectMissingCRC(boolean bl) {
        this.detectMissingChecksum = bl;
    }

    private static List<String> defaultAllowedHeaders() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Comment");
        arrayList.add("Version");
        arrayList.add("Charset");
        arrayList.add("Hash");
        arrayList.add("MessageID");
        return arrayList;
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ List access$600() {
        return ArmoredInputStream.defaultAllowedHeaders();
    }

    static {
        int n;
        decodingTable = new byte[128];
        for (n = 0; n < decodingTable.length; ++n) {
            ArmoredInputStream.decodingTable[n] = -1;
        }
        for (n = 65; n <= 90; ++n) {
            ArmoredInputStream.decodingTable[n] = (byte)(n - 65);
        }
        for (n = 97; n <= 122; ++n) {
            ArmoredInputStream.decodingTable[n] = (byte)(n - 97 + 26);
        }
        for (n = 48; n <= 57; ++n) {
            ArmoredInputStream.decodingTable[n] = (byte)(n - 48 + 52);
        }
        ArmoredInputStream.decodingTable[43] = 62;
        ArmoredInputStream.decodingTable[47] = 63;
    }

    public static class Builder {
        private boolean hasHeaders = true;
        private boolean detectMissingCRC = false;
        private boolean ignoreCRC = false;
        private boolean validateAllowedHeaders = false;
        private List<String> allowedHeaders = ArmoredInputStream.access$600();

        private Builder() {
        }

        public Builder setParseForHeaders(boolean bl) {
            this.hasHeaders = bl;
            return this;
        }

        public Builder setValidateClearsignedMessageHeaders(boolean bl) {
            this.validateAllowedHeaders = bl;
            return this;
        }

        public Builder addAllowedArmorHeader(String string) {
            this.allowedHeaders.add(string.trim());
            return this;
        }

        public Builder setDetectMissingCRC(boolean bl) {
            this.detectMissingCRC = bl;
            return this;
        }

        public Builder setIgnoreCRC(boolean bl) {
            this.ignoreCRC = bl;
            return this;
        }

        public ArmoredInputStream build(InputStream inputStream) throws IOException {
            return new ArmoredInputStream(inputStream, this);
        }
    }
}

