/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.util.Exceptions;

public class IntegrityProtectedInputStream
extends FilterInputStream {
    private final PGPEncryptedData esk;

    public IntegrityProtectedInputStream(InputStream inputStream, PGPEncryptedData pGPEncryptedData) {
        super(inputStream);
        this.esk = pGPEncryptedData;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            this.close();
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n == -1) {
            this.close();
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 == -1) {
            this.close();
        }
        return n3;
    }

    public void close() throws IOException {
        SymmetricEncIntegrityPacket symmetricEncIntegrityPacket;
        super.close();
        if (this.esk.getEncData() instanceof SymmetricEncIntegrityPacket && (symmetricEncIntegrityPacket = (SymmetricEncIntegrityPacket)this.esk.getEncData()).getVersion() == 1) {
            try {
                if (!this.esk.verify()) {
                    throw new PGPException("Malformed integrity protected data.");
                }
            }
            catch (PGPException pGPException) {
                throw Exceptions.ioException((String)pGPException.getMessage(), (Throwable)pGPException);
            }
        }
    }
}

