/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.HashUtils;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.openpgp.PGPDefaultSignatureGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPSignature
extends PGPDefaultSignatureGenerator {
    public static final int BINARY_DOCUMENT = 0;
    public static final int CANONICAL_TEXT_DOCUMENT = 1;
    public static final int STAND_ALONE = 2;
    public static final int DEFAULT_CERTIFICATION = 16;
    public static final int NO_CERTIFICATION = 17;
    public static final int CASUAL_CERTIFICATION = 18;
    public static final int POSITIVE_CERTIFICATION = 19;
    public static final int SUBKEY_BINDING = 24;
    public static final int PRIMARYKEY_BINDING = 25;
    public static final int DIRECT_KEY = 31;
    public static final int KEY_REVOCATION = 32;
    public static final int SUBKEY_REVOCATION = 40;
    public static final int CERTIFICATION_REVOCATION = 48;
    public static final int TIMESTAMP = 64;
    public static final int THIRD_PARTY_CONFIRMATION = 80;
    final SignaturePacket sigPck;
    private final TrustPacket trustPck;
    private volatile PGPContentVerifier verifier;

    private static SignaturePacket cast(Packet packet) throws IOException {
        if (!(packet instanceof SignaturePacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        return (SignaturePacket)packet;
    }

    public PGPSignature(BCPGInputStream bCPGInputStream) throws IOException, PGPException {
        this(PGPSignature.cast(bCPGInputStream.readPacket()));
    }

    PGPSignature(PGPSignature pGPSignature) {
        super(pGPSignature.getVersion());
        this.sigPck = pGPSignature.sigPck;
        this.sigType = pGPSignature.sigType;
        this.trustPck = pGPSignature.trustPck;
    }

    PGPSignature(SignaturePacket signaturePacket) {
        this(signaturePacket, null);
    }

    PGPSignature(SignaturePacket signaturePacket, TrustPacket trustPacket) {
        super(signaturePacket.getVersion());
        this.sigPck = signaturePacket;
        this.sigType = this.sigPck.getSignatureType();
        this.trustPck = trustPacket;
    }

    public int getVersion() {
        return this.sigPck.getVersion();
    }

    public int getKeyAlgorithm() {
        return this.sigPck.getKeyAlgorithm();
    }

    public int getHashAlgorithm() {
        return this.sigPck.getHashAlgorithm();
    }

    public byte[] getDigestPrefix() {
        return this.sigPck.getFingerPrint();
    }

    public boolean isCertification() {
        return PGPSignature.isCertification(this.getSignatureType());
    }

    public void init(PGPContentVerifierBuilderProvider pGPContentVerifierBuilderProvider, PGPPublicKey pGPPublicKey) throws PGPException {
        if (this.sigType == 255) {
            throw new PGPException("Illegal signature type 0xFF provided.");
        }
        if (this.getVersion() == 6 && pGPPublicKey.getVersion() != 6) {
            throw new PGPException("MUST NOT verify v6 signature with non-v6 key.");
        }
        if (this.getVersion() == 4 && pGPPublicKey.getVersion() != 4) {
            throw new PGPException("MUST NOT verify v4 signature with non-v4 key.");
        }
        PGPContentVerifierBuilder pGPContentVerifierBuilder = this.createVerifierProvider(pGPContentVerifierBuilderProvider);
        this.init(pGPContentVerifierBuilder.build(pGPPublicKey));
    }

    PGPContentVerifierBuilder createVerifierProvider(PGPContentVerifierBuilderProvider pGPContentVerifierBuilderProvider) throws PGPException {
        return pGPContentVerifierBuilderProvider.get(this.sigPck.getKeyAlgorithm(), this.sigPck.getHashAlgorithm());
    }

    void init(PGPContentVerifier pGPContentVerifier) throws PGPException {
        this.verifier = pGPContentVerifier;
        this.lastb = 0;
        this.sigOut = pGPContentVerifier.getOutputStream();
        this.checkSaltSize();
        this.updateWithSalt();
    }

    private void checkSaltSize() throws PGPException {
        if (this.getVersion() != 6) {
            return;
        }
        int n = HashUtils.getV6SignatureSaltSizeInBytes(this.getHashAlgorithm());
        if (n != this.sigPck.getSalt().length) {
            throw new PGPException("RFC9580 defines the salt size for " + PGPUtil.getDigestName(this.getHashAlgorithm()) + " as " + n + " octets, but signature has " + this.sigPck.getSalt().length + " octets.");
        }
    }

    private void updateWithSalt() throws PGPException {
        if (this.getVersion() == 6) {
            try {
                this.sigOut.write(this.sigPck.getSalt());
            }
            catch (IOException iOException) {
                throw new PGPException("Could not update with salt.", iOException);
            }
        }
    }

    public boolean verify() throws PGPException {
        try {
            this.sigOut.write(this.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException iOException) {
            throw new PGPException(iOException.getMessage(), iOException);
        }
        return this.verifier.verify(this.getSignature());
    }

    public boolean verifyCertification(PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPPublicKey pGPPublicKey) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        if (!PGPSignature.isCertification(this.sigType) && 48 != this.sigType) {
            throw new PGPException("signature is neither a certification signature nor a certification revocation.");
        }
        return this.doVerifyCertification(pGPUserAttributeSubpacketVector, pGPPublicKey);
    }

    boolean doVerifyCertification(PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPPublicKey pGPPublicKey) throws PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.getAttributesHash(pGPUserAttributeSubpacketVector);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public boolean verifyCertification(String string, PGPPublicKey pGPPublicKey) throws PGPException {
        return this.verifyCertification(Strings.toUTF8ByteArray((String)string), pGPPublicKey);
    }

    public boolean verifyCertification(byte[] byArray, PGPPublicKey pGPPublicKey) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        if (!PGPSignature.isCertification(this.sigType) && 48 != this.sigType) {
            throw new PGPException("signature is neither a certification signature nor a certification revocation.");
        }
        return this.doVerifyCertification(byArray, pGPPublicKey);
    }

    boolean doVerifyCertification(byte[] byArray, PGPPublicKey pGPPublicKey) throws PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithIdData(180, byArray);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public boolean verifyCertification(PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        if (24 != this.sigType && 25 != this.sigType && 40 != this.sigType) {
            throw new PGPException("signature is not a key binding signature.");
        }
        return this.doVerifyCertification(pGPPublicKey, pGPPublicKey2);
    }

    boolean doVerifyCertification(PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2) throws PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithPublicKey(pGPPublicKey2);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    private void addTrailer() {
        try {
            this.sigOut.write(this.sigPck.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException iOException) {
            throw new PGPRuntimeOperationException(iOException.getMessage(), iOException);
        }
    }

    public boolean verifyCertification(PGPPublicKey pGPPublicKey) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        if (this.getSignatureType() != 32 && this.getSignatureType() != 31) {
            throw new PGPException("signature is not a key signature");
        }
        return this.doVerifyCertification(pGPPublicKey);
    }

    boolean doVerifyCertification(PGPPublicKey pGPPublicKey) throws PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public int getSignatureType() {
        return this.sigPck.getSignatureType();
    }

    public long getKeyID() {
        return this.sigPck.getKeyID();
    }

    public List<KeyIdentifier> getKeyIdentifiers() {
        ArrayList<KeyIdentifier> arrayList = new ArrayList<KeyIdentifier>();
        if (this.getVersion() <= 3) {
            arrayList.add(new KeyIdentifier(this.getKeyID()));
        } else {
            arrayList.addAll(this.getHashedKeyIdentifiers());
            arrayList.addAll(this.getUnhashedKeyIdentifiers());
        }
        return arrayList;
    }

    public boolean hasKeyIdentifier(KeyIdentifier keyIdentifier) {
        Iterator<KeyIdentifier> iterator = this.getKeyIdentifiers().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().matchesExplicit(keyIdentifier)) continue;
            return true;
        }
        return false;
    }

    public List<KeyIdentifier> getHashedKeyIdentifiers() {
        return this.extractKeyIdentifiers(this.sigPck.getHashedSubPackets());
    }

    public List<KeyIdentifier> getUnhashedKeyIdentifiers() {
        return this.extractKeyIdentifiers(this.sigPck.getUnhashedSubPackets());
    }

    private List<KeyIdentifier> extractKeyIdentifiers(SignatureSubpacket[] signatureSubpacketArray) {
        ArrayList<KeyIdentifier> arrayList = new ArrayList<KeyIdentifier>();
        for (int i = 0; i != signatureSubpacketArray.length; ++i) {
            SignatureSubpacket signatureSubpacket;
            SignatureSubpacket signatureSubpacket2 = signatureSubpacketArray[i];
            if (signatureSubpacket2 instanceof IssuerFingerprint) {
                signatureSubpacket = (IssuerFingerprint)signatureSubpacket2;
                arrayList.add(new KeyIdentifier(((IssuerFingerprint)signatureSubpacket).getFingerprint()));
            }
            if (!(signatureSubpacket2 instanceof IssuerKeyID)) continue;
            signatureSubpacket = (IssuerKeyID)signatureSubpacket2;
            arrayList.add(new KeyIdentifier(((IssuerKeyID)signatureSubpacket).getKeyID()));
        }
        return arrayList;
    }

    public Date getCreationTime() {
        return new Date(this.sigPck.getCreationTime());
    }

    public byte[] getSignatureTrailer() {
        return this.sigPck.getSignatureTrailer();
    }

    public boolean hasSubpackets() {
        return this.sigPck.getHashedSubPackets() != null || this.sigPck.getUnhashedSubPackets() != null;
    }

    public PGPSignatureSubpacketVector getHashedSubPackets() {
        return this.createSubpacketVector(this.sigPck.getHashedSubPackets());
    }

    public PGPSignatureSubpacketVector getUnhashedSubPackets() {
        return this.createSubpacketVector(this.sigPck.getUnhashedSubPackets());
    }

    private PGPSignatureSubpacketVector createSubpacketVector(SignatureSubpacket[] signatureSubpacketArray) {
        if (signatureSubpacketArray != null) {
            return new PGPSignatureSubpacketVector(signatureSubpacketArray);
        }
        return null;
    }

    byte[] getSalt() {
        return this.sigPck.getSalt();
    }

    public byte[] getSignature() throws PGPException {
        byte[] byArray;
        MPInteger[] mPIntegerArray = this.sigPck.getSignature();
        if (mPIntegerArray != null) {
            if (mPIntegerArray.length == 1) {
                byArray = BigIntegers.asUnsignedByteArray((BigInteger)mPIntegerArray[0].getValue());
            } else if (this.getKeyAlgorithm() == 22) {
                byte[] byArray2;
                byte[] byArray3 = BigIntegers.asUnsignedByteArray((BigInteger)mPIntegerArray[0].getValue());
                if (byArray3.length + (byArray2 = BigIntegers.asUnsignedByteArray((BigInteger)mPIntegerArray[1].getValue())).length > 64) {
                    byArray = new byte[114];
                    System.arraycopy(byArray3, 0, byArray, 57 - byArray3.length, byArray3.length);
                    System.arraycopy(byArray2, 0, byArray, 114 - byArray2.length, byArray2.length);
                } else {
                    byArray = new byte[64];
                    System.arraycopy(byArray3, 0, byArray, 32 - byArray3.length, byArray3.length);
                    System.arraycopy(byArray2, 0, byArray, 64 - byArray2.length, byArray2.length);
                }
            } else {
                try {
                    ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                    aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(mPIntegerArray[0].getValue()));
                    aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(mPIntegerArray[1].getValue()));
                    byArray = new DERSequence(aSN1EncodableVector).getEncoded();
                }
                catch (IOException iOException) {
                    throw new PGPException("exception encoding DSA sig.", iOException);
                }
            }
        } else {
            byArray = this.sigPck.getSignatureBytes();
        }
        return byArray;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncoded(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream, bl);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(outputStream, false);
    }

    public void encode(OutputStream outputStream, boolean bl) throws IOException {
        if (!(!bl || this.getHashedSubPackets().isExportable() && this.getUnhashedSubPackets().isExportable())) {
            return;
        }
        BCPGOutputStream bCPGOutputStream = BCPGOutputStream.wrap(outputStream);
        bCPGOutputStream.writePacket(this.sigPck);
        if (!bl && this.trustPck != null) {
            bCPGOutputStream.writePacket(this.trustPck);
        }
    }

    public static boolean isCertification(int n) {
        return 16 == n || 17 == n || 18 == n || 19 == n;
    }

    public static boolean isRevocation(int n) {
        return 32 == n || 48 == n || 40 == n;
    }

    public boolean isHardRevocation() {
        RevocationReason revocationReason;
        if (!PGPSignature.isRevocation(this.getSignatureType())) {
            return false;
        }
        if (!this.hasSubpackets()) {
            return true;
        }
        RevocationReason revocationReason2 = revocationReason = this.getHashedSubPackets() != null ? this.getHashedSubPackets().getRevocationReason() : null;
        if (revocationReason == null) {
            return true;
        }
        byte by = revocationReason.getRevocationReason();
        if (by >= 100 && by <= 110) {
            return true;
        }
        return by != 1 && by != 3 && by != 32;
    }

    public static boolean isSignatureEncodingEqual(PGPSignature pGPSignature, PGPSignature pGPSignature2) {
        return Arrays.areEqual((byte[])pGPSignature.sigPck.getSignatureBytes(), (byte[])pGPSignature2.sigPck.getSignatureBytes());
    }

    public static PGPSignature join(PGPSignature pGPSignature, PGPSignature pGPSignature2) throws PGPException {
        if (pGPSignature.getVersion() < 4) {
            return pGPSignature;
        }
        if (pGPSignature.getVersion() != pGPSignature2.getVersion() || !PGPSignature.isSignatureEncodingEqual(pGPSignature, pGPSignature2)) {
            throw new IllegalArgumentException("These are different signatures.");
        }
        SignatureSubpacket[] signatureSubpacketArray = pGPSignature.getUnhashedSubPackets().packets;
        SignatureSubpacket[] signatureSubpacketArray2 = pGPSignature2.getUnhashedSubPackets().packets;
        ArrayList<SignatureSubpacket> arrayList = new ArrayList<SignatureSubpacket>(java.util.Arrays.asList(signatureSubpacketArray));
        for (int i = 0; i != signatureSubpacketArray2.length; ++i) {
            SignatureSubpacket signatureSubpacket = signatureSubpacketArray2[i];
            boolean bl = false;
            for (int j = 0; j != signatureSubpacketArray.length; ++j) {
                SignatureSubpacket signatureSubpacket2 = signatureSubpacketArray[j];
                if (!signatureSubpacket.equals(signatureSubpacket2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(signatureSubpacket);
        }
        SignatureSubpacket[] signatureSubpacketArray3 = arrayList.toArray(new SignatureSubpacket[0]);
        return new PGPSignature(new SignaturePacket(pGPSignature.getVersion(), pGPSignature.sigPck.hasNewPacketFormat(), pGPSignature.getSignatureType(), pGPSignature.getKeyID(), pGPSignature.getKeyAlgorithm(), pGPSignature.getHashAlgorithm(), pGPSignature.getHashedSubPackets().packets, signatureSubpacketArray3, pGPSignature.getDigestPrefix(), pGPSignature.sigPck.getSignature()));
    }
}

