/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.api.KeyPassphraseProvider;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.SignatureParameters;
import org.bouncycastle.openpgp.api.SubkeySelector;
import org.bouncycastle.openpgp.api.Utils;
import org.bouncycastle.openpgp.api.exception.InvalidSigningKeyException;
import org.bouncycastle.openpgp.api.exception.KeyPassphraseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractOpenPGPDocumentSignatureGenerator<T extends AbstractOpenPGPDocumentSignatureGenerator<T>> {
    protected final OpenPGPImplementation implementation;
    protected final OpenPGPPolicy policy;
    protected final List<PGPSignatureGenerator> signatureGenerators = new ArrayList<PGPSignatureGenerator>();
    protected final List<OpenPGPKey.OpenPGPSecretKey> signingKeys = new ArrayList<OpenPGPKey.OpenPGPSecretKey>();
    protected final List<SignatureParameters.Callback> signatureCallbacks = new ArrayList<SignatureParameters.Callback>();
    protected final List<KeyPassphraseProvider> signingKeyPassphraseProviders = new ArrayList<KeyPassphraseProvider>();
    protected final KeyPassphraseProvider.DefaultKeyPassphraseProvider defaultKeyPassphraseProvider = new KeyPassphraseProvider.DefaultKeyPassphraseProvider();
    protected SubkeySelector signingKeySelector = new SubkeySelector(){

        @Override
        public List<OpenPGPCertificate.OpenPGPComponentKey> select(OpenPGPCertificate openPGPCertificate, OpenPGPPolicy openPGPPolicy) {
            ArrayList<OpenPGPCertificate.OpenPGPComponentKey> arrayList = new ArrayList<OpenPGPCertificate.OpenPGPComponentKey>();
            for (OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey : openPGPCertificate.getSigningKeys()) {
                if (!openPGPPolicy.isAcceptablePublicKey(openPGPComponentKey.getPGPPublicKey())) continue;
                arrayList.add(openPGPComponentKey);
            }
            return arrayList;
        }
    };

    public AbstractOpenPGPDocumentSignatureGenerator(OpenPGPImplementation openPGPImplementation, OpenPGPPolicy openPGPPolicy) {
        this.implementation = openPGPImplementation;
        this.policy = openPGPPolicy;
    }

    public T setSigningKeySelector(SubkeySelector subkeySelector) {
        if (subkeySelector == null) {
            throw new NullPointerException();
        }
        this.signingKeySelector = subkeySelector;
        return (T)this;
    }

    public T addKeyPassphrase(char[] cArray) {
        this.defaultKeyPassphraseProvider.addPassphrase(cArray);
        return (T)this;
    }

    public T addSigningKey(OpenPGPKey openPGPKey) throws InvalidSigningKeyException {
        return this.addSigningKey(openPGPKey, this.defaultKeyPassphraseProvider);
    }

    public T addSigningKey(OpenPGPKey openPGPKey, KeyPassphraseProvider keyPassphraseProvider) throws InvalidSigningKeyException {
        return this.addSigningKey(openPGPKey, keyPassphraseProvider, null);
    }

    public T addSigningKey(OpenPGPKey openPGPKey, SignatureParameters.Callback callback) throws InvalidSigningKeyException {
        return this.addSigningKey(openPGPKey, (KeyPassphraseProvider)this.defaultKeyPassphraseProvider, callback);
    }

    public T addSigningKey(OpenPGPKey openPGPKey, KeyPassphraseProvider keyPassphraseProvider, SignatureParameters.Callback callback) throws InvalidSigningKeyException {
        List<OpenPGPCertificate.OpenPGPComponentKey> list = this.signingKeySelector.select(openPGPKey, this.policy);
        if (list.isEmpty()) {
            throw new InvalidSigningKeyException(openPGPKey);
        }
        Iterator<OpenPGPCertificate.OpenPGPComponentKey> iterator = list.iterator();
        while (iterator.hasNext()) {
            OpenPGPKey.OpenPGPSecretKey openPGPSecretKey = openPGPKey.getSecretKey(iterator.next());
            this.addSigningKey(openPGPSecretKey, keyPassphraseProvider, callback);
        }
        return (T)this;
    }

    public T addSigningKey(OpenPGPKey.OpenPGPSecretKey openPGPSecretKey, char[] cArray, SignatureParameters.Callback callback) throws InvalidSigningKeyException {
        return this.addSigningKey(openPGPSecretKey, (KeyPassphraseProvider)this.defaultKeyPassphraseProvider.addPassphrase(openPGPSecretKey, cArray), callback);
    }

    public T addSigningKey(OpenPGPKey.OpenPGPSecretKey openPGPSecretKey, KeyPassphraseProvider keyPassphraseProvider, SignatureParameters.Callback callback) throws InvalidSigningKeyException {
        if (!openPGPSecretKey.isSigningKey()) {
            throw new InvalidSigningKeyException(openPGPSecretKey);
        }
        this.signingKeys.add(openPGPSecretKey);
        this.signingKeyPassphraseProviders.add(keyPassphraseProvider);
        this.signatureCallbacks.add(callback);
        return (T)this;
    }

    protected PGPSignatureGenerator initSignatureGenerator(OpenPGPKey.OpenPGPSecretKey openPGPSecretKey, KeyPassphraseProvider keyPassphraseProvider, SignatureParameters.Callback callback) throws PGPException {
        SignatureParameters signatureParameters = Utils.applySignatureParameters(callback, SignatureParameters.dataSignature(this.policy).setSignatureHashAlgorithm(this.getPreferredHashAlgorithm(openPGPSecretKey)));
        if (signatureParameters == null) {
            throw new IllegalStateException("SignatureParameters Callback MUST NOT return null.");
        }
        if (!openPGPSecretKey.isSigningKey(signatureParameters.getSignatureCreationTime())) {
            throw new InvalidSigningKeyException(openPGPSecretKey);
        }
        char[] cArray = keyPassphraseProvider.getKeyPassword(openPGPSecretKey);
        PGPKeyPair pGPKeyPair = openPGPSecretKey.unlock(cArray).getKeyPair();
        if (pGPKeyPair == null) {
            throw new KeyPassphraseException((OpenPGPCertificate.OpenPGPComponentKey)openPGPSecretKey, (Exception)new PGPException("Cannot unlock secret key."));
        }
        return Utils.getPgpSignatureGenerator(this.implementation, openPGPSecretKey.getPGPPublicKey(), pGPKeyPair.getPrivateKey(), signatureParameters, null, null);
    }

    private int getPreferredHashAlgorithm(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey) {
        PreferredAlgorithms preferredAlgorithms = openPGPComponentKey.getHashAlgorithmPreferences();
        if (preferredAlgorithms != null) {
            int[] nArray = preferredAlgorithms.getPreferences();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (!this.policy.isAcceptableDocumentSignatureHashAlgorithm(n, new Date())) continue;
                arrayList.add(n);
            }
            if (!arrayList.isEmpty()) {
                return (Integer)arrayList.get(0);
            }
        }
        return this.policy.getDefaultDocumentSignatureHashAlgorithm();
    }

    public T setMissingKeyPassphraseCallback(KeyPassphraseProvider keyPassphraseProvider) {
        this.defaultKeyPassphraseProvider.setMissingPassphraseCallback(keyPassphraseProvider);
        return (T)this;
    }

    protected void addSignToGenerator() throws PGPException {
        for (int i = 0; i < this.signingKeys.size(); ++i) {
            OpenPGPKey.OpenPGPSecretKey openPGPSecretKey = this.signingKeys.get(i);
            KeyPassphraseProvider keyPassphraseProvider = this.signingKeyPassphraseProviders.get(i);
            SignatureParameters.Callback callback = this.signatureCallbacks.get(i);
            PGPSignatureGenerator pGPSignatureGenerator = this.initSignatureGenerator(openPGPSecretKey, keyPassphraseProvider, callback);
            this.signatureGenerators.add(pGPSignatureGenerator);
        }
    }
}

