/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.util.Arrays;

public interface KeyPassphraseProvider {
    public char[] getKeyPassword(OpenPGPKey.OpenPGPSecretKey var1);

    public static class DefaultKeyPassphraseProvider
    implements KeyPassphraseProvider {
        private final Map<OpenPGPKey.OpenPGPSecretKey, char[]> passphraseMap = new HashMap<OpenPGPKey.OpenPGPSecretKey, char[]>();
        private final List<char[]> allPassphrases = new ArrayList<char[]>();
        private KeyPassphraseProvider callback;

        public DefaultKeyPassphraseProvider() {
        }

        public DefaultKeyPassphraseProvider(OpenPGPKey openPGPKey, char[] cArray) {
            this.allPassphrases.add(cArray);
            for (OpenPGPKey.OpenPGPSecretKey openPGPSecretKey : openPGPKey.getSecretKeys().values()) {
                this.passphraseMap.put(openPGPSecretKey, cArray);
            }
        }

        public char[] getKeyPassword(OpenPGPKey.OpenPGPSecretKey openPGPSecretKey) {
            if (!openPGPSecretKey.isLocked()) {
                this.passphraseMap.put(openPGPSecretKey, null);
                return null;
            }
            char[] cArray = this.passphraseMap.get(openPGPSecretKey);
            if (cArray != null) {
                return cArray;
            }
            for (char[] cArray2 : this.allPassphrases) {
                if (!openPGPSecretKey.isPassphraseCorrect(cArray2)) continue;
                this.addPassphrase(openPGPSecretKey, cArray2);
                return cArray2;
            }
            if (this.callback != null) {
                cArray = this.callback.getKeyPassword(openPGPSecretKey);
                this.addPassphrase(openPGPSecretKey, cArray);
            }
            return cArray;
        }

        public DefaultKeyPassphraseProvider addPassphrase(char[] cArray) {
            boolean bl = false;
            for (char[] cArray2 : this.allPassphrases) {
                bl |= Arrays.areEqual((char[])cArray2, (char[])cArray);
            }
            if (!bl) {
                this.allPassphrases.add(cArray);
            }
            return this;
        }

        public DefaultKeyPassphraseProvider addPassphrase(OpenPGPKey openPGPKey, char[] cArray) {
            for (OpenPGPKey.OpenPGPSecretKey openPGPSecretKey : openPGPKey.getSecretKeys().values()) {
                if (!openPGPSecretKey.isLocked()) {
                    this.passphraseMap.put(openPGPSecretKey, null);
                    continue;
                }
                char[] cArray2 = this.passphraseMap.get(openPGPSecretKey);
                if (cArray2 != null && openPGPSecretKey.isPassphraseCorrect(cArray2)) continue;
                this.passphraseMap.put(openPGPSecretKey, cArray);
            }
            return this;
        }

        public DefaultKeyPassphraseProvider addPassphrase(OpenPGPKey.OpenPGPSecretKey openPGPSecretKey, char[] cArray) {
            if (!openPGPSecretKey.isLocked()) {
                this.passphraseMap.put(openPGPSecretKey, null);
                return this;
            }
            this.passphraseMap.put(openPGPSecretKey, cArray);
            return this;
        }

        public DefaultKeyPassphraseProvider setMissingPassphraseCallback(KeyPassphraseProvider keyPassphraseProvider) {
            this.callback = keyPassphraseProvider;
            return this;
        }
    }
}

