/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.util.UTCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenPGPDefaultPolicy
implements OpenPGPPolicy {
    private final Map<Integer, Date> documentHashAlgorithmCutoffDates = new HashMap<Integer, Date>();
    private final Map<Integer, Date> certificateHashAlgorithmCutoffDates = new HashMap<Integer, Date>();
    private final Map<Integer, Date> symmetricKeyAlgorithmCutoffDates = new HashMap<Integer, Date>();
    private final Map<Integer, Integer> publicKeyMinimalBitStrengths = new HashMap<Integer, Integer>();
    private int defaultDocumentSignatureHashAlgorithm = 10;
    private int defaultCertificationSignatureHashAlgorithm = 10;
    private int defaultSymmetricKeyAlgorithm = 7;

    public OpenPGPDefaultPolicy() {
        this.setDefaultCertificationSignatureHashAlgorithm(10);
        this.acceptCertificationSignatureHashAlgorithm(14);
        this.acceptCertificationSignatureHashAlgorithm(12);
        this.acceptCertificationSignatureHashAlgorithm(10);
        this.acceptCertificationSignatureHashAlgorithm(9);
        this.acceptCertificationSignatureHashAlgorithm(8);
        this.acceptCertificationSignatureHashAlgorithm(11);
        this.acceptCertificationSignatureHashAlgorithmUntil(2, UTCUtil.parse("2023-02-01 00:00:00 UTC"));
        this.acceptCertificationSignatureHashAlgorithmUntil(3, UTCUtil.parse("2023-02-01 00:00:00 UTC"));
        this.acceptCertificationSignatureHashAlgorithmUntil(1, UTCUtil.parse("1997-02-01 00:00:00 UTC"));
        this.setDefaultDocumentSignatureHashAlgorithm(10);
        this.acceptDocumentSignatureHashAlgorithm(14);
        this.acceptDocumentSignatureHashAlgorithm(12);
        this.acceptDocumentSignatureHashAlgorithm(10);
        this.acceptDocumentSignatureHashAlgorithm(9);
        this.acceptDocumentSignatureHashAlgorithm(8);
        this.acceptDocumentSignatureHashAlgorithm(11);
        this.setDefaultSymmetricKeyAlgorithm(7);
        this.acceptSymmetricKeyAlgorithm(9);
        this.acceptSymmetricKeyAlgorithm(8);
        this.acceptSymmetricKeyAlgorithm(7);
        this.acceptSymmetricKeyAlgorithm(10);
        this.acceptSymmetricKeyAlgorithm(13);
        this.acceptSymmetricKeyAlgorithm(12);
        this.acceptSymmetricKeyAlgorithm(11);
        this.acceptPublicKeyAlgorithmWithMinimalStrength(1, 2000);
        this.acceptPublicKeyAlgorithmWithMinimalStrength(2, 2000);
        this.acceptPublicKeyAlgorithmWithMinimalStrength(3, 2000);
        this.acceptPublicKeyAlgorithmWithMinimalStrength(19, 250);
        this.acceptPublicKeyAlgorithmWithMinimalStrength(22, 250);
        this.acceptPublicKeyAlgorithmWithMinimalStrength(18, 250);
        this.acceptPublicKeyAlgorithm(25);
        this.acceptPublicKeyAlgorithm(26);
        this.acceptPublicKeyAlgorithm(27);
        this.acceptPublicKeyAlgorithm(28);
    }

    @Override
    public boolean isAcceptableSigningKey(PGPPublicKey pGPPublicKey) {
        return this.isAcceptablePublicKey(pGPPublicKey);
    }

    @Override
    public boolean isAcceptableVerificationKey(PGPPublicKey pGPPublicKey) {
        return this.isAcceptablePublicKey(pGPPublicKey);
    }

    @Override
    public boolean isAcceptableEncryptionKey(PGPPublicKey pGPPublicKey) {
        return this.isAcceptablePublicKey(pGPPublicKey);
    }

    @Override
    public boolean isAcceptableDecryptionKey(PGPPublicKey pGPPublicKey) {
        return this.isAcceptablePublicKey(pGPPublicKey);
    }

    @Override
    public boolean isAcceptablePublicKey(PGPPublicKey pGPPublicKey) {
        return this.isAcceptablePublicKeyStrength(pGPPublicKey.getAlgorithm(), pGPPublicKey.getBitStrength());
    }

    @Override
    public boolean isAcceptableSignature(PGPSignature pGPSignature) {
        return this.hasAcceptableSignatureHashAlgorithm(pGPSignature) && this.hasNoCriticalUnknownNotations(pGPSignature) && this.hasNoCriticalUnknownSubpackets(pGPSignature);
    }

    @Override
    public boolean hasAcceptableSignatureHashAlgorithm(PGPSignature pGPSignature) {
        switch (pGPSignature.getSignatureType()) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 31: {
                return this.hasAcceptableCertificationSignatureHashAlgorithm(pGPSignature);
            }
            case 32: 
            case 40: 
            case 48: {
                return this.hasAcceptableRevocationSignatureHashAlgorithm(pGPSignature);
            }
        }
        return this.hasAcceptableDocumentSignatureHashAlgorithm(pGPSignature);
    }

    @Override
    public boolean hasAcceptableDocumentSignatureHashAlgorithm(PGPSignature pGPSignature) {
        return this.isAcceptableDocumentSignatureHashAlgorithm(pGPSignature.getHashAlgorithm(), pGPSignature.getCreationTime());
    }

    @Override
    public boolean hasAcceptableRevocationSignatureHashAlgorithm(PGPSignature pGPSignature) {
        return this.isAcceptableRevocationSignatureHashAlgorithm(pGPSignature.getHashAlgorithm(), pGPSignature.getCreationTime());
    }

    @Override
    public boolean hasAcceptableCertificationSignatureHashAlgorithm(PGPSignature pGPSignature) {
        return this.isAcceptableCertificationSignatureHashAlgorithm(pGPSignature.getHashAlgorithm(), pGPSignature.getCreationTime());
    }

    @Override
    public boolean hasNoCriticalUnknownNotations(PGPSignature pGPSignature) {
        NotationData[] notationDataArray;
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = pGPSignature.getHashedSubPackets();
        if (pGPSignatureSubpacketVector == null) {
            return true;
        }
        OpenPGPPolicy.OpenPGPNotationRegistry openPGPNotationRegistry = this.getNotationRegistry();
        for (NotationData notationData : notationDataArray = pGPSignatureSubpacketVector.getNotationDataOccurrences()) {
            if (!notationData.isCritical() || openPGPNotationRegistry.isNotationKnown(notationData.getNotationName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNoCriticalUnknownSubpackets(PGPSignature pGPSignature) {
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = pGPSignature.getHashedSubPackets();
        if (pGPSignatureSubpacketVector == null) {
            return true;
        }
        for (SignatureSubpacket signatureSubpacket : pGPSignatureSubpacketVector.toArray()) {
            if (!signatureSubpacket.isCritical() || !signatureSubpacket.getClass().equals(SignatureSubpacket.class) || this.isKnownSignatureSubpacket(signatureSubpacket.getType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isKnownSignatureSubpacket(int n) {
        return false;
    }

    public OpenPGPDefaultPolicy rejectHashAlgorithm(int n) {
        this.certificateHashAlgorithmCutoffDates.remove(n);
        this.documentHashAlgorithmCutoffDates.remove(n);
        return this;
    }

    public OpenPGPDefaultPolicy acceptCertificationSignatureHashAlgorithm(int n) {
        return this.acceptCertificationSignatureHashAlgorithmUntil(n, null);
    }

    public OpenPGPDefaultPolicy acceptCertificationSignatureHashAlgorithmUntil(int n, Date date) {
        this.certificateHashAlgorithmCutoffDates.put(n, date);
        return this;
    }

    public OpenPGPDefaultPolicy acceptDocumentSignatureHashAlgorithm(int n) {
        return this.acceptDocumentSignatureHashAlgorithmUntil(n, null);
    }

    public OpenPGPDefaultPolicy acceptDocumentSignatureHashAlgorithmUntil(int n, Date date) {
        this.documentHashAlgorithmCutoffDates.put(n, date);
        return this;
    }

    public OpenPGPDefaultPolicy rejectSymmetricKeyAlgorithm(int n) {
        this.symmetricKeyAlgorithmCutoffDates.remove(n);
        return this;
    }

    public OpenPGPDefaultPolicy acceptSymmetricKeyAlgorithm(int n) {
        return this.acceptSymmetricKeyAlgorithmUntil(n, null);
    }

    public OpenPGPDefaultPolicy acceptSymmetricKeyAlgorithmUntil(int n, Date date) {
        this.symmetricKeyAlgorithmCutoffDates.put(n, date);
        return this;
    }

    public OpenPGPDefaultPolicy rejectPublicKeyAlgorithm(int n) {
        this.publicKeyMinimalBitStrengths.remove(n);
        return this;
    }

    public OpenPGPDefaultPolicy acceptPublicKeyAlgorithm(int n) {
        this.publicKeyMinimalBitStrengths.put(n, null);
        return this;
    }

    public OpenPGPDefaultPolicy acceptPublicKeyAlgorithmWithMinimalStrength(int n, int n2) {
        this.publicKeyMinimalBitStrengths.put(n, n2);
        return this;
    }

    @Override
    public boolean isAcceptableDocumentSignatureHashAlgorithm(int n, Date date) {
        return this.isAcceptable(n, date, this.documentHashAlgorithmCutoffDates);
    }

    @Override
    public boolean isAcceptableRevocationSignatureHashAlgorithm(int n, Date date) {
        return this.isAcceptable(n, date, this.certificateHashAlgorithmCutoffDates);
    }

    @Override
    public boolean isAcceptableCertificationSignatureHashAlgorithm(int n, Date date) {
        return this.isAcceptable(n, date, this.certificateHashAlgorithmCutoffDates);
    }

    @Override
    public int getDefaultCertificationSignatureHashAlgorithm() {
        return this.defaultCertificationSignatureHashAlgorithm;
    }

    public OpenPGPDefaultPolicy setDefaultCertificationSignatureHashAlgorithm(int n) {
        this.defaultCertificationSignatureHashAlgorithm = n;
        return this;
    }

    @Override
    public int getDefaultDocumentSignatureHashAlgorithm() {
        return this.defaultDocumentSignatureHashAlgorithm;
    }

    public OpenPGPDefaultPolicy setDefaultDocumentSignatureHashAlgorithm(int n) {
        this.defaultDocumentSignatureHashAlgorithm = n;
        return this;
    }

    @Override
    public boolean isAcceptableSymmetricKeyAlgorithm(int n) {
        return this.isAcceptable(n, this.symmetricKeyAlgorithmCutoffDates);
    }

    @Override
    public int getDefaultSymmetricKeyAlgorithm() {
        return this.defaultSymmetricKeyAlgorithm;
    }

    public OpenPGPDefaultPolicy setDefaultSymmetricKeyAlgorithm(int n) {
        this.defaultSymmetricKeyAlgorithm = n;
        return this;
    }

    @Override
    public boolean isAcceptablePublicKeyStrength(int n, int n2) {
        return this.isAcceptable(n, n2, this.publicKeyMinimalBitStrengths);
    }

    @Override
    public OpenPGPPolicy.OpenPGPNotationRegistry getNotationRegistry() {
        return null;
    }

    private boolean isAcceptable(int n, Date date, Map<Integer, Date> map) {
        if (!map.containsKey(n)) {
            return false;
        }
        Date date2 = map.get(n);
        if (date2 == null) {
            return true;
        }
        return date.before(date2);
    }

    private boolean isAcceptable(int n, Map<Integer, Date> map) {
        return map.containsKey(n);
    }

    private boolean isAcceptable(int n, int n2, Map<Integer, Integer> map) {
        if (!map.containsKey(n)) {
            return false;
        }
        Integer n3 = map.get(n);
        if (n3 == null) {
            return true;
        }
        return n2 >= n3;
    }
}

