/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPadding;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureException;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.api.MessageEncryptionMechanism;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPMessageProcessor;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.OpenPGPSignature;

public class OpenPGPMessageInputStream
extends InputStream {
    public static int MAX_RECURSION = 16;
    private final PGPObjectFactory objectFactory;
    private final OpenPGPImplementation implementation;
    private final OpenPGPMessageProcessor processor;
    private final Result.Builder resultBuilder;
    private final Layer layer;
    private InputStream in;
    private final List<PacketHandler> packetHandlers = new ArrayList<PacketHandler>(){
        {
            this.add(new SignatureListHandler());
            this.add(new OnePassSignatureHandler());
            this.add(new MarkerHandler());
            this.add(new LiteralDataHandler());
            this.add(new CompressedDataHandler());
            this.add(new EncryptedDataHandler());
            this.add(new DefaultPacketHandler());
        }
    };
    private final List<PacketHandler> closeHandlers = new ArrayList<PacketHandler>(){
        {
            this.add(new SignatureListHandler());
            this.add(new PaddingHandler());
            this.add(new MarkerHandler());
            this.add(new DefaultPacketHandler());
        }
    };

    OpenPGPMessageInputStream(PGPObjectFactory pGPObjectFactory, OpenPGPMessageProcessor openPGPMessageProcessor) {
        this(pGPObjectFactory, openPGPMessageProcessor, Result.builder());
    }

    private OpenPGPMessageInputStream(PGPObjectFactory pGPObjectFactory, OpenPGPMessageProcessor openPGPMessageProcessor, Result.Builder builder) {
        this.objectFactory = pGPObjectFactory;
        this.processor = openPGPMessageProcessor;
        this.implementation = openPGPMessageProcessor.getImplementation();
        this.resultBuilder = builder;
        try {
            this.layer = builder.openLayer();
        }
        catch (PGPException pGPException) {
            throw new AssertionError((Object)pGPException);
        }
    }

    void process() throws IOException, PGPException {
        Object object;
        while ((object = this.objectFactory.nextObject()) != null) {
            for (PacketHandler packetHandler : this.packetHandlers) {
                if (!packetHandler.canHandle(object)) continue;
                packetHandler.handle(object);
                break;
            }
            if (this.in == null) continue;
            return;
        }
    }

    public void close() throws IOException {
        Object object;
        this.in.close();
        while ((object = this.objectFactory.nextObject()) != null) {
            boolean bl = false;
            for (PacketHandler packetHandler : this.closeHandlers) {
                if (!packetHandler.canHandle(object)) continue;
                packetHandler.close(object);
                bl = true;
                break;
            }
            if (bl) continue;
            this.processor.onException(new PGPException("Unexpected trailing packet encountered: " + object.getClass().getName()));
        }
        this.resultBuilder.verifySignatures(this.processor);
        this.resultBuilder.closeLayer();
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n >= 0) {
            this.layer.onePassSignatures.update(n);
            this.layer.prefixedSignatures.update(n);
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n >= 0) {
            this.layer.onePassSignatures.update(byArray, 0, n);
            this.layer.prefixedSignatures.update(byArray, 0, n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            this.layer.onePassSignatures.update(byArray, n, n3);
            this.layer.prefixedSignatures.update(byArray, n, n3);
        }
        return n3;
    }

    public Result getResult() {
        return this.resultBuilder.build();
    }

    static class CompressedData
    extends Nested {
        private final int compressionAlgorithm;

        public CompressedData(int n) {
            this.compressionAlgorithm = n;
        }
    }

    private class CompressedDataHandler
    extends PacketHandler {
        private CompressedDataHandler() {
        }

        public boolean canHandle(Object object) {
            return object instanceof PGPCompressedData;
        }

        public void handle(Object object) throws IOException, PGPException {
            PGPCompressedData pGPCompressedData = (PGPCompressedData)object;
            OpenPGPMessageInputStream.this.resultBuilder.compressed(pGPCompressedData.getAlgorithm());
            InputStream inputStream = pGPCompressedData.getDataStream();
            this.processNestedStream(inputStream);
        }

        private void processNestedStream(InputStream inputStream) throws IOException, PGPException {
            BCPGInputStream bCPGInputStream = BCPGInputStream.wrap(inputStream);
            PGPObjectFactory pGPObjectFactory = OpenPGPMessageInputStream.this.implementation.pgpObjectFactory(bCPGInputStream);
            OpenPGPMessageInputStream openPGPMessageInputStream = new OpenPGPMessageInputStream(pGPObjectFactory, OpenPGPMessageInputStream.this.processor, OpenPGPMessageInputStream.this.resultBuilder);
            OpenPGPMessageInputStream.this.in = openPGPMessageInputStream;
            openPGPMessageInputStream.process();
        }
    }

    private class DefaultPacketHandler
    extends PacketHandler {
        private DefaultPacketHandler() {
        }

        public boolean canHandle(Object object) {
            return true;
        }

        public void handle(Object object) throws PGPException {
            OpenPGPMessageInputStream.this.processor.onException(new PGPException("Unexpected packet: " + object.getClass().getName()));
        }
    }

    static class EncryptedData
    extends Nested {
        private final OpenPGPCertificate.OpenPGPComponentKey decryptionKey;
        private final char[] decryptionPassphrase;
        private final PGPSessionKey sessionKey;
        private final MessageEncryptionMechanism encryption;

        EncryptedData(OpenPGPMessageProcessor.Decrypted decrypted) {
            this.decryptionKey = decrypted.decryptionKey;
            this.decryptionPassphrase = decrypted.decryptionPassphrase;
            this.sessionKey = decrypted.sessionKey;
            if (decrypted.esk.getEncData() instanceof SymmetricEncIntegrityPacket) {
                SymmetricEncIntegrityPacket symmetricEncIntegrityPacket = (SymmetricEncIntegrityPacket)decrypted.esk.getEncData();
                this.encryption = symmetricEncIntegrityPacket.getVersion() == 2 ? MessageEncryptionMechanism.aead(symmetricEncIntegrityPacket.getCipherAlgorithm(), symmetricEncIntegrityPacket.getAeadAlgorithm()) : MessageEncryptionMechanism.integrityProtected(this.sessionKey.getAlgorithm());
            } else if (decrypted.esk.getEncData() instanceof AEADEncDataPacket) {
                this.encryption = MessageEncryptionMechanism.librePgp(this.sessionKey.getAlgorithm());
            } else {
                throw new RuntimeException("Unexpected encrypted data packet type: " + decrypted.esk.getClass().getName());
            }
        }
    }

    private class EncryptedDataHandler
    extends PacketHandler {
        private EncryptedDataHandler() {
        }

        public boolean canHandle(Object object) {
            return object instanceof PGPEncryptedDataList;
        }

        public void handle(Object object) throws IOException, PGPException {
            PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)object;
            OpenPGPMessageProcessor.Decrypted decrypted = OpenPGPMessageInputStream.this.processor.decrypt(pGPEncryptedDataList);
            OpenPGPMessageInputStream.this.resultBuilder.encrypted(decrypted);
            this.processNestedStream(decrypted.inputStream);
        }

        private void processNestedStream(InputStream inputStream) throws IOException, PGPException {
            BCPGInputStream bCPGInputStream = BCPGInputStream.wrap(inputStream);
            PGPObjectFactory pGPObjectFactory = OpenPGPMessageInputStream.this.implementation.pgpObjectFactory(bCPGInputStream);
            OpenPGPMessageInputStream openPGPMessageInputStream = new OpenPGPMessageInputStream(pGPObjectFactory, OpenPGPMessageInputStream.this.processor, OpenPGPMessageInputStream.this.resultBuilder);
            OpenPGPMessageInputStream.this.in = openPGPMessageInputStream;
            openPGPMessageInputStream.process();
        }
    }

    static class Layer {
        private final OnePassSignatures onePassSignatures = new OnePassSignatures();
        private final PrefixedSignatures prefixedSignatures = new PrefixedSignatures();
        private List<OpenPGPSignature.OpenPGPDocumentSignature> signatures = null;
        private Nested nested;
        private boolean open = true;

        Layer() {
        }

        void setNested(Nested nested) {
            this.nested = nested;
        }

        void close() {
            this.open = false;
        }

        boolean isOpen() {
            return this.open;
        }
    }

    static class LiteralData
    extends Nested {
        private final String filename;
        private final char encoding;
        private final Date modificationTime;

        LiteralData(String string, char c, Date date) {
            this.filename = string;
            this.encoding = c;
            this.modificationTime = date;
        }
    }

    private class LiteralDataHandler
    extends PacketHandler {
        private LiteralDataHandler() {
        }

        public boolean canHandle(Object object) {
            return object instanceof PGPLiteralData;
        }

        public void handle(Object object) throws IOException, PGPException {
            PGPLiteralData pGPLiteralData = (PGPLiteralData)object;
            OpenPGPMessageInputStream.this.resultBuilder.literalData(pGPLiteralData.getFileName(), (char)pGPLiteralData.getFormat(), pGPLiteralData.getModificationTime());
            OpenPGPMessageInputStream.this.in = pGPLiteralData.getDataStream();
            OpenPGPMessageInputStream.this.resultBuilder.initSignatures(OpenPGPMessageInputStream.this.processor);
        }
    }

    private static class MarkerHandler
    extends PacketHandler {
        private MarkerHandler() {
        }

        public boolean canHandle(Object object) {
            return object instanceof PGPMarker;
        }
    }

    static class Nested {
        Nested() {
        }
    }

    private class OnePassSignatureHandler
    extends PacketHandler {
        private OnePassSignatureHandler() {
        }

        public boolean canHandle(Object object) {
            return object instanceof PGPOnePassSignatureList;
        }

        public void handle(Object object) throws IOException, PGPException {
            PGPOnePassSignatureList pGPOnePassSignatureList = (PGPOnePassSignatureList)object;
            OpenPGPMessageInputStream.this.resultBuilder.onePassSignatures(pGPOnePassSignatureList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OnePassSignatures {
        private final List<PGPOnePassSignature> onePassSignatures = new ArrayList<PGPOnePassSignature>();
        private final List<PGPSignature> signatures = new ArrayList<PGPSignature>();
        private final Map<PGPOnePassSignature, OpenPGPCertificate.OpenPGPComponentKey> issuers = new HashMap<PGPOnePassSignature, OpenPGPCertificate.OpenPGPComponentKey>();

        OnePassSignatures() {
        }

        void addOnePassSignatures(PGPOnePassSignatureList pGPOnePassSignatureList) {
            Iterator<PGPOnePassSignature> iterator = pGPOnePassSignatureList.iterator();
            while (iterator.hasNext()) {
                PGPOnePassSignature pGPOnePassSignature = iterator.next();
                this.onePassSignatures.add(pGPOnePassSignature);
            }
        }

        void addSignatures(PGPSignatureList pGPSignatureList) {
            Iterator<PGPSignature> iterator = pGPSignatureList.iterator();
            while (iterator.hasNext()) {
                PGPSignature pGPSignature = iterator.next();
                this.signatures.add(pGPSignature);
            }
        }

        void init(OpenPGPMessageProcessor openPGPMessageProcessor) {
            for (PGPOnePassSignature pGPOnePassSignature : this.onePassSignatures) {
                KeyIdentifier keyIdentifier = pGPOnePassSignature.getKeyIdentifier();
                OpenPGPCertificate openPGPCertificate = openPGPMessageProcessor.provideCertificate(keyIdentifier);
                if (openPGPCertificate == null) continue;
                try {
                    OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey = openPGPCertificate.getKey(keyIdentifier);
                    this.issuers.put(pGPOnePassSignature, openPGPComponentKey);
                    pGPOnePassSignature.init(openPGPMessageProcessor.getImplementation().pgpContentVerifierBuilderProvider(), openPGPComponentKey.getPGPPublicKey());
                }
                catch (PGPException pGPException) {
                    openPGPMessageProcessor.onException(pGPException);
                }
            }
        }

        void update(int n) {
            for (PGPOnePassSignature pGPOnePassSignature : this.onePassSignatures) {
                if (!this.issuers.containsKey(pGPOnePassSignature)) continue;
                pGPOnePassSignature.update((byte)n);
            }
        }

        void update(byte[] byArray, int n, int n2) {
            for (PGPOnePassSignature pGPOnePassSignature : this.onePassSignatures) {
                if (!this.issuers.containsKey(pGPOnePassSignature)) continue;
                pGPOnePassSignature.update(byArray, n, n2);
            }
        }

        List<OpenPGPSignature.OpenPGPDocumentSignature> verify(OpenPGPMessageProcessor openPGPMessageProcessor) {
            OpenPGPPolicy openPGPPolicy = openPGPMessageProcessor.getImplementation().policy();
            ArrayList<OpenPGPSignature.OpenPGPDocumentSignature> arrayList = new ArrayList<OpenPGPSignature.OpenPGPDocumentSignature>();
            int n = this.onePassSignatures.size();
            for (int i = 0; i < this.signatures.size(); ++i) {
                PGPSignature pGPSignature = this.signatures.get(i);
                PGPOnePassSignature pGPOnePassSignature = this.onePassSignatures.get(n - i - 1);
                OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey = this.issuers.get(pGPOnePassSignature);
                if (openPGPComponentKey == null) continue;
                OpenPGPSignature.OpenPGPDocumentSignature openPGPDocumentSignature = new OpenPGPSignature.OpenPGPDocumentSignature(pGPSignature, openPGPComponentKey);
                try {
                    openPGPDocumentSignature.sanitize(openPGPComponentKey, openPGPPolicy);
                }
                catch (PGPSignatureException pGPSignatureException) {
                    // empty catch block
                }
                if (!openPGPDocumentSignature.createdInBounds(openPGPMessageProcessor.getVerifyNotBefore(), openPGPMessageProcessor.getVerifyNotAfter())) continue;
                try {
                    openPGPDocumentSignature.verify(pGPOnePassSignature);
                }
                catch (PGPException pGPException) {
                    openPGPMessageProcessor.onException(pGPException);
                }
                arrayList.add(openPGPDocumentSignature);
            }
            return arrayList;
        }
    }

    private static class PacketHandler {
        private PacketHandler() {
        }

        public boolean canHandle(Object object) {
            return false;
        }

        public void handle(Object object) throws IOException, PGPException {
        }

        public void close(Object object) throws IOException {
        }
    }

    private static class PaddingHandler
    extends PacketHandler {
        private PaddingHandler() {
        }

        public boolean canHandle(Object object) {
            return object instanceof PGPPadding;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrefixedSignatures {
        private final List<PGPSignature> prefixedSignatures = new ArrayList<PGPSignature>();
        private final List<OpenPGPSignature.OpenPGPDocumentSignature> dataSignatures = new ArrayList<OpenPGPSignature.OpenPGPDocumentSignature>();

        PrefixedSignatures() {
        }

        void addAll(PGPSignatureList pGPSignatureList) {
            Iterator<PGPSignature> iterator = pGPSignatureList.iterator();
            while (iterator.hasNext()) {
                PGPSignature pGPSignature = iterator.next();
                this.prefixedSignatures.add(pGPSignature);
            }
        }

        void init(OpenPGPMessageProcessor openPGPMessageProcessor) {
            for (PGPSignature pGPSignature : this.prefixedSignatures) {
                KeyIdentifier keyIdentifier = OpenPGPSignature.getMostExpressiveIdentifier(pGPSignature.getKeyIdentifiers());
                if (keyIdentifier == null) {
                    this.dataSignatures.add(new OpenPGPSignature.OpenPGPDocumentSignature(pGPSignature, null));
                    continue;
                }
                OpenPGPCertificate openPGPCertificate = openPGPMessageProcessor.provideCertificate(keyIdentifier);
                if (openPGPCertificate == null) {
                    this.dataSignatures.add(new OpenPGPSignature.OpenPGPDocumentSignature(pGPSignature, null));
                    continue;
                }
                OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey = openPGPCertificate.getKey(keyIdentifier);
                OpenPGPSignature.OpenPGPDocumentSignature openPGPDocumentSignature = new OpenPGPSignature.OpenPGPDocumentSignature(pGPSignature, openPGPComponentKey);
                this.dataSignatures.add(openPGPDocumentSignature);
                try {
                    openPGPDocumentSignature.signature.init(openPGPMessageProcessor.getImplementation().pgpContentVerifierBuilderProvider(), openPGPCertificate.getKey(keyIdentifier).getPGPPublicKey());
                }
                catch (PGPException pGPException) {
                    openPGPMessageProcessor.onException(pGPException);
                }
            }
        }

        void update(int n) {
            for (PGPSignature pGPSignature : this.prefixedSignatures) {
                pGPSignature.update((byte)n);
            }
        }

        void update(byte[] byArray, int n, int n2) {
            for (PGPSignature pGPSignature : this.prefixedSignatures) {
                pGPSignature.update(byArray, n, n2);
            }
        }

        List<OpenPGPSignature.OpenPGPDocumentSignature> verify(OpenPGPMessageProcessor openPGPMessageProcessor) {
            ArrayList<OpenPGPSignature.OpenPGPDocumentSignature> arrayList = new ArrayList<OpenPGPSignature.OpenPGPDocumentSignature>();
            OpenPGPPolicy openPGPPolicy = openPGPMessageProcessor.getImplementation().policy();
            for (OpenPGPSignature.OpenPGPDocumentSignature openPGPDocumentSignature : this.dataSignatures) {
                try {
                    openPGPDocumentSignature.sanitize(openPGPDocumentSignature.issuer, openPGPPolicy);
                }
                catch (PGPSignatureException pGPSignatureException) {
                    openPGPMessageProcessor.onException(pGPSignatureException);
                    continue;
                }
                try {
                    openPGPDocumentSignature.verify();
                }
                catch (PGPException pGPException) {
                    openPGPMessageProcessor.onException(pGPException);
                }
                arrayList.add(openPGPDocumentSignature);
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Result {
        private final List<OpenPGPSignature.OpenPGPDocumentSignature> documentSignatures = new ArrayList<OpenPGPSignature.OpenPGPDocumentSignature>();
        private OpenPGPCertificate.OpenPGPComponentKey decryptionKey;
        private char[] decryptionPassphrase;
        private PGPSessionKey sessionKey;
        private MessageEncryptionMechanism encryptionMethod = MessageEncryptionMechanism.unencrypted();
        private int compressionAlgorithm = 0;
        private String filename;
        private char fileFormat;
        private Date fileModificationTime;

        private Result(List<Layer> list) {
            for (Layer layer : list) {
                Nested nested;
                if (layer.signatures != null) {
                    this.documentSignatures.addAll(layer.signatures);
                }
                if (layer.nested instanceof EncryptedData) {
                    nested = (EncryptedData)layer.nested;
                    this.encryptionMethod = ((EncryptedData)nested).encryption;
                    this.sessionKey = ((EncryptedData)nested).sessionKey;
                    this.decryptionKey = ((EncryptedData)nested).decryptionKey;
                    this.decryptionPassphrase = ((EncryptedData)nested).decryptionPassphrase;
                    continue;
                }
                if (layer.nested instanceof CompressedData) {
                    nested = (CompressedData)layer.nested;
                    this.compressionAlgorithm = ((CompressedData)nested).compressionAlgorithm;
                    continue;
                }
                if (!(layer.nested instanceof LiteralData)) continue;
                nested = (LiteralData)layer.nested;
                this.filename = ((LiteralData)nested).filename;
                this.fileFormat = ((LiteralData)nested).encoding;
                this.fileModificationTime = ((LiteralData)nested).modificationTime;
            }
        }

        static Builder builder() {
            return new Builder();
        }

        public MessageEncryptionMechanism getEncryptionMethod() {
            return this.encryptionMethod;
        }

        public OpenPGPCertificate.OpenPGPComponentKey getDecryptionKey() {
            return this.decryptionKey;
        }

        public char[] getDecryptionPassphrase() {
            return this.decryptionPassphrase;
        }

        public PGPSessionKey getSessionKey() {
            return this.sessionKey;
        }

        public int getCompressionAlgorithm() {
            return this.compressionAlgorithm;
        }

        public String getFilename() {
            return this.filename;
        }

        public char getFileFormat() {
            return this.fileFormat;
        }

        public Date getFileModificationTime() {
            return this.fileModificationTime;
        }

        public List<OpenPGPSignature.OpenPGPDocumentSignature> getSignatures() {
            return new ArrayList<OpenPGPSignature.OpenPGPDocumentSignature>(this.documentSignatures);
        }

        static class Builder {
            private final List<Layer> layers = new ArrayList<Layer>();

            private Builder() {
            }

            Layer last() {
                return this.layers.get(this.layers.size() - 1);
            }

            Layer openLayer() throws PGPException {
                if (this.layers.size() >= MAX_RECURSION) {
                    throw new PGPException("Exceeded maximum packet nesting depth.");
                }
                Layer layer = new Layer();
                this.layers.add(layer);
                return layer;
            }

            void closeLayer() {
                for (int i = this.layers.size() - 1; i >= 0; --i) {
                    Layer layer = this.layers.get(i);
                    if (!layer.isOpen()) continue;
                    layer.close();
                    return;
                }
            }

            void compressed(int n) {
                this.last().setNested(new CompressedData(n));
            }

            void onePassSignatures(PGPOnePassSignatureList pGPOnePassSignatureList) {
                this.last().onePassSignatures.addOnePassSignatures(pGPOnePassSignatureList);
            }

            Result build() {
                return new Result(this.layers);
            }

            void prefixedSignatures(PGPSignatureList pGPSignatureList) {
                this.last().prefixedSignatures.addAll(pGPSignatureList);
            }

            void initSignatures(OpenPGPMessageProcessor openPGPMessageProcessor) {
                this.last().onePassSignatures.init(openPGPMessageProcessor);
                this.last().prefixedSignatures.init(openPGPMessageProcessor);
            }

            void verifySignatures(OpenPGPMessageProcessor openPGPMessageProcessor) {
                Layer layer = this.last();
                if (layer.signatures != null) {
                    return;
                }
                layer.signatures = new ArrayList();
                layer.signatures.addAll(layer.onePassSignatures.verify(openPGPMessageProcessor));
                layer.signatures.addAll(layer.prefixedSignatures.verify(openPGPMessageProcessor));
            }

            void literalData(String string, char c, Date date) {
                this.last().setNested(new LiteralData(string, c, date));
            }

            void encrypted(OpenPGPMessageProcessor.Decrypted decrypted) {
                this.last().setNested(new EncryptedData(decrypted));
            }
        }
    }

    private class SignatureListHandler
    extends PacketHandler {
        private SignatureListHandler() {
        }

        public boolean canHandle(Object object) {
            return object instanceof PGPSignatureList;
        }

        public void handle(Object object) {
            PGPSignatureList pGPSignatureList = (PGPSignatureList)object;
            OpenPGPMessageInputStream.this.resultBuilder.prefixedSignatures(pGPSignatureList);
        }

        public void close(Object object) {
            PGPSignatureList pGPSignatureList = (PGPSignatureList)object;
            OpenPGPMessageInputStream.this.resultBuilder.last().onePassSignatures.addSignatures(pGPSignatureList);
        }
    }
}

