/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureException;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.exception.MalformedOpenPGPSignatureException;
import org.bouncycastle.openpgp.api.util.UTCUtil;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OpenPGPSignature {
    protected final PGPSignature signature;
    protected final OpenPGPCertificate.OpenPGPComponentKey issuer;
    protected boolean isTested = false;
    protected boolean isCorrect = false;

    public OpenPGPSignature(PGPSignature pGPSignature, OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey) {
        this.signature = pGPSignature;
        this.issuer = openPGPComponentKey;
    }

    public PGPSignature getSignature() {
        return this.signature;
    }

    public OpenPGPCertificate.OpenPGPComponentKey getIssuer() {
        return this.issuer;
    }

    public OpenPGPCertificate getIssuerCertificate() {
        return this.issuer != null ? this.issuer.getCertificate() : null;
    }

    public List<KeyIdentifier> getKeyIdentifiers() {
        return this.signature.getKeyIdentifiers();
    }

    public KeyIdentifier getKeyIdentifier() {
        List<KeyIdentifier> list = this.getKeyIdentifiers();
        return OpenPGPSignature.getMostExpressiveIdentifier(list);
    }

    public static KeyIdentifier getMostExpressiveIdentifier(List<KeyIdentifier> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        for (KeyIdentifier keyIdentifier : list) {
            if (keyIdentifier.isWildcard() || keyIdentifier.getFingerprint() == null) continue;
            return keyIdentifier;
        }
        for (KeyIdentifier keyIdentifier : list) {
            if (keyIdentifier.isWildcard()) continue;
            return keyIdentifier;
        }
        return list.get(0);
    }

    public boolean isTestedCorrect() {
        return this.isTested && this.isCorrect;
    }

    public Date getCreationTime() {
        return this.signature.getCreationTime();
    }

    public Date getExpirationTime() {
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = this.signature.getHashedSubPackets();
        if (pGPSignatureSubpacketVector == null) {
            return null;
        }
        long l = pGPSignatureSubpacketVector.getSignatureExpirationTime();
        if (l < 0L) {
            throw new RuntimeException("Negative expiration time");
        }
        if (l == 0L) {
            return null;
        }
        return new Date(this.getCreationTime().getTime() + 1000L * l);
    }

    public boolean isEffectiveAt(Date date) {
        if (this.isHardRevocation()) {
            return true;
        }
        Date date2 = this.getCreationTime();
        Date date3 = this.getExpirationTime();
        return !date.before(date2) && (date3 == null || date.before(date3));
    }

    public boolean isHardRevocation() {
        return this.signature.isHardRevocation();
    }

    public boolean isCertification() {
        return this.signature.isCertification();
    }

    void sanitize(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey, OpenPGPPolicy openPGPPolicy) throws PGPSignatureException {
        int n;
        if (!openPGPPolicy.isAcceptablePublicKey(openPGPComponentKey.getPGPPublicKey())) {
            throw new PGPSignatureException("Unacceptable issuer key.");
        }
        if (!openPGPPolicy.hasAcceptableSignatureHashAlgorithm(this.signature)) {
            throw new PGPSignatureException("Unacceptable hash algorithm: " + this.signature.getHashAlgorithm());
        }
        if (this.signature.getVersion() < 4) {
            if (this.signature.getCreationTime().before(openPGPComponentKey.getCreationTime())) {
                throw new MalformedOpenPGPSignatureException(this, "Signature predates issuer key creation time.");
            }
            return;
        }
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = this.signature.getHashedSubPackets();
        if (pGPSignatureSubpacketVector == null) {
            throw new MalformedOpenPGPSignatureException(this, "Missing hashed signature subpacket area.");
        }
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector2 = this.signature.getUnhashedSubPackets();
        if (pGPSignatureSubpacketVector.getSignatureCreationTime() == null) {
            throw new MalformedOpenPGPSignatureException(this, "Signature does not have a hashed SignatureCreationTime subpacket.");
        }
        if (pGPSignatureSubpacketVector.getSignatureCreationTime().before(openPGPComponentKey.getCreationTime())) {
            throw new MalformedOpenPGPSignatureException(this, "Signature predates issuer key creation time.");
        }
        NotationData[] notationDataArray = pGPSignatureSubpacketVector.getNotationDataOccurrences();
        for (int i = 0; i < notationDataArray.length; ++i) {
            NotationData notationData = notationDataArray[i];
            if (!notationData.isCritical()) continue;
            throw new MalformedOpenPGPSignatureException(this, "Critical unknown NotationData encountered: " + notationData.getNotationName());
        }
        SignatureSubpacket[] signatureSubpacketArray = pGPSignatureSubpacketVector.toArray();
        for (n = 0; n != signatureSubpacketArray.length; ++n) {
            SignatureSubpacket signatureSubpacket = signatureSubpacketArray[n];
            if (!signatureSubpacket.isCritical() || !signatureSubpacket.getClass().equals(SignatureSubpacket.class)) continue;
            throw new MalformedOpenPGPSignatureException(this, "Critical hashed unknown SignatureSubpacket encountered: " + signatureSubpacket.getType());
        }
        switch (this.signature.getVersion()) {
            case 4: 
            case 5: {
                if (pGPSignatureSubpacketVector.getIssuerFingerprint() != null || pGPSignatureSubpacketVector2.getIssuerFingerprint() != null || pGPSignatureSubpacketVector.getSubpacket(16) != null || pGPSignatureSubpacketVector2.getSubpacket(16) != null || (n = this.signature.getSignatureType()) == 24 || n == 25) break;
                throw new MalformedOpenPGPSignatureException(this, "Missing IssuerKeyID and IssuerFingerprint subpacket.");
            }
            case 6: {
                if (pGPSignatureSubpacketVector.getSubpacket(16) != null) {
                    throw new MalformedOpenPGPSignatureException(this, "v6 signature MUST NOT contain IssuerKeyID subpacket.");
                }
                if (pGPSignatureSubpacketVector.getIssuerFingerprint() != null || pGPSignatureSubpacketVector2.getIssuerFingerprint() != null) break;
                throw new MalformedOpenPGPSignatureException(this, "v6 signature MUST contain IssuerFingerprint subpacket.");
            }
        }
    }

    public boolean isRevocation() {
        return PGPSignature.isRevocation(this.signature.getSignatureType());
    }

    public String toString() {
        String string = this.getIssuerDisplay();
        String string2 = UTCUtil.format(this.getCreationTime()) + (this.getExpirationTime() == null ? "" : ">" + UTCUtil.format(this.getExpirationTime()));
        String string3 = this.isTested ? (this.isCorrect ? "\u2713" : "\u2717") : "\u2753";
        return this.getType() + (this.signature.isHardRevocation() ? "(hard)" : "") + " " + Hex.toHexString((byte[])this.signature.getDigestPrefix()) + " " + string + " -> " + this.getTargetDisplay() + " (" + string2 + ") " + string3;
    }

    protected String getIssuerDisplay() {
        if (this.issuer != null) {
            return this.issuer.toString();
        }
        KeyIdentifier keyIdentifier = this.getKeyIdentifier();
        if (keyIdentifier == null) {
            return "External[unknown]";
        }
        if (keyIdentifier.isWildcard()) {
            return "Anonymous";
        }
        return "External[" + Long.toHexString(keyIdentifier.getKeyId()).toUpperCase(Locale.getDefault()) + "]";
    }

    protected abstract String getTargetDisplay();

    protected String getType() {
        switch (this.signature.getSignatureType()) {
            case 0: {
                return "BINARY_DOCUMENT";
            }
            case 1: {
                return "CANONICAL_TEXT_DOCUMENT";
            }
            case 2: {
                return "STANDALONE";
            }
            case 16: {
                return "DEFAULT_CERTIFICATION";
            }
            case 17: {
                return "NO_CERTIFICATION";
            }
            case 18: {
                return "CASUAL_CERTIFICATION";
            }
            case 19: {
                return "POSITIVE_CERTIFICATION";
            }
            case 24: {
                return "SUBKEY_BINDING";
            }
            case 25: {
                return "PRIMARYKEY_BINDING";
            }
            case 31: {
                return "DIRECT_KEY";
            }
            case 32: {
                return "KEY_REVOCATION";
            }
            case 40: {
                return "SUBKEY_REVOCATION";
            }
            case 48: {
                return "CERTIFICATION_REVOCATION";
            }
            case 64: {
                return "TIMESTAMP";
            }
            case 80: {
                return "THIRD_PARTY_CONFIRMATION";
            }
        }
        return "UNKNOWN (" + this.signature.getSignatureType() + ")";
    }

    public String toAsciiArmoredString() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArmoredOutputStream.Builder builder = ArmoredOutputStream.builder().clearHeaders();
        if (this.getKeyIdentifier() != null) {
            builder.addSplitMultilineComment(this.getKeyIdentifier().toPrettyPrint());
        }
        ArmoredOutputStream armoredOutputStream = builder.build(byteArrayOutputStream);
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream((OutputStream)armoredOutputStream, PacketFormat.CURRENT);
        this.getSignature().encode(bCPGOutputStream);
        bCPGOutputStream.close();
        armoredOutputStream.close();
        return byteArrayOutputStream.toString();
    }

    public static class OpenPGPDocumentSignature
    extends OpenPGPSignature {
        protected final OpenPGPDocumentSignature attestedSignature;

        public OpenPGPDocumentSignature(PGPSignature pGPSignature, OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey) {
            super(pGPSignature, openPGPComponentKey);
            this.attestedSignature = null;
        }

        protected String getTargetDisplay() {
            return "<document>";
        }

        public OpenPGPDocumentSignature(PGPSignature pGPSignature, OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey, OpenPGPDocumentSignature openPGPDocumentSignature) {
            super(pGPSignature, openPGPComponentKey);
            this.attestedSignature = openPGPDocumentSignature;
        }

        public int getSignatureLevel() {
            if (this.attestedSignature == null) {
                return 0;
            }
            return 1 + this.attestedSignature.getSignatureLevel();
        }

        public OpenPGPDocumentSignature getAttestedSignature() {
            return this.attestedSignature;
        }

        public boolean verify(PGPOnePassSignature pGPOnePassSignature) throws PGPException {
            this.isTested = true;
            this.isCorrect = pGPOnePassSignature.verify(this.signature);
            return this.isCorrect;
        }

        public boolean verify() throws PGPException {
            this.isTested = true;
            this.isCorrect = this.signature.verify();
            return this.isCorrect;
        }

        public boolean isValid() throws PGPSignatureException {
            return this.isValid(OpenPGPImplementation.getInstance().policy());
        }

        public boolean isValid(OpenPGPPolicy openPGPPolicy) throws PGPSignatureException {
            return this.isValidAt(this.getCreationTime(), openPGPPolicy);
        }

        public boolean isValidAt(Date date) throws PGPSignatureException {
            return this.isValidAt(date, OpenPGPImplementation.getInstance().policy());
        }

        public boolean isValidAt(Date date, OpenPGPPolicy openPGPPolicy) throws PGPSignatureException {
            if (!this.isTested) {
                throw new IllegalStateException("Signature has not yet been verified.");
            }
            if (!this.isTestedCorrect()) {
                return false;
            }
            this.sanitize(this.issuer, openPGPPolicy);
            return this.issuer.getCertificate().getPrimaryKey().isBoundAt(date) && this.issuer.isBoundAt(date) && this.issuer.isSigningKey(date);
        }

        public boolean createdInBounds(Date date, Date date2) {
            return !this.getCreationTime().before(date) && !this.getCreationTime().after(date2);
        }
    }

    public static final class OpenPGPSignatureSubpacket {
        private final SignatureSubpacket subpacket;
        private final OpenPGPSignature signature;
        private final boolean hashed;

        private OpenPGPSignatureSubpacket(SignatureSubpacket signatureSubpacket, OpenPGPSignature openPGPSignature, boolean bl) {
            this.signature = openPGPSignature;
            this.subpacket = signatureSubpacket;
            this.hashed = bl;
        }

        public static OpenPGPSignatureSubpacket hashed(SignatureSubpacket signatureSubpacket, OpenPGPSignature openPGPSignature) {
            return new OpenPGPSignatureSubpacket(signatureSubpacket, openPGPSignature, true);
        }

        public static OpenPGPSignatureSubpacket unhashed(SignatureSubpacket signatureSubpacket, OpenPGPSignature openPGPSignature) {
            return new OpenPGPSignatureSubpacket(signatureSubpacket, openPGPSignature, false);
        }

        public OpenPGPSignature getSignature() {
            return this.signature;
        }

        public SignatureSubpacket getSubpacket() {
            return this.subpacket;
        }

        public boolean isHashed() {
            return this.hashed;
        }
    }
}

