/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api.jcajce;

import java.security.Provider;
import java.security.SecureRandom;
import java.util.Date;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.api.OpenPGPApi;
import org.bouncycastle.openpgp.api.OpenPGPKeyGenerator;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.jcajce.JcaOpenPGPImplementation;
import org.bouncycastle.openpgp.api.jcajce.JcaOpenPGPKeyGenerator;

public class JcaOpenPGPApi
extends OpenPGPApi {
    private final Provider provider;

    public JcaOpenPGPApi(Provider provider) {
        this(provider, CryptoServicesRegistrar.getSecureRandom());
    }

    public JcaOpenPGPApi(Provider provider, SecureRandom secureRandom) {
        super(new JcaOpenPGPImplementation(provider, secureRandom));
        this.provider = provider;
    }

    public JcaOpenPGPApi(Provider provider, OpenPGPPolicy openPGPPolicy) {
        this(provider, CryptoServicesRegistrar.getSecureRandom(), openPGPPolicy);
    }

    public JcaOpenPGPApi(Provider provider, SecureRandom secureRandom, OpenPGPPolicy openPGPPolicy) {
        super(new JcaOpenPGPImplementation(provider, secureRandom), openPGPPolicy);
        this.provider = provider;
    }

    public OpenPGPKeyGenerator generateKey(int n) throws PGPException {
        return new JcaOpenPGPKeyGenerator(n, this.provider);
    }

    public OpenPGPKeyGenerator generateKey(int n, Date date) throws PGPException {
        return new JcaOpenPGPKeyGenerator(n, date, this.provider);
    }

    public OpenPGPKeyGenerator generateKey(int n, Date date, boolean bl) throws PGPException {
        return new JcaOpenPGPKeyGenerator(n, date, bl, this.provider);
    }
}

