/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;

public class BcCFBSecretKeyEncryptorFactory
implements PBESecretKeyEncryptorFactory {
    private final int symmetricKeyAlgorithm;
    private final int iterationCount;

    public BcCFBSecretKeyEncryptorFactory(int n, int n2) {
        this.symmetricKeyAlgorithm = n;
        this.iterationCount = n2;
    }

    public PBESecretKeyEncryptor build(char[] cArray, PublicKeyPacket publicKeyPacket) {
        PGPDigestCalculator pGPDigestCalculator;
        if (cArray == null) {
            return null;
        }
        try {
            pGPDigestCalculator = new BcPGPDigestCalculatorProvider().get(8);
        }
        catch (PGPException pGPException) {
            throw new RuntimeException(pGPException);
        }
        return new BcPBESecretKeyEncryptorBuilder(this.symmetricKeyAlgorithm, pGPDigestCalculator, this.iterationCount).build(cArray);
    }
}

