/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.Provider;
import java.security.SecureRandom;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;

public class JcaPGPContentSignerBuilderProvider
extends PGPContentSignerBuilderProvider {
    private Provider digestProvider;
    private Provider securityProvider;
    private SecureRandom secureRandom;

    public JcaPGPContentSignerBuilderProvider(int n) {
        super(n);
    }

    public JcaPGPContentSignerBuilderProvider setDigestProvider(Provider provider) {
        this.digestProvider = provider;
        return this;
    }

    public JcaPGPContentSignerBuilderProvider setSecurityProvider(Provider provider) {
        this.securityProvider = provider;
        return this;
    }

    public JcaPGPContentSignerBuilderProvider setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public PGPContentSignerBuilder get(PGPPublicKey pGPPublicKey) {
        JcaPGPContentSignerBuilder jcaPGPContentSignerBuilder = new JcaPGPContentSignerBuilder(pGPPublicKey.getAlgorithm(), this.hashAlgorithmId);
        if (this.digestProvider != null) {
            jcaPGPContentSignerBuilder.setDigestProvider(this.digestProvider);
        }
        if (this.securityProvider != null) {
            jcaPGPContentSignerBuilder.setProvider(this.securityProvider);
        }
        if (this.secureRandom != null) {
            jcaPGPContentSignerBuilder.setSecureRandom(this.secureRandom);
        }
        return jcaPGPContentSignerBuilder;
    }
}

