/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParametersHolder;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.gpg.SExpression;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.ExtendedPGPSecretKey;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPExtendedKeyAttribute;
import org.bouncycastle.openpgp.PGPExtendedKeyHeader;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPSecretKeyDecryptorWithAAD;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;

public class OpenedPGPKeyData {
    private final List<PGPExtendedKeyHeader> headerList;
    private final SExpression keyExpression;

    public OpenedPGPKeyData(List<PGPExtendedKeyHeader> headerList, SExpression keyExpression) {
        this.headerList = Collections.unmodifiableList(headerList);
        this.keyExpression = keyExpression;
    }

    public List<PGPExtendedKeyHeader> getHeaderList() {
        return this.headerList;
    }

    public SExpression getKeyExpression() {
        return this.keyExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKeyType() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExtendedPGPSecretKey getKeyData(PGPPublicKey publicKey, PGPDigestCalculatorProvider digestCalculatorProvider, PBEProtectionRemoverFactory keyProtectionRemoverFactory, KeyFingerPrintCalculator fingerPrintCalculator, int maxDepth) throws PGPException, IOException {
        UnwrapResult unwrapResult;
        String type = this.keyExpression.getString(0);
        ArrayList<PGPExtendedKeyAttribute> attributeList = new ArrayList<PGPExtendedKeyAttribute>();
        if (!type.equals("shadowed-private-key") && !type.equals("protected-private-key") && !type.equals("private-key")) return null;
        SExpression keyExpression = this.getKeyExpression().getExpression(1);
        if (keyExpression.hasLabel("ecc")) {
            UnwrapResult unwrapResult2;
            PGPPublicKey pgpPublicKeyFound = this.getECCPublicKey(keyExpression, fingerPrintCalculator);
            if (publicKey != null && pgpPublicKeyFound != null) {
                ECPublicBCPGKey basePubKey = (ECPublicBCPGKey)publicKey.getPublicKeyPacket().getKey();
                ECPublicBCPGKey assocPubKey = (ECPublicBCPGKey)pgpPublicKeyFound.getPublicKeyPacket().getKey();
                if (!basePubKey.getCurveOID().equals((ASN1Primitive)assocPubKey.getCurveOID()) || !basePubKey.getEncodedPoint().equals(assocPubKey.getEncodedPoint())) {
                    throw new PGPException("passed in public key does not match secret key");
                }
            }
            publicKey = pgpPublicKeyFound;
            if (type.equals("shadowed-private-key")) {
                unwrapResult2 = null;
            } else if (type.equals("protected-private-key")) {
                SExpression protectedKey = keyExpression.getExpressionWithLabel("protected");
                if (protectedKey == null) {
                    throw new IllegalArgumentException(type + " does not have protected block");
                }
                String protectionType = protectedKey.getString(1);
                if (protectionType.indexOf("aes") < 0) throw new PGPException("unsupported protection type");
                unwrapResult2 = this.unwrapECCSecretKey(protectionType, publicKey, maxDepth, keyExpression, protectedKey, keyProtectionRemoverFactory);
            } else {
                SExpression curveExpr = keyExpression.getExpressionWithLabel("curve");
                if (curveExpr == null) {
                    throw new IllegalStateException("no curve expression");
                }
                String curve = curveExpr.getString(1);
                unwrapResult2 = new UnwrapResult(keyExpression, null, null, curve);
            }
            BigInteger d = new BigInteger(1, unwrapResult2.expression.getExpressionWithLabelOrFail("d").getBytes(1));
            if (unwrapResult2.metaData == null) {
                throw new IllegalStateException("expecting unwrap result to have meta data defining the curve");
            }
            String curve = unwrapResult2.metaData.toString();
            BCPGObject key = curve.startsWith("NIST") || curve.startsWith("brain") ? new ECSecretBCPGKey(d) : new EdSecretBCPGKey(d);
            return new ExtendedPGPSecretKey(this.headerList, attributeList, new SecretKeyPacket(publicKey.getPublicKeyPacket(), 0, unwrapResult2.s2K, unwrapResult2.iv, key.getEncoded()), publicKey);
        }
        if (keyExpression.hasLabel("elg")) {
            UnwrapResult unwrapResult3;
            PGPPublicKey pgpPublicKeyFound = this.getDSAPublicKey(keyExpression, fingerPrintCalculator);
            if (publicKey != null && pgpPublicKeyFound != null) {
                ElGamalPublicBCPGKey basePubKey = (ElGamalPublicBCPGKey)publicKey.getPublicKeyPacket().getKey();
                ElGamalPublicBCPGKey assocPubKey = (ElGamalPublicBCPGKey)pgpPublicKeyFound.getPublicKeyPacket().getKey();
                if (!(basePubKey.getP().equals(assocPubKey.getP()) && basePubKey.getG().equals(assocPubKey.getG()) && basePubKey.getY().equals(assocPubKey.getY()))) {
                    throw new PGPException("passed in public key does not match secret key");
                }
            }
            publicKey = pgpPublicKeyFound;
            if (type.equals("shadowed-private-key")) {
                unwrapResult3 = null;
            } else {
                if (type.equals("protected-private-key")) {
                    SExpression protectedKey = keyExpression.getExpressionWithLabel("protected");
                    if (protectedKey == null) {
                        throw new IllegalArgumentException(type + " does not have protected block");
                    }
                    String protectionType = protectedKey.getString(1);
                    if (protectionType.indexOf("aes") < 0) throw new PGPException("unsupported protection type");
                    throw new IllegalStateException("no decryption support for protected elgamal keys");
                }
                unwrapResult3 = new UnwrapResult(keyExpression, null, null);
            }
            BigInteger x = BigIntegers.fromUnsignedByteArray((byte[])unwrapResult3.expression.getExpressionWithLabelOrFail("x").getBytes(1));
            if (!keyExpression.hasLabel("elg")) return new ExtendedPGPSecretKey(this.headerList, attributeList, new SecretKeyPacket(publicKey.getPublicKeyPacket(), 0, unwrapResult3.s2K, unwrapResult3.iv, new DSASecretBCPGKey(x).getEncoded()), publicKey);
            return new ExtendedPGPSecretKey(this.headerList, attributeList, new SecretKeyPacket(publicKey.getPublicKeyPacket(), 0, unwrapResult3.s2K, unwrapResult3.iv, new ElGamalSecretBCPGKey(x).getEncoded()), publicKey);
        }
        if (keyExpression.hasLabel("dsa")) {
            UnwrapResult unwrapResult4;
            PGPPublicKey pgpPublicKeyFound = this.getDSAPublicKey(keyExpression, fingerPrintCalculator);
            if (publicKey != null && pgpPublicKeyFound != null) {
                DSAPublicBCPGKey basePubKey = (DSAPublicBCPGKey)publicKey.getPublicKeyPacket().getKey();
                DSAPublicBCPGKey assocPubKey = (DSAPublicBCPGKey)pgpPublicKeyFound.getPublicKeyPacket().getKey();
                if (!(basePubKey.getP().equals(assocPubKey.getP()) && basePubKey.getQ().equals(assocPubKey.getQ()) && basePubKey.getG().equals(assocPubKey.getG()) && basePubKey.getY().equals(assocPubKey.getY()))) {
                    throw new PGPException("passed in public key does not match secret key");
                }
            }
            publicKey = pgpPublicKeyFound;
            if (type.equals("shadowed-private-key")) {
                unwrapResult4 = null;
            } else if (type.equals("protected-private-key")) {
                SExpression protectedKey = keyExpression.getExpressionWithLabel("protected");
                if (protectedKey == null) {
                    throw new IllegalArgumentException(type + " does not have protected block");
                }
                String protectionType = protectedKey.getString(1);
                if (protectionType.indexOf("aes") < 0) throw new PGPException("unsupported protection type");
                unwrapResult4 = this.unwrapDSASecretKey(protectionType, publicKey, maxDepth, keyExpression, protectedKey, keyProtectionRemoverFactory);
            } else {
                unwrapResult4 = new UnwrapResult(keyExpression, null, null);
            }
            BigInteger x = BigIntegers.fromUnsignedByteArray((byte[])unwrapResult4.expression.getExpressionWithLabelOrFail("x").getBytes(1));
            return new ExtendedPGPSecretKey(this.headerList, attributeList, new SecretKeyPacket(publicKey.getPublicKeyPacket(), 0, unwrapResult4.s2K, unwrapResult4.iv, new DSASecretBCPGKey(x).getEncoded()), publicKey);
        }
        if (!keyExpression.hasLabel("rsa")) return null;
        PGPPublicKey pgpPublicKeyFound = this.getRSAPublicKey(keyExpression, fingerPrintCalculator);
        if (publicKey != null && pgpPublicKeyFound != null) {
            RSAPublicBCPGKey basePubKey = (RSAPublicBCPGKey)publicKey.getPublicKeyPacket().getKey();
            RSAPublicBCPGKey assocPubKey = (RSAPublicBCPGKey)pgpPublicKeyFound.getPublicKeyPacket().getKey();
            if (!basePubKey.getModulus().equals(assocPubKey.getModulus()) || !basePubKey.getPublicExponent().equals(assocPubKey.getPublicExponent())) {
                throw new PGPException("passed in public key does not match secret key");
            }
        }
        publicKey = pgpPublicKeyFound;
        if (type.equals("shadowed-private-key")) {
            unwrapResult = null;
        } else if (type.equals("protected-private-key")) {
            SExpression protectedKey = keyExpression.getExpressionWithLabel("protected");
            if (protectedKey == null) {
                throw new IllegalArgumentException(type + " does not have protected block");
            }
            String protectionType = protectedKey.getString(1);
            if (protectionType.indexOf("aes") < 0) throw new PGPException("unsupported protection type");
            unwrapResult = this.unwrapRSASecretKey(protectionType, publicKey, maxDepth, keyExpression, protectedKey, keyProtectionRemoverFactory);
        } else {
            unwrapResult = new UnwrapResult(keyExpression, null, null);
        }
        for (Object o : keyExpression.filterOut("rsa", "e", "n", "d", "p", "q", "u", "protected").getValues()) {
            if (o instanceof SExpression) {
                attributeList.add(((SExpression)o).toAttribute());
                continue;
            }
            attributeList.add(PGPExtendedKeyAttribute.builder().addAttribute(o).build());
        }
        if (unwrapResult == null) {
            return new ExtendedPGPSecretKey(this.headerList, attributeList, null, publicKey);
        }
        BigInteger d = BigIntegers.fromUnsignedByteArray((byte[])unwrapResult.expression.getExpressionWithLabelOrFail("d").getBytes(1));
        BigInteger p = BigIntegers.fromUnsignedByteArray((byte[])unwrapResult.expression.getExpressionWithLabelOrFail("p").getBytes(1));
        BigInteger q = BigIntegers.fromUnsignedByteArray((byte[])unwrapResult.expression.getExpressionWithLabelOrFail("q").getBytes(1));
        return new ExtendedPGPSecretKey(this.headerList, attributeList, new SecretKeyPacket(publicKey.getPublicKeyPacket(), 0, unwrapResult.s2K, unwrapResult.iv, new RSASecretBCPGKey(d, p, q).getEncoded()), publicKey);
    }

    private UnwrapResult unwrapDSASecretKey(String protectionType, PGPPublicKey publicKey, int maxDepth, SExpression keyExpression, SExpression protectedKey, PBEProtectionRemoverFactory keyProtectionRemoverFactory) throws PGPException, IOException {
        if (protectionType.equals("openpgp-s2k3-sha1-aes-cbc")) {
            throw new IllegalArgumentException("openpgp-s2k3-sha1-aes-cbc not supported on newer key type");
        }
        if (protectionType.equals("openpgp-s2k3-ocb-aes")) {
            SExpression.Builder builder = SExpression.builder().addValue("dsa");
            this.addPublicKey(publicKey, builder);
            builder.addContent(keyExpression.filterOut("dsa", "p", "q", "g", "y", "protected"));
            byte[] aad = builder.build().toCanonicalForm();
            SExpression protectionKeyParameters = protectedKey.getExpression(2);
            SExpression s2kParams = protectionKeyParameters.getExpression(0);
            S2K s2K = new S2K(PGPUtil.getDigestIDForName(s2kParams.getString(0)), s2kParams.getBytes(1), s2kParams.getInt(2));
            byte[] nonce = protectionKeyParameters.getBytes(1);
            PBESecretKeyDecryptor decryptor = keyProtectionRemoverFactory.createDecryptor("ocb");
            byte[] key = decryptor.makeKeyFromPassPhrase(7, s2K);
            byte[] keyData = protectedKey.getBytes(3);
            return new UnwrapResult(SExpression.parse(((PGPSecretKeyDecryptorWithAAD)decryptor).recoverKeyData(7, key, nonce, aad, keyData, 0, keyData.length), maxDepth).getExpression(0), s2K, Arrays.clone((byte[])nonce));
        }
        throw new PGPException("unhandled protection type " + protectionType);
    }

    private UnwrapResult unwrapECCSecretKey(String protectionType, PGPPublicKey publicKey, int maxDepth, SExpression keyExpression, SExpression protectedKey, PBEProtectionRemoverFactory keyProtectionRemoverFactory) throws PGPException, IOException {
        if (protectionType.equals("openpgp-s2k3-sha1-aes-cbc")) {
            throw new IllegalArgumentException("openpgp-s2k3-sha1-aes-cbc not supported on newer key type");
        }
        if (protectionType.equals("openpgp-s2k3-ocb-aes")) {
            SExpression.Builder builder = SExpression.builder().addValue("ecc");
            builder.addContent(keyExpression.filterIn("curve", "flags"));
            this.addPublicKey(publicKey, builder);
            builder.addContent(keyExpression.filterOut("ecc", "flags", "curve", "q", "protected"));
            byte[] aad = builder.build().toCanonicalForm();
            SExpression curveExpr = keyExpression.getExpressionWithLabel("curve");
            if (curveExpr == null) {
                throw new IllegalStateException("no curve expression");
            }
            String curve = curveExpr.getString(1);
            SExpression protectionKeyParameters = protectedKey.getExpression(2);
            SExpression s2kParams = protectionKeyParameters.getExpression(0);
            S2K s2K = new S2K(PGPUtil.getDigestIDForName(s2kParams.getString(0)), s2kParams.getBytes(1), s2kParams.getInt(2));
            byte[] nonce = protectionKeyParameters.getBytes(1);
            PBESecretKeyDecryptor decryptor = keyProtectionRemoverFactory.createDecryptor("ocb");
            byte[] key = decryptor.makeKeyFromPassPhrase(7, s2K);
            byte[] keyData = protectedKey.getBytes(3);
            return new UnwrapResult(SExpression.parse(((PGPSecretKeyDecryptorWithAAD)decryptor).recoverKeyData(7, key, nonce, aad, keyData, 0, keyData.length), maxDepth).getExpression(0), s2K, Arrays.clone((byte[])nonce), curve);
        }
        throw new PGPException("unhandled protection type " + protectionType);
    }

    private PGPPublicKey getECCPublicKey(SExpression expression, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        PublicKeyPacket publicKeyPacket;
        EdDSAPublicBCPGKey basePubKey;
        byte[] qoint = null;
        String curve = null;
        for (Object item : expression.getValues()) {
            if (!(item instanceof SExpression)) continue;
            SExpression exp = (SExpression)item;
            if (exp.hasLabel("curve")) {
                curve = exp.getString(1);
                continue;
            }
            if (!exp.hasLabel("q")) continue;
            qoint = exp.getBytes(1);
        }
        if (curve == null || qoint == null) {
            return null;
        }
        if (curve.startsWith("Curve")) {
            curve = Strings.toLowerCase((String)curve);
        } else if (curve.startsWith("NIST")) {
            curve = curve.substring("NIST".length()).trim();
        }
        if (Strings.toLowerCase((String)curve).equals("ed25519")) {
            basePubKey = new EdDSAPublicBCPGKey(EdECObjectIdentifiers.id_Ed25519, new BigInteger(1, qoint));
            publicKeyPacket = new PublicKeyPacket(22, new Date(), basePubKey);
        } else if (Strings.toLowerCase((String)curve).equals("ed448")) {
            basePubKey = new EdDSAPublicBCPGKey(EdECObjectIdentifiers.id_Ed448, new BigInteger(1, qoint));
            publicKeyPacket = new PublicKeyPacket(22, new Date(), basePubKey);
        } else {
            ASN1ObjectIdentifier oid = ECNamedCurveTable.getOID((String)curve);
            X9ECParametersHolder holder = CustomNamedCurves.getByNameLazy((String)curve);
            if (holder == null) {
                holder = TeleTrusTNamedCurves.getByOIDLazy((ASN1ObjectIdentifier)oid);
            }
            if (holder == null) {
                throw new IllegalStateException("unable to resolve parameters for " + curve);
            }
            ECPoint pnt = holder.getCurve().decodePoint(qoint);
            ECDSAPublicBCPGKey basePubKey2 = new ECDSAPublicBCPGKey(oid, pnt);
            publicKeyPacket = new PublicKeyPacket(19, new Date(), basePubKey2);
        }
        return new PGPPublicKey(publicKeyPacket, fingerPrintCalculator);
    }

    private PGPPublicKey getDSAPublicKey(SExpression expression, KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        BigInteger p = null;
        BigInteger q = null;
        BigInteger g = null;
        BigInteger y = null;
        for (Object item : expression.getValues()) {
            if (!(item instanceof SExpression)) continue;
            SExpression exp = (SExpression)item;
            if (exp.hasLabel("p")) {
                p = BigIntegers.fromUnsignedByteArray((byte[])exp.getBytes(1));
                continue;
            }
            if (exp.hasLabel("q")) {
                q = BigIntegers.fromUnsignedByteArray((byte[])exp.getBytes(1));
                continue;
            }
            if (exp.hasLabel("g")) {
                g = BigIntegers.fromUnsignedByteArray((byte[])exp.getBytes(1));
                continue;
            }
            if (!exp.hasLabel("y")) continue;
            y = BigIntegers.fromUnsignedByteArray((byte[])exp.getBytes(1));
        }
        if (p == null || !expression.hasLabel("elg") && q == null || g == null || y == null) {
            return null;
        }
        PublicKeyPacket publicKeyPacket = expression.hasLabel("elg") ? new PublicKeyPacket(20, new Date(), new ElGamalPublicBCPGKey(p, g, y)) : new PublicKeyPacket(17, new Date(), new DSAPublicBCPGKey(p, q, g, y));
        return new PGPPublicKey(publicKeyPacket, fingerPrintCalculator);
    }

    private UnwrapResult unwrapRSASecretKey(String protectionType, PGPPublicKey publicKey, int maxDepth, SExpression keyExpression, SExpression protectedKey, PBEProtectionRemoverFactory keyProtectionRemoverFactory) throws PGPException, IOException {
        if (protectionType.equals("openpgp-s2k3-sha1-aes-cbc")) {
            throw new IllegalArgumentException("openpgp-s2k3-sha1-aes-cbc not supported on newer key type");
        }
        if (protectionType.equals("openpgp-s2k3-ocb-aes")) {
            SExpression.Builder builder = SExpression.builder().addValue("rsa");
            this.addPublicKey(publicKey, builder);
            builder.addContent(keyExpression.filterOut("rsa", "e", "n", "protected"));
            byte[] aad = builder.build().toCanonicalForm();
            SExpression protectionKeyParameters = protectedKey.getExpression(2);
            SExpression s2kParams = protectionKeyParameters.getExpression(0);
            S2K s2K = new S2K(PGPUtil.getDigestIDForName(s2kParams.getString(0)), s2kParams.getBytes(1), s2kParams.getInt(2));
            byte[] nonce = protectionKeyParameters.getBytes(1);
            PBESecretKeyDecryptor decryptor = keyProtectionRemoverFactory.createDecryptor("ocb");
            byte[] key = decryptor.makeKeyFromPassPhrase(7, s2K);
            byte[] keyData = protectedKey.getBytes(3);
            return new UnwrapResult(SExpression.parse(((PGPSecretKeyDecryptorWithAAD)decryptor).recoverKeyData(7, key, nonce, aad, keyData, 0, keyData.length), maxDepth).getExpression(0), s2K, Arrays.clone((byte[])nonce));
        }
        throw new PGPException("unhandled protection type " + protectionType);
    }

    private PGPPublicKey getRSAPublicKey(SExpression expression, KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        BigInteger n = null;
        BigInteger e = null;
        for (Object item : expression.getValues()) {
            if (!(item instanceof SExpression)) continue;
            SExpression exp = (SExpression)item;
            if (exp.hasLabel("e")) {
                e = BigIntegers.fromUnsignedByteArray((byte[])exp.getBytes(1));
                continue;
            }
            if (!exp.hasLabel("n")) continue;
            n = BigIntegers.fromUnsignedByteArray((byte[])exp.getBytes(1));
        }
        if (n == null || e == null) {
            return null;
        }
        PublicKeyPacket pubPacket = new PublicKeyPacket(1, new Date(), new RSAPublicBCPGKey(n, e));
        return new PGPPublicKey(pubPacket, fingerPrintCalculator);
    }

    private SExpression.Builder addPublicKey(PGPPublicKey publicKey, SExpression.Builder builder) throws PGPException {
        PublicKeyPacket publicPk = publicKey.getPublicKeyPacket();
        try {
            switch (publicPk.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dsaK = (DSAPublicBCPGKey)publicPk.getKey();
                    return builder.addValue(SExpression.builder().addValue("p").addValue(dsaK.getP().toByteArray()).build()).addValue(SExpression.builder().addValue("q").addValue(dsaK.getQ().toByteArray()).build()).addValue(SExpression.builder().addValue("g").addValue(dsaK.getG().toByteArray()).build()).addValue(SExpression.builder().addValue("y").addValue(dsaK.getY().toByteArray()).build());
                }
                case 18: {
                    BCPGKey k = publicPk.getKey();
                    ECDHPublicBCPGKey ecdhK = (ECDHPublicBCPGKey)publicPk.getKey();
                    if (ecdhK.getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
                        byte[] pEnc = BigIntegers.asUnsignedByteArray((BigInteger)ecdhK.getEncodedPoint());
                        if (pEnc.length < 1 || 64 != pEnc[0]) {
                            throw new IllegalArgumentException("Invalid Curve25519 public key");
                        }
                        throw new IllegalStateException("not implemented");
                    }
                    throw new IllegalStateException("not implemented");
                }
                case 19: {
                    ECDSAPublicBCPGKey ecKey = (ECDSAPublicBCPGKey)publicPk.getKey();
                    byte[] pEnc = BigIntegers.asUnsignedByteArray((BigInteger)ecKey.getEncodedPoint());
                    return builder.addValue(SExpression.builder().addValue("q").addValue(pEnc).build());
                }
                case 22: {
                    EdDSAPublicBCPGKey eddsaK = (EdDSAPublicBCPGKey)publicPk.getKey();
                    byte[] pEnc = BigIntegers.asUnsignedByteArray((BigInteger)eddsaK.getEncodedPoint());
                    if (pEnc.length < 1 || 64 != pEnc[0]) {
                        throw new IllegalArgumentException("Invalid Ed25519 public key");
                    }
                    return builder.addValue(SExpression.builder().addValue("q").addValue(pEnc).build());
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elK = (ElGamalPublicBCPGKey)publicPk.getKey();
                    throw new IllegalStateException("not implemented");
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rsaK = (RSAPublicBCPGKey)publicPk.getKey();
                    return builder.addValue(SExpression.builder().addValue("n").addValue(rsaK.getModulus().toByteArray()).build()).addValue(SExpression.builder().addValue("e").addValue(rsaK.getPublicExponent().toByteArray()).build());
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("exception constructing public key", e);
        }
    }

    public static class Builder {
        private ArrayList<PGPExtendedKeyHeader> headerList = new ArrayList();
        private SExpression keyExpression;

        public Builder setHeaderList(ArrayList<PGPExtendedKeyHeader> headerList) {
            this.headerList = headerList;
            return this;
        }

        public Builder setKeyExpression(SExpression keyExpression) {
            this.keyExpression = keyExpression;
            return this;
        }

        public OpenedPGPKeyData build() {
            return new OpenedPGPKeyData(this.headerList, this.keyExpression);
        }

        public void add(PGPExtendedKeyHeader pgpExtendedKeyHeader) {
            this.headerList.add(pgpExtendedKeyHeader);
        }
    }

    private static class UnwrapResult {
        final SExpression expression;
        final S2K s2K;
        final byte[] iv;
        final Object metaData;

        public UnwrapResult(SExpression expression, S2K s2K, byte[] iv) {
            this.expression = expression;
            this.s2K = s2K;
            this.iv = iv;
            this.metaData = null;
        }

        public UnwrapResult(SExpression expression, S2K s2K, byte[] iv, Object metaData) {
            this.expression = expression;
            this.s2K = s2K;
            this.iv = iv;
            this.metaData = metaData;
        }
    }
}

