/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.util.Encodable;

public abstract class ContainedPacket
extends Packet
implements Encodable {
    public ContainedPacket() {
        super(0);
    }

    ContainedPacket(int n) {
        this(n, false);
    }

    ContainedPacket(int n, boolean bl) {
        super(n, bl);
    }

    public byte[] getEncoded() throws IOException {
        return this.getEncoded(PacketFormat.ROUNDTRIP);
    }

    public byte[] getEncoded(PacketFormat packetFormat) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream((OutputStream)byteArrayOutputStream, packetFormat);
        bCPGOutputStream.writePacket(this);
        bCPGOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public abstract void encode(BCPGOutputStream var1) throws IOException;
}

