/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkix.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.PKIXCRLStore;
import org.bouncycastle.jcajce.PKIXCRLStoreSelector;
import org.bouncycastle.jcajce.PKIXCertStore;
import org.bouncycastle.jcajce.PKIXCertStoreSelector;
import org.bouncycastle.jcajce.PKIXExtendedParameters;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.pkix.jcajce.AnnotatedException;
import org.bouncycastle.pkix.jcajce.CRLNotFoundException;
import org.bouncycastle.pkix.jcajce.CertStatus;
import org.bouncycastle.pkix.jcajce.PKIXCRLUtil;
import org.bouncycastle.pkix.jcajce.RFC3280CertPathUtilities;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.StoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RevocationUtilities {
    protected static final PKIXCRLUtil CRL_UTIL = new PKIXCRLUtil();
    protected static final String CERTIFICATE_POLICIES = Extension.certificatePolicies.getId();
    protected static final String BASIC_CONSTRAINTS = Extension.basicConstraints.getId();
    protected static final String POLICY_MAPPINGS = Extension.policyMappings.getId();
    protected static final String SUBJECT_ALTERNATIVE_NAME = Extension.subjectAlternativeName.getId();
    protected static final String NAME_CONSTRAINTS = Extension.nameConstraints.getId();
    protected static final String KEY_USAGE = Extension.keyUsage.getId();
    protected static final String INHIBIT_ANY_POLICY = Extension.inhibitAnyPolicy.getId();
    protected static final String ISSUING_DISTRIBUTION_POINT = Extension.issuingDistributionPoint.getId();
    protected static final String DELTA_CRL_INDICATOR = Extension.deltaCRLIndicator.getId();
    protected static final String POLICY_CONSTRAINTS = Extension.policyConstraints.getId();
    protected static final String FRESHEST_CRL = Extension.freshestCRL.getId();
    protected static final String CRL_DISTRIBUTION_POINTS = Extension.cRLDistributionPoints.getId();
    protected static final String AUTHORITY_KEY_IDENTIFIER = Extension.authorityKeyIdentifier.getId();
    protected static final String ANY_POLICY = "2.5.29.32.0";
    protected static final String CRL_NUMBER = Extension.cRLNumber.getId();
    protected static final int KEY_CERT_SIGN = 5;
    protected static final int CRL_SIGN = 6;
    protected static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    RevocationUtilities() {
    }

    protected static TrustAnchor findTrustAnchor(X509Certificate cert, Set trustAnchors) throws AnnotatedException {
        return RevocationUtilities.findTrustAnchor(cert, trustAnchors, null);
    }

    protected static TrustAnchor findTrustAnchor(X509Certificate cert, Set trustAnchors, String sigProvider) throws AnnotatedException {
        TrustAnchor trust = null;
        PublicKey trustPublicKey = null;
        Exception invalidKeyEx = null;
        X509CertSelector certSelectX509 = new X509CertSelector();
        X500Name certIssuer = X500Name.getInstance((Object)cert.getIssuerX500Principal());
        try {
            certSelectX509.setSubject(certIssuer.getEncoded());
        }
        catch (IOException ex) {
            throw new AnnotatedException("Cannot set subject search criteria for trust anchor.", ex);
        }
        Iterator iter = trustAnchors.iterator();
        while (iter.hasNext() && trust == null) {
            block15: {
                trust = (TrustAnchor)iter.next();
                if (trust.getTrustedCert() != null) {
                    if (certSelectX509.match(trust.getTrustedCert())) {
                        trustPublicKey = trust.getTrustedCert().getPublicKey();
                    } else {
                        trust = null;
                    }
                } else if (trust.getCAName() != null && trust.getCAPublicKey() != null) {
                    try {
                        X500Name caName = X500Name.getInstance((Object)trust.getCA().getEncoded());
                        if (certIssuer.equals((Object)caName)) {
                            trustPublicKey = trust.getCAPublicKey();
                            break block15;
                        }
                        trust = null;
                    }
                    catch (IllegalArgumentException ex) {
                        trust = null;
                    }
                } else {
                    trust = null;
                }
            }
            if (trustPublicKey == null) continue;
            try {
                RevocationUtilities.verifyX509Certificate(cert, trustPublicKey, sigProvider);
            }
            catch (Exception ex) {
                invalidKeyEx = ex;
                trust = null;
                trustPublicKey = null;
            }
        }
        if (trust == null && invalidKeyEx != null) {
            throw new AnnotatedException("TrustAnchor found but certificate validation failed.", invalidKeyEx);
        }
        return trust;
    }

    static boolean isIssuerTrustAnchor(X509Certificate cert, Set trustAnchors, String sigProvider) throws AnnotatedException {
        try {
            return RevocationUtilities.findTrustAnchor(cert, trustAnchors, sigProvider) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    static List<PKIXCertStore> getAdditionalStoresFromAltNames(byte[] issuerAlternativeName, Map<GeneralName, PKIXCertStore> altNameCertStoreMap) throws CertificateParsingException {
        if (issuerAlternativeName != null) {
            GeneralNames issuerAltName = GeneralNames.getInstance((Object)ASN1OctetString.getInstance((Object)issuerAlternativeName).getOctets());
            GeneralName[] names = issuerAltName.getNames();
            ArrayList<PKIXCertStore> stores = new ArrayList<PKIXCertStore>();
            for (int i = 0; i != names.length; ++i) {
                GeneralName altName = names[i];
                PKIXCertStore altStore = altNameCertStoreMap.get(altName);
                if (altStore == null) continue;
                stores.add(altStore);
            }
            return stores;
        }
        return Collections.EMPTY_LIST;
    }

    protected static Date getValidDate(PKIXExtendedParameters paramsPKIX) {
        Date validDate = paramsPKIX.getDate();
        if (validDate == null) {
            validDate = new Date();
        }
        return validDate;
    }

    protected static boolean isSelfIssued(X509Certificate cert) {
        return cert.getSubjectDN().equals(cert.getIssuerDN());
    }

    protected static ASN1Primitive getExtensionValue(X509Extension ext, ASN1ObjectIdentifier oid) throws AnnotatedException {
        byte[] bytes = ext.getExtensionValue(oid.getId());
        if (bytes == null) {
            return null;
        }
        return RevocationUtilities.getObject(oid, bytes);
    }

    private static ASN1Primitive getObject(ASN1ObjectIdentifier oid, byte[] ext) throws AnnotatedException {
        try {
            return ASN1Primitive.fromByteArray((byte[])ASN1OctetString.getInstance((Object)ext).getOctets());
        }
        catch (Exception e) {
            throw new AnnotatedException("exception processing extension " + oid, e);
        }
    }

    protected static AlgorithmIdentifier getAlgorithmIdentifier(PublicKey key) throws CertPathValidatorException {
        try {
            ASN1InputStream aIn = new ASN1InputStream(key.getEncoded());
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)aIn.readObject());
            return info.getAlgorithm();
        }
        catch (Exception e) {
            throw new CertPathValidatorException("subject public key cannot be decoded", e);
        }
    }

    protected static Collection findCertificates(PKIXCertStoreSelector certSelect, List certStores) throws AnnotatedException {
        LinkedHashSet certs = new LinkedHashSet();
        for (Object obj : certStores) {
            Object certStore;
            if (obj instanceof Store) {
                certStore = (Store)obj;
                try {
                    certs.addAll(certStore.getMatches((Selector)certSelect));
                    continue;
                }
                catch (StoreException e) {
                    throw new AnnotatedException("Problem while picking certificates from X.509 store.", e);
                }
            }
            certStore = (CertStore)obj;
            try {
                certs.addAll(PKIXCertStoreSelector.getCertificates((PKIXCertStoreSelector)certSelect, (CertStore)certStore));
            }
            catch (CertStoreException e) {
                throw new AnnotatedException("Problem while picking certificates from certificate store.", e);
            }
        }
        return certs;
    }

    static List<PKIXCRLStore> getAdditionalStoresFromCRLDistributionPoint(CRLDistPoint crldp, Map<GeneralName, PKIXCRLStore> namedCRLStoreMap) throws AnnotatedException {
        if (crldp != null) {
            DistributionPoint[] dps = null;
            try {
                dps = crldp.getDistributionPoints();
            }
            catch (Exception e) {
                throw new AnnotatedException("Distribution points could not be read.", e);
            }
            ArrayList<PKIXCRLStore> stores = new ArrayList<PKIXCRLStore>();
            for (int i = 0; i < dps.length; ++i) {
                DistributionPointName dpn = dps[i].getDistributionPoint();
                if (dpn == null || dpn.getType() != 0) continue;
                GeneralName[] genNames = GeneralNames.getInstance((Object)dpn.getName()).getNames();
                for (int j = 0; j < genNames.length; ++j) {
                    PKIXCRLStore store = namedCRLStoreMap.get(genNames[j]);
                    if (store == null) continue;
                    stores.add(store);
                }
            }
            return stores;
        }
        return Collections.EMPTY_LIST;
    }

    protected static void getCRLIssuersFromDistributionPoint(DistributionPoint dp, Collection issuerPrincipals, X509CRLSelector selector) throws AnnotatedException {
        Iterator it;
        ArrayList<Object> issuers = new ArrayList<Object>();
        if (dp.getCRLIssuer() != null) {
            GeneralName[] genNames = dp.getCRLIssuer().getNames();
            for (int j = 0; j < genNames.length; ++j) {
                if (genNames[j].getTagNo() != 4) continue;
                try {
                    issuers.add(X500Name.getInstance((Object)genNames[j].getName().toASN1Primitive().getEncoded()));
                    continue;
                }
                catch (IOException e) {
                    throw new AnnotatedException("CRL issuer information from distribution point cannot be decoded.", e);
                }
            }
        } else {
            if (dp.getDistributionPoint() == null) {
                throw new AnnotatedException("CRL issuer is omitted from distribution point but no distributionPoint field present.");
            }
            it = issuerPrincipals.iterator();
            while (it.hasNext()) {
                issuers.add(it.next());
            }
        }
        it = issuers.iterator();
        while (it.hasNext()) {
            try {
                selector.addIssuerName(((X500Name)it.next()).getEncoded());
            }
            catch (IOException ex) {
                throw new AnnotatedException("Cannot decode CRL issuer information.", ex);
            }
        }
    }

    private static BigInteger getSerialNumber(Object cert) {
        return ((X509Certificate)cert).getSerialNumber();
    }

    protected static void getCertStatus(Date validDate, X509CRL crl, Object cert, CertStatus certStatus) throws AnnotatedException {
        boolean isIndirect;
        X509CRLEntry crl_entry = null;
        try {
            isIndirect = RevocationUtilities.isIndirectCRL(crl);
        }
        catch (CRLException exception) {
            throw new AnnotatedException("Failed check for indirect CRL.", exception);
        }
        if (isIndirect) {
            crl_entry = crl.getRevokedCertificate(RevocationUtilities.getSerialNumber(cert));
            if (crl_entry == null) {
                return;
            }
            X500Principal certificateIssuer = crl_entry.getCertificateIssuer();
            X500Name certIssuer = certificateIssuer == null ? X500Name.getInstance((Object)crl.getIssuerX500Principal()) : X500Name.getInstance((Object)certificateIssuer.getEncoded());
            if (!X500Name.getInstance((Object)((X509Certificate)cert).getIssuerX500Principal().getEncoded()).equals((Object)certIssuer)) {
                return;
            }
        } else {
            if (!X500Name.getInstance((Object)((X509Certificate)cert).getIssuerX500Principal().getEncoded()).equals((Object)X500Name.getInstance((Object)crl.getIssuerX500Principal().getEncoded()))) {
                return;
            }
            crl_entry = crl.getRevokedCertificate(RevocationUtilities.getSerialNumber(cert));
            if (crl_entry == null) {
                return;
            }
        }
        ASN1Enumerated reasonCode = null;
        if (crl_entry.hasExtensions()) {
            try {
                reasonCode = ASN1Enumerated.getInstance((Object)RevocationUtilities.getExtensionValue(crl_entry, Extension.reasonCode));
            }
            catch (Exception e) {
                throw new AnnotatedException("Reason code CRL entry extension could not be decoded.", e);
            }
        }
        if (validDate.getTime() >= crl_entry.getRevocationDate().getTime() || reasonCode == null || reasonCode.getValue().intValue() == 0 || reasonCode.getValue().intValue() == 1 || reasonCode.getValue().intValue() == 2 || reasonCode.getValue().intValue() == 8) {
            if (reasonCode != null) {
                certStatus.setCertStatus(reasonCode.getValue().intValue());
            } else {
                certStatus.setCertStatus(0);
            }
            certStatus.setRevocationDate(crl_entry.getRevocationDate());
        }
    }

    protected static Set getDeltaCRLs(Date validityDate, X509CRL completeCRL, List<CertStore> certStores, List<PKIXCRLStore> pkixCrlStores) throws AnnotatedException {
        X509CRLSelector baseDeltaSelect = new X509CRLSelector();
        try {
            baseDeltaSelect.addIssuerName(X500Name.getInstance((Object)completeCRL.getIssuerX500Principal().getEncoded()).getEncoded());
        }
        catch (IOException e) {
            throw new AnnotatedException("cannot extract issuer from CRL.", e);
        }
        BigInteger completeCRLNumber = null;
        try {
            ASN1Primitive derObject = RevocationUtilities.getExtensionValue(completeCRL, Extension.cRLNumber);
            if (derObject != null) {
                completeCRLNumber = ASN1Integer.getInstance((Object)derObject).getPositiveValue();
            }
        }
        catch (Exception e) {
            throw new AnnotatedException("cannot extract CRL number extension from CRL", e);
        }
        byte[] idp = null;
        try {
            idp = completeCRL.getExtensionValue(ISSUING_DISTRIBUTION_POINT);
        }
        catch (Exception e) {
            throw new AnnotatedException("issuing distribution point extension value could not be read", e);
        }
        baseDeltaSelect.setMinCRLNumber(completeCRLNumber == null ? null : completeCRLNumber.add(BigInteger.valueOf(1L)));
        PKIXCRLStoreSelector.Builder selBuilder = new PKIXCRLStoreSelector.Builder((CRLSelector)baseDeltaSelect);
        selBuilder.setIssuingDistributionPoint(idp);
        selBuilder.setIssuingDistributionPointEnabled(true);
        selBuilder.setMaxBaseCRLNumber(completeCRLNumber);
        PKIXCRLStoreSelector deltaSelect = selBuilder.build();
        Set temp = CRL_UTIL.findCRLs(deltaSelect, validityDate, certStores, pkixCrlStores);
        HashSet<X509CRL> result = new HashSet<X509CRL>();
        for (X509CRL crl : temp) {
            if (!RevocationUtilities.isDeltaCRL(crl)) continue;
            result.add(crl);
        }
        return result;
    }

    private static boolean isDeltaCRL(X509CRL crl) {
        Set<String> critical = crl.getCriticalExtensionOIDs();
        if (critical == null) {
            return false;
        }
        return critical.contains(RFC3280CertPathUtilities.DELTA_CRL_INDICATOR);
    }

    protected static Set getCompleteCRLs(DistributionPoint dp, Object cert, Date validityDate, List certStores, List crlStores) throws AnnotatedException, CRLNotFoundException {
        X509CRLSelector baseCrlSelect = new X509CRLSelector();
        try {
            HashSet<X500Name> issuers = new HashSet<X500Name>();
            issuers.add(X500Name.getInstance((Object)((X509Certificate)cert).getIssuerX500Principal().getEncoded()));
            RevocationUtilities.getCRLIssuersFromDistributionPoint(dp, issuers, baseCrlSelect);
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("Could not get issuer information from distribution point.", e);
        }
        if (cert instanceof X509Certificate) {
            baseCrlSelect.setCertificateChecking((X509Certificate)cert);
        }
        PKIXCRLStoreSelector crlSelect = new PKIXCRLStoreSelector.Builder((CRLSelector)baseCrlSelect).setCompleteCRLEnabled(true).build();
        Set crls = CRL_UTIL.findCRLs(crlSelect, validityDate, certStores, crlStores);
        RevocationUtilities.checkCRLsNotEmpty(crls, cert);
        return crls;
    }

    protected static Date getValidCertDateFromValidityModel(PKIXExtendedParameters paramsPKIX, CertPath certPath, int index) throws AnnotatedException {
        if (paramsPKIX.getValidityModel() == 1) {
            if (index <= 0) {
                return RevocationUtilities.getValidDate(paramsPKIX);
            }
            if (index - 1 == 0) {
                ASN1GeneralizedTime dateOfCertgen = null;
                try {
                    byte[] extBytes = ((X509Certificate)certPath.getCertificates().get(index - 1)).getExtensionValue(ISISMTTObjectIdentifiers.id_isismtt_at_dateOfCertGen.getId());
                    if (extBytes != null) {
                        dateOfCertgen = ASN1GeneralizedTime.getInstance((Object)ASN1Primitive.fromByteArray((byte[])extBytes));
                    }
                }
                catch (IOException e) {
                    throw new AnnotatedException("Date of cert gen extension could not be read.");
                }
                catch (IllegalArgumentException e) {
                    throw new AnnotatedException("Date of cert gen extension could not be read.");
                }
                if (dateOfCertgen != null) {
                    try {
                        return dateOfCertgen.getDate();
                    }
                    catch (ParseException e) {
                        throw new AnnotatedException("Date from date of cert gen extension could not be parsed.", e);
                    }
                }
                return ((X509Certificate)certPath.getCertificates().get(index - 1)).getNotBefore();
            }
            return ((X509Certificate)certPath.getCertificates().get(index - 1)).getNotBefore();
        }
        return RevocationUtilities.getValidDate(paramsPKIX);
    }

    protected static PublicKey getNextWorkingKey(List certs, int index, JcaJceHelper helper) throws CertPathValidatorException {
        Certificate cert = (Certificate)certs.get(index);
        PublicKey pubKey = cert.getPublicKey();
        if (!(pubKey instanceof DSAPublicKey)) {
            return pubKey;
        }
        DSAPublicKey dsaPubKey = (DSAPublicKey)pubKey;
        if (dsaPubKey.getParams() != null) {
            return dsaPubKey;
        }
        for (int i = index + 1; i < certs.size(); ++i) {
            X509Certificate parentCert = (X509Certificate)certs.get(i);
            pubKey = parentCert.getPublicKey();
            if (!(pubKey instanceof DSAPublicKey)) {
                throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
            }
            DSAPublicKey prevDSAPubKey = (DSAPublicKey)pubKey;
            if (prevDSAPubKey.getParams() == null) continue;
            DSAParams dsaParams = prevDSAPubKey.getParams();
            DSAPublicKeySpec dsaPubKeySpec = new DSAPublicKeySpec(dsaPubKey.getY(), dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
            try {
                KeyFactory keyFactory = helper.createKeyFactory("DSA");
                return keyFactory.generatePublic(dsaPubKeySpec);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
    }

    static Collection findIssuerCerts(X509Certificate cert, List<CertStore> certStores, List<PKIXCertStore> pkixCertStores) throws AnnotatedException {
        Iterator iter;
        X509CertSelector selector = new X509CertSelector();
        try {
            selector.setSubject(cert.getIssuerX500Principal().getEncoded());
        }
        catch (IOException e) {
            throw new AnnotatedException("Subject criteria for certificate selector to find issuer certificate could not be set.", e);
        }
        try {
            ASN1OctetString aki;
            byte[] authorityKeyIdentifier;
            byte[] akiExtensionValue = cert.getExtensionValue(AUTHORITY_KEY_IDENTIFIER);
            if (akiExtensionValue != null && (authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance((Object)(aki = ASN1OctetString.getInstance((Object)akiExtensionValue)).getOctets()).getKeyIdentifier()) != null) {
                selector.setSubjectKeyIdentifier(new DEROctetString(authorityKeyIdentifier).getEncoded());
            }
        }
        catch (Exception akiExtensionValue) {
            // empty catch block
        }
        PKIXCertStoreSelector certSelect = new PKIXCertStoreSelector.Builder((CertSelector)selector).build();
        LinkedHashSet<X509Certificate> certs = new LinkedHashSet<X509Certificate>();
        try {
            ArrayList matches = new ArrayList();
            matches.addAll(RevocationUtilities.findCertificates(certSelect, certStores));
            matches.addAll(RevocationUtilities.findCertificates(certSelect, pkixCertStores));
            iter = matches.iterator();
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("Issuer certificate cannot be searched.", e);
        }
        X509Certificate issuer = null;
        while (iter.hasNext()) {
            issuer = (X509Certificate)iter.next();
            certs.add(issuer);
        }
        return certs;
    }

    protected static void verifyX509Certificate(X509Certificate cert, PublicKey publicKey, String sigProvider) throws GeneralSecurityException {
        if (sigProvider == null) {
            cert.verify(publicKey);
        } else {
            cert.verify(publicKey, sigProvider);
        }
    }

    static void checkCRLsNotEmpty(Set crls, Object cert) throws CRLNotFoundException {
        if (crls.isEmpty()) {
            X509Certificate xCert = (X509Certificate)cert;
            throw new CRLNotFoundException("No CRLs found for issuer \"" + RFC4519Style.INSTANCE.toString(X500Name.getInstance((Object)xCert.getIssuerX500Principal().getEncoded())) + "\"");
        }
    }

    public static boolean isIndirectCRL(X509CRL crl) throws CRLException {
        try {
            byte[] idp = crl.getExtensionValue(Extension.issuingDistributionPoint.getId());
            return idp != null && IssuingDistributionPoint.getInstance((Object)ASN1OctetString.getInstance((Object)idp).getOctets()).isIndirectCRL();
        }
        catch (Exception e) {
            throw new CRLException("exception reading IssuingDistributionPoint", e);
        }
    }
}

