/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.jcajce;

import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.KEMKeyWrapper;
import org.bouncycastle.cms.KEMRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSKEMKeyWrapper;

public class JceKEMRecipientInfoGenerator
extends KEMRecipientInfoGenerator {
    public JceKEMRecipientInfoGenerator(X509Certificate x509Certificate, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws CertificateEncodingException {
        super(new IssuerAndSerialNumber(new JcaX509CertificateHolder(x509Certificate).toASN1Structure()), (KEMKeyWrapper)new JceCMSKEMKeyWrapper(JceKEMRecipientInfoGenerator.getPublicKey(x509Certificate), aSN1ObjectIdentifier));
    }

    public JceKEMRecipientInfoGenerator(byte[] byArray, PublicKey publicKey, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        super(byArray, (KEMKeyWrapper)new JceCMSKEMKeyWrapper(publicKey, aSN1ObjectIdentifier));
    }

    public JceKEMRecipientInfoGenerator setProvider(String string) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setProvider(string);
        return this;
    }

    public JceKEMRecipientInfoGenerator setProvider(Provider provider) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setProvider(provider);
        return this;
    }

    public JceKEMRecipientInfoGenerator setSecureRandom(SecureRandom secureRandom) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setSecureRandom(secureRandom);
        return this;
    }

    public JceKEMRecipientInfoGenerator setKDF(AlgorithmIdentifier algorithmIdentifier) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setKDF(algorithmIdentifier);
        return this;
    }

    public JceKEMRecipientInfoGenerator setAlgorithmMapping(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setAlgorithmMapping(aSN1ObjectIdentifier, string);
        return this;
    }

    private static PublicKey getPublicKey(X509Certificate x509Certificate) {
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (publicKey == null) {
            try {
                TBSCertificate tBSCertificate = TBSCertificate.getInstance((Object)x509Certificate.getTBSCertificate());
                KeyFactory keyFactory = KeyFactory.getInstance(tBSCertificate.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().getId(), "BCPQC");
                return keyFactory.generatePublic(new X509EncodedKeySpec(tBSCertificate.getSubjectPublicKeyInfo().getEncoded()));
            }
            catch (Exception exception) {
                throw new IllegalStateException("unable to process PQC key: " + exception.getMessage(), exception);
            }
        }
        return publicKey;
    }
}

