/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.AuthenticatedData;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.OriginatorInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAuthenticatedGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSMacCalculatorBuilder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.MacCalculator;
import org.bouncycastle.util.io.TeeOutputStream;

public class CMSAuthenticatedDataStreamGenerator
extends CMSAuthenticatedGenerator {
    private int bufferSize;
    private boolean berEncodeRecipientSet;
    private MacCalculator macCalculator;

    public CMSAuthenticatedDataStreamGenerator() {
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public void setBEREncodeRecipients(boolean bl) {
        this.berEncodeRecipientSet = bl;
    }

    public OutputStream open(OutputStream outputStream, MacCalculator macCalculator) throws CMSException {
        return this.open(CMSObjectIdentifiers.data, outputStream, macCalculator);
    }

    public OutputStream open(OutputStream outputStream, MacCalculator macCalculator, DigestCalculator digestCalculator) throws CMSException {
        return this.open(CMSObjectIdentifiers.data, outputStream, macCalculator, digestCalculator);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, MacCalculator macCalculator) throws CMSException {
        return this.open(aSN1ObjectIdentifier, outputStream, macCalculator, null);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, MacCalculator macCalculator, DigestCalculator digestCalculator) throws CMSException {
        this.macCalculator = macCalculator;
        try {
            RecipientInfoGenerator recipientInfoGenerator;
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            BERSequenceGenerator bERSequenceGenerator = this.recipientInfoGenerators.iterator();
            while (bERSequenceGenerator.hasNext()) {
                recipientInfoGenerator = (RecipientInfoGenerator)bERSequenceGenerator.next();
                aSN1EncodableVector.add((ASN1Encodable)recipientInfoGenerator.generate(macCalculator.getKey()));
            }
            bERSequenceGenerator = new BERSequenceGenerator(outputStream);
            bERSequenceGenerator.addObject((ASN1Encodable)CMSObjectIdentifiers.authenticatedData);
            recipientInfoGenerator = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
            recipientInfoGenerator.addObject((ASN1Encodable)new DERInteger(AuthenticatedData.calculateVersion((OriginatorInfo)this.originatorInfo)));
            if (this.originatorInfo != null) {
                recipientInfoGenerator.addObject((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.originatorInfo));
            }
            if (this.berEncodeRecipientSet) {
                recipientInfoGenerator.getRawOutputStream().write(new BERSet(aSN1EncodableVector).getEncoded());
            } else {
                recipientInfoGenerator.getRawOutputStream().write(new DERSet(aSN1EncodableVector).getEncoded());
            }
            AlgorithmIdentifier algorithmIdentifier = macCalculator.getAlgorithmIdentifier();
            recipientInfoGenerator.getRawOutputStream().write(algorithmIdentifier.getEncoded());
            if (digestCalculator != null) {
                recipientInfoGenerator.addObject((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)digestCalculator.getAlgorithmIdentifier()));
            }
            BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(recipientInfoGenerator.getRawOutputStream());
            bERSequenceGenerator2.addObject((ASN1Encodable)aSN1ObjectIdentifier);
            OutputStream outputStream2 = CMSUtils.createBEROctetOutputStream(bERSequenceGenerator2.getRawOutputStream(), 0, false, this.bufferSize);
            TeeOutputStream teeOutputStream = digestCalculator != null ? new TeeOutputStream(outputStream2, digestCalculator.getOutputStream()) : new TeeOutputStream(outputStream2, macCalculator.getOutputStream());
            return new CmsAuthenticatedDataOutputStream(macCalculator, digestCalculator, aSN1ObjectIdentifier, (OutputStream)teeOutputStream, bERSequenceGenerator, (BERSequenceGenerator)recipientInfoGenerator, bERSequenceGenerator2);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
    }

    public CMSAuthenticatedDataStreamGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public OutputStream open(OutputStream outputStream, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        this.convertOldRecipients(this.rand, CMSUtils.getProvider(string2));
        return this.open(outputStream, new JceCMSMacCalculatorBuilder(new ASN1ObjectIdentifier(string)).setSecureRandom(this.rand).setProvider(string2).build());
    }

    public OutputStream open(OutputStream outputStream, String string, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        this.convertOldRecipients(this.rand, provider);
        return this.open(outputStream, new JceCMSMacCalculatorBuilder(new ASN1ObjectIdentifier(string)).setSecureRandom(this.rand).setProvider(provider).build());
    }

    public OutputStream open(OutputStream outputStream, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        this.convertOldRecipients(this.rand, CMSUtils.getProvider(string2));
        return this.open(outputStream, new JceCMSMacCalculatorBuilder(new ASN1ObjectIdentifier(string), n).setSecureRandom(this.rand).setProvider(string2).build());
    }

    public OutputStream open(OutputStream outputStream, String string, int n, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        this.convertOldRecipients(this.rand, provider);
        return this.open(outputStream, new JceCMSMacCalculatorBuilder(new ASN1ObjectIdentifier(string), n).setSecureRandom(this.rand).setProvider(provider).build());
    }

    private class CmsAuthenticatedDataOutputStream
    extends OutputStream {
        private OutputStream dataStream;
        private BERSequenceGenerator cGen;
        private BERSequenceGenerator envGen;
        private BERSequenceGenerator eiGen;
        private MacCalculator macCalculator;
        private DigestCalculator digestCalculator;
        private ASN1ObjectIdentifier contentType;

        public CmsAuthenticatedDataOutputStream(MacCalculator macCalculator, DigestCalculator digestCalculator, ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this.macCalculator = macCalculator;
            this.digestCalculator = digestCalculator;
            this.contentType = aSN1ObjectIdentifier;
            this.dataStream = outputStream;
            this.cGen = bERSequenceGenerator;
            this.envGen = bERSequenceGenerator2;
            this.eiGen = bERSequenceGenerator3;
        }

        public void write(int n) throws IOException {
            this.dataStream.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dataStream.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this.dataStream.write(byArray);
        }

        public void close() throws IOException {
            Map map;
            this.dataStream.close();
            this.eiGen.close();
            if (this.digestCalculator != null) {
                map = Collections.unmodifiableMap(CMSAuthenticatedDataStreamGenerator.this.getBaseParameters((DERObjectIdentifier)this.contentType, this.digestCalculator.getAlgorithmIdentifier(), this.digestCalculator.getDigest()));
                if (CMSAuthenticatedDataStreamGenerator.this.authGen == null) {
                    CMSAuthenticatedDataStreamGenerator.this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
                }
                DERSet dERSet = new DERSet(CMSAuthenticatedDataStreamGenerator.this.authGen.getAttributes(map).toASN1EncodableVector());
                OutputStream outputStream = this.macCalculator.getOutputStream();
                outputStream.write(dERSet.getEncoded("DER"));
                outputStream.close();
                this.envGen.addObject((ASN1Encodable)new DERTaggedObject(false, 2, (ASN1Encodable)dERSet));
            } else {
                map = Collections.unmodifiableMap(new HashMap());
            }
            this.envGen.addObject((ASN1Encodable)new DEROctetString(this.macCalculator.getMac()));
            if (CMSAuthenticatedDataStreamGenerator.this.unauthGen != null) {
                this.envGen.addObject((ASN1Encodable)new DERTaggedObject(false, 3, (ASN1Encodable)new BERSet(CMSAuthenticatedDataStreamGenerator.this.unauthGen.getAttributes(map).toASN1EncodableVector())));
            }
            this.envGen.close();
            this.cGen.close();
        }
    }
}

