/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMKeyPairParser;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemHeader;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectParser;
import org.bouncycastle.util.io.pem.PemReader;

public class PEMParser
extends PemReader {
    private final Map parsers = new HashMap();

    public PEMParser(Reader reader) {
        super(reader);
        this.parsers.put("CERTIFICATE REQUEST", new PKCS10CertificationRequestParser());
        this.parsers.put("NEW CERTIFICATE REQUEST", new PKCS10CertificationRequestParser());
        this.parsers.put("CERTIFICATE", new X509CertificateParser());
        this.parsers.put("X509 CERTIFICATE", new X509CertificateParser());
        this.parsers.put("X509 CRL", new X509CRLParser());
        this.parsers.put("PKCS7", new PKCS7Parser());
        this.parsers.put("ATTRIBUTE CERTIFICATE", new X509AttributeCertificateParser());
        this.parsers.put("EC PARAMETERS", new ECNamedCurveSpecParser());
        this.parsers.put("PUBLIC KEY", new PublicKeyParser());
        this.parsers.put("RSA PUBLIC KEY", new RSAPublicKeyParser());
        this.parsers.put("RSA PRIVATE KEY", new KeyPairParser(new RSAKeyPairParser()));
        this.parsers.put("DSA PRIVATE KEY", new KeyPairParser(new DSAKeyPairParser()));
        this.parsers.put("EC PRIVATE KEY", new KeyPairParser(new ECDSAKeyPairParser()));
        this.parsers.put("ENCRYPTED PRIVATE KEY", new EncryptedPrivateKeyParser());
        this.parsers.put("PRIVATE KEY", new PrivateKeyParser());
    }

    public Object readObject() throws IOException {
        PemObject pemObject = this.readPemObject();
        if (pemObject != null) {
            String string = pemObject.getType();
            if (this.parsers.containsKey(string)) {
                return ((PemObjectParser)this.parsers.get(string)).parseObject(pemObject);
            }
            throw new IOException("unrecognised object: " + string);
        }
        return null;
    }

    private class PrivateKeyParser
    implements PemObjectParser {
        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                return PrivateKeyInfo.getInstance((Object)pemObject.getContent());
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing PRIVATE KEY: " + exception.toString(), exception);
            }
        }
    }

    private class EncryptedPrivateKeyParser
    implements PemObjectParser {
        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                return new PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo.getInstance((Object)pemObject.getContent()));
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing ENCRYPTED PRIVATE KEY: " + exception.toString(), exception);
            }
        }
    }

    private class ECNamedCurveSpecParser
    implements PemObjectParser {
        private ECNamedCurveSpecParser() {
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)ASN1Primitive.fromByteArray((byte[])pemObject.getContent());
                ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECNamedCurveTable.getParameterSpec((String)dERObjectIdentifier.getId());
                if (eCNamedCurveParameterSpec == null) {
                    throw new IOException("object ID not found in EC curve table");
                }
                return eCNamedCurveParameterSpec;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("exception extracting EC named curve: " + exception.toString());
            }
        }
    }

    private class X509AttributeCertificateParser
    implements PemObjectParser {
        private X509AttributeCertificateParser() {
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            return new X509AttributeCertificateHolder(pemObject.getContent());
        }
    }

    private class PKCS7Parser
    implements PemObjectParser {
        private PKCS7Parser() {
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                ASN1InputStream aSN1InputStream = new ASN1InputStream(pemObject.getContent());
                return ContentInfo.getInstance((Object)aSN1InputStream.readObject());
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing PKCS7 object: " + exception.toString(), exception);
            }
        }
    }

    private class PKCS10CertificationRequestParser
    implements PemObjectParser {
        private PKCS10CertificationRequestParser() {
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                return new PKCS10CertificationRequest(pemObject.getContent());
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing certrequest: " + exception.toString(), exception);
            }
        }
    }

    private class X509CRLParser
    implements PemObjectParser {
        private X509CRLParser() {
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                return new X509CRLHolder(pemObject.getContent());
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing cert: " + exception.toString(), exception);
            }
        }
    }

    private class X509CertificateParser
    implements PemObjectParser {
        private X509CertificateParser() {
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                return new X509CertificateHolder(pemObject.getContent());
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing cert: " + exception.toString(), exception);
            }
        }
    }

    private class RSAPublicKeyParser
    implements PemObjectParser {
        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                RSAPublicKey rSAPublicKey = RSAPublicKey.getInstance((Object)pemObject.getContent());
                return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), (ASN1Encodable)rSAPublicKey);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("problem extracting key: " + exception.toString(), exception);
            }
        }
    }

    private class PublicKeyParser
    implements PemObjectParser {
        public Object parseObject(PemObject pemObject) throws IOException {
            return SubjectPublicKeyInfo.getInstance((Object)pemObject.getContent());
        }
    }

    private class RSAKeyPairParser
    implements PEMKeyPairParser {
        private RSAKeyPairParser() {
        }

        public PEMKeyPair parse(byte[] byArray) throws IOException {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)byArray);
                if (aSN1Sequence.size() != 9) {
                    throw new PEMException("malformed sequence in RSA private key");
                }
                RSAPrivateKey rSAPrivateKey = RSAPrivateKey.getInstance((Object)aSN1Sequence);
                RSAPublicKey rSAPublicKey = new RSAPublicKey(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent());
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
                return new PEMKeyPair(new SubjectPublicKeyInfo(algorithmIdentifier, (ASN1Encodable)rSAPublicKey), new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)rSAPrivateKey));
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("problem creating RSA private key: " + exception.toString(), exception);
            }
        }
    }

    private class ECDSAKeyPairParser
    implements PEMKeyPairParser {
        private ECDSAKeyPairParser() {
        }

        public PEMKeyPair parse(byte[] byArray) throws IOException {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)byArray);
                ECPrivateKey eCPrivateKey = ECPrivateKey.getInstance((Object)aSN1Sequence);
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)eCPrivateKey.getParameters());
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)eCPrivateKey);
                SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, eCPrivateKey.getPublicKey().getBytes());
                return new PEMKeyPair(subjectPublicKeyInfo, privateKeyInfo);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("problem creating EC private key: " + exception.toString(), exception);
            }
        }
    }

    private class DSAKeyPairParser
    implements PEMKeyPairParser {
        private DSAKeyPairParser() {
        }

        public PEMKeyPair parse(byte[] byArray) throws IOException {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)byArray);
                if (aSN1Sequence.size() != 6) {
                    throw new PEMException("malformed sequence in DSA private key");
                }
                ASN1Integer aSN1Integer = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(1));
                ASN1Integer aSN1Integer2 = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(2));
                ASN1Integer aSN1Integer3 = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(3));
                ASN1Integer aSN1Integer4 = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(4));
                ASN1Integer aSN1Integer5 = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(5));
                return new PEMKeyPair(new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)new DSAParameter(aSN1Integer.getValue(), aSN1Integer2.getValue(), aSN1Integer3.getValue())), (ASN1Encodable)aSN1Integer4), new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)new DSAParameter(aSN1Integer.getValue(), aSN1Integer2.getValue(), aSN1Integer3.getValue())), (ASN1Encodable)aSN1Integer5));
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("problem creating DSA private key: " + exception.toString(), exception);
            }
        }
    }

    private class KeyPairParser
    implements PemObjectParser {
        private final PEMKeyPairParser pemKeyPairParser;

        public KeyPairParser(PEMKeyPairParser pEMKeyPairParser) {
            this.pemKeyPairParser = pEMKeyPairParser;
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            Object object;
            boolean bl = false;
            String string = null;
            List list = pemObject.getHeaders();
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                object = (PemHeader)object2.next();
                if (object.getName().equals("Proc-Type") && object.getValue().equals("4,ENCRYPTED")) {
                    bl = true;
                    continue;
                }
                if (!object.getName().equals("DEK-Info")) continue;
                string = object.getValue();
            }
            object2 = pemObject.getContent();
            try {
                if (bl) {
                    object = new StringTokenizer(string, ",");
                    String string2 = ((StringTokenizer)object).nextToken();
                    byte[] byArray = Hex.decode((String)((StringTokenizer)object).nextToken());
                    return new PEMEncryptedKeyPair(string2, byArray, (byte[])object2, this.pemKeyPairParser);
                }
                return this.pemKeyPairParser.parse((byte[])object2);
            }
            catch (IOException iOException) {
                if (bl) {
                    throw new PEMException("exception decoding - please check password and data.", iOException);
                }
                throw new PEMException(iOException.getMessage(), iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (bl) {
                    throw new PEMException("exception decoding - please check password and data.", illegalArgumentException);
                }
                throw new PEMException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }
}

