/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    private List signerInfs = new ArrayList();

    public CMSSignedData generate(CMSTypedData cMSTypedData) throws CMSException {
        return this.generate(cMSTypedData, false);
    }

    public CMSSignedData generate(CMSTypedData cMSTypedData, boolean bl) throws CMSException {
        Object object;
        SignerInfo signerInfo;
        Object object2;
        Object object3;
        SignerInformation signerInformation;
        if (!this.signerInfs.isEmpty()) {
            throw new IllegalStateException("this method can only be used with SignerInfoGenerator");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        this.digests.clear();
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this._signers.iterator();
        while (aSN1ObjectIdentifier.hasNext()) {
            signerInformation = (SignerInformation)aSN1ObjectIdentifier.next();
            aSN1EncodableVector.add((ASN1Encodable)CMSSignedHelper.INSTANCE.fixAlgID(signerInformation.getDigestAlgorithmID()));
            aSN1EncodableVector2.add((ASN1Encodable)signerInformation.toASN1Structure());
        }
        aSN1ObjectIdentifier = cMSTypedData.getContentType();
        signerInformation = null;
        if (cMSTypedData != null) {
            object3 = null;
            if (bl) {
                object3 = new ByteArrayOutputStream();
            }
            object2 = CMSUtils.attachSignersToOutputStream(this.signerGens, object3);
            object2 = CMSUtils.getSafeOutputStream((OutputStream)object2);
            try {
                cMSTypedData.write((OutputStream)object2);
                ((OutputStream)object2).close();
            }
            catch (IOException iOException) {
                throw new CMSException("data processing exception: " + iOException.getMessage(), iOException);
            }
            if (bl) {
                signerInformation = new BEROctetString(((ByteArrayOutputStream)object3).toByteArray());
            }
        }
        object3 = this.signerGens.iterator();
        while (object3.hasNext()) {
            object2 = (SignerInfoGenerator)object3.next();
            signerInfo = ((SignerInfoGenerator)object2).generate(aSN1ObjectIdentifier);
            aSN1EncodableVector.add((ASN1Encodable)signerInfo.getDigestAlgorithm());
            aSN1EncodableVector2.add((ASN1Encodable)signerInfo);
            object = ((SignerInfoGenerator)object2).getCalculatedDigest();
            if (object == null) continue;
            this.digests.put(signerInfo.getDigestAlgorithm().getAlgorithm().getId(), object);
        }
        object3 = null;
        if (this.certs.size() != 0) {
            object3 = CMSUtils.createBerSetFromList(this.certs);
        }
        object2 = null;
        if (this.crls.size() != 0) {
            object2 = CMSUtils.createBerSetFromList(this.crls);
        }
        signerInfo = new ContentInfo(aSN1ObjectIdentifier, (ASN1Encodable)signerInformation);
        object = new SignedData((ASN1Set)new DERSet(aSN1EncodableVector), (ContentInfo)signerInfo, (ASN1Set)object3, (ASN1Set)object2, (ASN1Set)new DERSet(aSN1EncodableVector2));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)object);
        return new CMSSignedData((CMSProcessable)cMSTypedData, contentInfo);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signerInformation) throws CMSException {
        return this.generate(new CMSProcessableByteArray(null, signerInformation.getSignature()), false).getSignerInfos();
    }
}

