/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSStreamException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;

public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private int _bufferSize;

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public OutputStream open(OutputStream outputStream) throws IOException {
        return this.open(outputStream, false);
    }

    public OutputStream open(OutputStream outputStream, boolean bl) throws IOException {
        return this.open(CMSObjectIdentifiers.data, outputStream, bl);
    }

    public OutputStream open(OutputStream outputStream, boolean bl, OutputStream outputStream2) throws IOException {
        return this.open(CMSObjectIdentifiers.data, outputStream, bl, outputStream2);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, boolean bl) throws IOException {
        return this.open(aSN1ObjectIdentifier, outputStream, bl, null);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, boolean bl, OutputStream outputStream2) throws IOException {
        Object object;
        Object object2;
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject((ASN1Encodable)CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject((ASN1Encodable)this.calculateVersion(aSN1ObjectIdentifier));
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        BERSequenceGenerator bERSequenceGenerator3 = this._signers.iterator();
        while (bERSequenceGenerator3.hasNext()) {
            object2 = (SignerInformation)bERSequenceGenerator3.next();
            object = CMSSignedHelper.INSTANCE.fixAlgID(((SignerInformation)object2).getDigestAlgorithmID());
            aSN1EncodableVector.add((ASN1Encodable)object);
        }
        bERSequenceGenerator3 = this.signerGens.iterator();
        while (bERSequenceGenerator3.hasNext()) {
            object2 = (SignerInfoGenerator)bERSequenceGenerator3.next();
            aSN1EncodableVector.add((ASN1Encodable)((SignerInfoGenerator)object2).getDigestAlgorithm());
        }
        bERSequenceGenerator2.getRawOutputStream().write(new DERSet(aSN1EncodableVector).getEncoded());
        bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject((ASN1Encodable)aSN1ObjectIdentifier);
        object2 = bl ? CMSUtils.createBEROctetOutputStream(bERSequenceGenerator3.getRawOutputStream(), 0, true, this._bufferSize) : null;
        object = CMSUtils.getSafeTeeOutputStream(outputStream2, (OutputStream)object2);
        OutputStream outputStream3 = CMSUtils.attachSignersToOutputStream(this.signerGens, (OutputStream)object);
        return new CmsSignedDataOutputStream(outputStream3, aSN1ObjectIdentifier, bERSequenceGenerator, bERSequenceGenerator2, bERSequenceGenerator3);
    }

    public List getDigestAlgorithms() {
        Object object;
        ArrayList<AlgorithmIdentifier> arrayList = new ArrayList<AlgorithmIdentifier>();
        Iterator iterator = this._signers.iterator();
        while (iterator.hasNext()) {
            object = (SignerInformation)iterator.next();
            AlgorithmIdentifier algorithmIdentifier = CMSSignedHelper.INSTANCE.fixAlgID(((SignerInformation)object).getDigestAlgorithmID());
            arrayList.add(algorithmIdentifier);
        }
        iterator = this.signerGens.iterator();
        while (iterator.hasNext()) {
            object = (SignerInfoGenerator)iterator.next();
            arrayList.add(((SignerInfoGenerator)object).getDigestAlgorithm());
        }
        return arrayList;
    }

    private ASN1Integer calculateVersion(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Object e;
        Iterator iterator;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.certs != null) {
            iterator = this.certs.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)e;
                if (aSN1TaggedObject.getTagNo() == 1) {
                    bl3 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() == 2) {
                    bl4 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() != 3) continue;
                bl = true;
            }
        }
        if (bl) {
            return new ASN1Integer(5L);
        }
        if (this.crls != null) {
            iterator = this.crls.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof ASN1TaggedObject)) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            return new ASN1Integer(5L);
        }
        if (bl4) {
            return new ASN1Integer(4L);
        }
        if (bl3) {
            return new ASN1Integer(3L);
        }
        if (this.checkForVersion3(this._signers, this.signerGens)) {
            return new ASN1Integer(3L);
        }
        if (!CMSObjectIdentifiers.data.equals((Object)aSN1ObjectIdentifier)) {
            return new ASN1Integer(3L);
        }
        return new ASN1Integer(1L);
    }

    private boolean checkForVersion3(List list, List list2) {
        Object object;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = SignerInfo.getInstance((Object)((SignerInformation)iterator.next()).toASN1Structure());
            if (object.getVersion().getValue().intValue() != 3) continue;
            return true;
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (SignerInfoGenerator)iterator.next();
            if (((SignerInfoGenerator)object).getGeneratedVersion() != 3) continue;
            return true;
        }
        return false;
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private ASN1ObjectIdentifier _contentOID;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _sigGen;
        private BERSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream outputStream, ASN1ObjectIdentifier aSN1ObjectIdentifier, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this._out = outputStream;
            this._contentOID = aSN1ObjectIdentifier;
            this._sGen = bERSequenceGenerator;
            this._sigGen = bERSequenceGenerator2;
            this._eiGen = bERSequenceGenerator3;
        }

        public void write(int n) throws IOException {
            this._out.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._out.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this._out.write(byArray);
        }

        public void close() throws IOException {
            Object object;
            ASN1Set aSN1Set;
            this._out.close();
            this._eiGen.close();
            CMSSignedDataStreamGenerator.this.digests.clear();
            if (CMSSignedDataStreamGenerator.this.certs.size() != 0) {
                aSN1Set = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.certs);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 0, (ASN1Encodable)aSN1Set).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this.crls.size() != 0) {
                aSN1Set = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.crls);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 1, (ASN1Encodable)aSN1Set).getEncoded());
            }
            aSN1Set = new ASN1EncodableVector();
            Iterator iterator = CMSSignedDataStreamGenerator.this.signerGens.iterator();
            while (iterator.hasNext()) {
                object = (SignerInfoGenerator)iterator.next();
                try {
                    aSN1Set.add((ASN1Encodable)((SignerInfoGenerator)object).generate(this._contentOID));
                    byte[] byArray = ((SignerInfoGenerator)object).getCalculatedDigest();
                    CMSSignedDataStreamGenerator.this.digests.put(((SignerInfoGenerator)object).getDigestAlgorithm().getAlgorithm().getId(), byArray);
                }
                catch (CMSException cMSException) {
                    throw new CMSStreamException("exception generating signers: " + cMSException.getMessage(), cMSException);
                }
            }
            iterator = CMSSignedDataStreamGenerator.this._signers.iterator();
            while (iterator.hasNext()) {
                object = (SignerInformation)iterator.next();
                aSN1Set.add((ASN1Encodable)((SignerInformation)object).toASN1Structure());
            }
            this._sigGen.getRawOutputStream().write(new DERSet((ASN1EncodableVector)aSN1Set).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }
}

