/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.AuthEnvelopedData;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAuthEnvelopedData;
import org.bouncycastle.cms.CMSAuthEnvelopedGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.OutputAEADEncryptor;

public class CMSAuthEnvelopedDataGenerator
extends CMSAuthEnvelopedGenerator {
    private CMSAuthEnvelopedData doGenerate(CMSTypedData cMSTypedData, OutputAEADEncryptor outputAEADEncryptor) throws CMSException {
        AttributeTable attributeTable;
        RecipientInfoGenerator recipientInfoGenerator;
        Object object;
        Object object2;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERSet dERSet = null;
        try {
            object2 = outputAEADEncryptor.getOutputStream(byteArrayOutputStream);
            cMSTypedData.write((OutputStream)object2);
            if (this.authAttrsGenerator != null) {
                object = this.authAttrsGenerator.getAttributes(new HashMap());
                dERSet = new DERSet(object.toASN1EncodableVector());
                outputAEADEncryptor.getAADStream().write(dERSet.getEncoded("DER"));
            }
            ((OutputStream)object2).close();
        }
        catch (IOException iOException) {
            throw new CMSException("unable to process authenticated content: " + iOException.getMessage(), iOException);
        }
        object2 = byteArrayOutputStream.toByteArray();
        object = outputAEADEncryptor.getMAC();
        AlgorithmIdentifier algorithmIdentifier = outputAEADEncryptor.getAlgorithmIdentifier();
        BEROctetString bEROctetString = new BEROctetString((byte[])object2);
        GenericKey genericKey = outputAEADEncryptor.getKey();
        EncryptedContentInfo encryptedContentInfo = this.recipientInfoGenerators.iterator();
        while (encryptedContentInfo.hasNext()) {
            recipientInfoGenerator = (RecipientInfoGenerator)encryptedContentInfo.next();
            aSN1EncodableVector.add((ASN1Encodable)recipientInfoGenerator.generate(genericKey));
        }
        encryptedContentInfo = new EncryptedContentInfo(cMSTypedData.getContentType(), algorithmIdentifier, (ASN1OctetString)bEROctetString);
        recipientInfoGenerator = null;
        if (this.unauthAttrsGenerator != null) {
            attributeTable = this.unauthAttrsGenerator.getAttributes(new HashMap());
            recipientInfoGenerator = new DLSet(attributeTable.toASN1EncodableVector());
        }
        attributeTable = new ContentInfo(CMSObjectIdentifiers.authEnvelopedData, (ASN1Encodable)new AuthEnvelopedData(this.originatorInfo, (ASN1Set)new DERSet(aSN1EncodableVector), encryptedContentInfo, (ASN1Set)dERSet, (ASN1OctetString)new DEROctetString((byte[])object), (ASN1Set)recipientInfoGenerator));
        return new CMSAuthEnvelopedData((ContentInfo)attributeTable);
    }

    public CMSAuthEnvelopedData generate(CMSTypedData cMSTypedData, OutputAEADEncryptor outputAEADEncryptor) throws CMSException {
        return this.doGenerate(cMSTypedData, outputAEADEncryptor);
    }
}

