/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    private boolean isDefiniteLength = false;

    public CMSSignedDataGenerator() {
    }

    public CMSSignedDataGenerator(DigestAlgorithmIdentifierFinder digestAlgIdFinder) {
        super(digestAlgIdFinder);
    }

    public void setDefiniteLengthEncoding(boolean isDefiniteLength) {
        this.isDefiniteLength = isDefiniteLength;
    }

    public CMSSignedData generate(CMSTypedData content) throws CMSException {
        return this.generate(content, false);
    }

    public CMSSignedData generate(CMSTypedData content, boolean encapsulate) throws CMSException {
        LinkedHashSet<AlgorithmIdentifier> digestAlgs = new LinkedHashSet<AlgorithmIdentifier>();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this.digests.clear();
        for (SignerInformation signer : this._signers) {
            CMSUtils.addDigestAlgs(digestAlgs, signer, this.digestAlgIdFinder);
            signerInfos.add((ASN1Encodable)signer.toASN1Structure());
        }
        ASN1ObjectIdentifier encapContentType = content.getContentType();
        Object encapContent = null;
        if (content.getContent() != null) {
            if (encapsulate) {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                this.writeContentViaSignerGens(content, bOut);
                encapContent = this.isDefiniteLength ? new DEROctetString(bOut.toByteArray()) : new BEROctetString(bOut.toByteArray());
            } else {
                this.writeContentViaSignerGens(content, null);
            }
        }
        for (SignerInfoGenerator signerGen : this.signerGens) {
            SignerInfo signerInfo = this.generateSignerInfo(signerGen, encapContentType);
            digestAlgs.add(signerInfo.getDigestAlgorithm());
            signerInfos.add((ASN1Encodable)signerInfo);
        }
        ASN1Set certificates = CMSSignedDataGenerator.createSetFromList(this.certs, this.isDefiniteLength);
        ASN1Set crls = CMSSignedDataGenerator.createSetFromList(this.crls, this.isDefiniteLength);
        ContentInfo encapContentInfo = new ContentInfo(encapContentType, (ASN1Encodable)encapContent);
        SignedData signedData = new SignedData(CMSUtils.convertToDlSet(digestAlgs), encapContentInfo, certificates, crls, (ASN1Set)new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)signedData);
        return new CMSSignedData((CMSProcessable)content, contentInfo);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer) throws CMSException {
        SignerInfo signerInfo;
        this.digests.clear();
        CMSProcessableByteArray content = new CMSProcessableByteArray(null, signer.getSignature());
        ArrayList<SignerInformation> signerInformations = new ArrayList<SignerInformation>();
        for (SignerInformation _signer : this._signers) {
            signerInfo = _signer.toASN1Structure();
            signerInformations.add(new SignerInformation(signerInfo, null, content, null));
        }
        this.writeContentViaSignerGens(content, null);
        for (SignerInfoGenerator signerGen : this.signerGens) {
            signerInfo = this.generateSignerInfo(signerGen, null);
            signerInformations.add(new SignerInformation(signerInfo, null, content, null));
        }
        return new SignerInformationStore(signerInformations);
    }

    private SignerInfo generateSignerInfo(SignerInfoGenerator signerGen, ASN1ObjectIdentifier contentType) throws CMSException {
        SignerInfo signerInfo = signerGen.generate(contentType);
        byte[] calcDigest = signerGen.getCalculatedDigest();
        if (calcDigest != null) {
            this.digests.put(signerInfo.getDigestAlgorithm().getAlgorithm().getId(), calcDigest);
        }
        return signerInfo;
    }

    private void writeContentViaSignerGens(CMSTypedData content, OutputStream s) throws CMSException {
        OutputStream cOut = CMSUtils.attachSignersToOutputStream(this.signerGens, s);
        cOut = CMSUtils.getSafeOutputStream(cOut);
        try {
            content.write(cOut);
            cOut.close();
        }
        catch (IOException e) {
            throw new CMSException("data processing exception: " + e.getMessage(), e);
        }
    }

    private static ASN1Set createSetFromList(List list, boolean isDefiniteLength) {
        return list.size() < 1 ? null : (isDefiniteLength ? CMSUtils.createDlSetFromList(list) : CMSUtils.createBerSetFromList(list));
    }
}

