/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.tsp.MessageImprint;
import org.bouncycastle.asn1.tsp.TimeStampReq;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.tsp.TSPIOException;
import org.bouncycastle.tsp.TSPUtil;
import org.bouncycastle.tsp.TimeStampRequest;

public class TimeStampRequestGenerator {
    private static final DefaultDigestAlgorithmIdentifierFinder DEFAULT_DIGEST_ALG_FINDER = new DefaultDigestAlgorithmIdentifierFinder();
    private final ExtensionsGenerator extGenerator = new ExtensionsGenerator();
    private final DigestAlgorithmIdentifierFinder digestAlgFinder;
    private ASN1ObjectIdentifier reqPolicy;
    private ASN1Boolean certReq;

    public TimeStampRequestGenerator() {
        this(DEFAULT_DIGEST_ALG_FINDER);
    }

    public TimeStampRequestGenerator(DigestAlgorithmIdentifierFinder digestAlgFinder) {
        if (digestAlgFinder == null) {
            throw new NullPointerException("'digestAlgFinder' cannot be null");
        }
        this.digestAlgFinder = digestAlgFinder;
    }

    public void setReqPolicy(ASN1ObjectIdentifier reqPolicy) {
        this.reqPolicy = reqPolicy;
    }

    public void setCertReq(ASN1Boolean certReq) {
        this.certReq = certReq;
    }

    public void setCertReq(boolean certReq) {
        this.setCertReq(ASN1Boolean.getInstance((boolean)certReq));
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) throws TSPIOException {
        TSPUtil.addExtension(this.extGenerator, oid, isCritical, value);
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean isCritical, byte[] value) {
        this.extGenerator.addExtension(oid, isCritical, value);
    }

    public TimeStampRequest generate(ASN1ObjectIdentifier digestAlgorithm, byte[] digest) {
        return this.generate(digestAlgorithm, digest, null);
    }

    public TimeStampRequest generate(ASN1ObjectIdentifier digestAlgorithm, byte[] digest, BigInteger nonce) {
        return this.generate(this.digestAlgFinder.find(digestAlgorithm), digest, nonce);
    }

    public TimeStampRequest generate(AlgorithmIdentifier digestAlgorithmID, byte[] digest) {
        return this.generate(digestAlgorithmID, digest, null);
    }

    public TimeStampRequest generate(AlgorithmIdentifier digestAlgorithmID, byte[] digest, BigInteger nonce) {
        if (digestAlgorithmID == null) {
            throw new NullPointerException("'digestAlgorithmID' cannot be null");
        }
        MessageImprint messageImprint = new MessageImprint(digestAlgorithmID, digest);
        ASN1Integer reqNonce = nonce == null ? null : new ASN1Integer(nonce);
        Extensions ext = this.extGenerator.isEmpty() ? null : this.extGenerator.generate();
        return new TimeStampRequest(new TimeStampReq(messageImprint, this.reqPolicy, reqNonce, this.certReq, ext));
    }
}

