/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.addon;

import java.io.IOException;
import org.bouncycastle.pqc.addon.EncapsulatedSecretExtractor;
import org.bouncycastle.pqc.addon.FrodoEngine;
import org.bouncycastle.pqc.addon.FrodoKeyParameters;
import org.bouncycastle.pqc.addon.FrodoParameters;
import org.bouncycastle.pqc.addon.FrodoPrivateKeyParameters;

class FrodoKEMExtractor
implements EncapsulatedSecretExtractor {
    private FrodoEngine engine;
    private FrodoKeyParameters key;

    public FrodoKEMExtractor(FrodoKeyParameters frodoKeyParameters) {
        this.key = frodoKeyParameters;
        this.initCipher(this.key.getParameters());
    }

    private void initCipher(FrodoParameters frodoParameters) {
        this.engine = frodoParameters.getEngine();
    }

    public byte[] extractSecret(byte[] byArray) {
        byte[] byArray2 = new byte[this.engine.getSessionKeySize()];
        try {
            this.engine.kem_dec(byArray2, byArray, ((FrodoPrivateKeyParameters)this.key).getPrivateKey());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("kem_dec failed!", iOException);
        }
        return byArray2;
    }

    public int getInputSize() {
        return this.engine.getCipherTextSize();
    }
}

