/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.addon;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.pqc.addon.AsymmetricCipherKeyPair;
import org.bouncycastle.pqc.addon.FrodoEngine;
import org.bouncycastle.pqc.addon.FrodoKeyGenerationParameters;
import org.bouncycastle.pqc.addon.FrodoPrivateKeyParameters;
import org.bouncycastle.pqc.addon.FrodoPublicKeyParameters;

class FrodoKeyPairGenerator {
    private FrodoKeyGenerationParameters frodoParams;
    private int n;
    private int D;
    private int B;
    private SecureRandom random;

    FrodoKeyPairGenerator() {
    }

    private void initialize(FrodoKeyGenerationParameters frodoKeyGenerationParameters) {
        this.frodoParams = frodoKeyGenerationParameters;
        this.random = frodoKeyGenerationParameters.getRandom();
        this.n = this.frodoParams.getParameters().getN();
        this.D = this.frodoParams.getParameters().getD();
        this.B = this.frodoParams.getParameters().getB();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        FrodoEngine frodoEngine = this.frodoParams.getParameters().getEngine();
        byte[] byArray = new byte[frodoEngine.getPrivateKeySize()];
        byte[] byArray2 = new byte[frodoEngine.getPublicKeySize()];
        try {
            frodoEngine.kem_keypair(byArray2, byArray, this.random);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("kem_keypair failed!", iOException);
        }
        FrodoPublicKeyParameters frodoPublicKeyParameters = new FrodoPublicKeyParameters(this.frodoParams.getParameters(), byArray2);
        FrodoPrivateKeyParameters frodoPrivateKeyParameters = new FrodoPrivateKeyParameters(this.frodoParams.getParameters(), byArray);
        return new AsymmetricCipherKeyPair(frodoPublicKeyParameters, frodoPrivateKeyParameters);
    }

    public void init(FrodoKeyGenerationParameters frodoKeyGenerationParameters) {
        this.initialize(frodoKeyGenerationParameters);
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

