/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.addon;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.FipsOutputEncryptor;
import org.bouncycastle.crypto.fips.FipsOutputXOFCalculator;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.pqc.addon.Utils;
import org.bouncycastle.util.Arrays;

abstract class FrodoMatrixGenerator {
    int n;
    int q;

    public FrodoMatrixGenerator(int n, int n2) {
        this.n = n;
        this.q = n2;
    }

    abstract short[] genMatrix(byte[] var1);

    static class Aes128MatrixGenerator
    extends FrodoMatrixGenerator {
        public Aes128MatrixGenerator(int n, int n2) {
            super(n, n2);
        }

        short[] genMatrix(byte[] byArray) {
            short[] sArray = new short[this.n * this.n];
            byte[] byArray2 = new byte[16];
            byte[] byArray3 = new byte[16];
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; j += 8) {
                    System.arraycopy(Utils.shortToLittleEndian((short)(i & 0xFFFF)), 0, byArray2, 0, 2);
                    System.arraycopy(Utils.shortToLittleEndian((short)(j & 0xFFFF)), 0, byArray2, 2, 2);
                    this.aes128(byArray3, byArray, byArray2);
                    for (int k = 0; k < 8; ++k) {
                        sArray[i * this.n + j + k] = (short)(Utils.littleEndianToShort(byArray3, 2 * k) % this.q);
                    }
                }
            }
            return sArray;
        }

        void aes128(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            try {
                FipsOutputEncryptor fipsOutputEncryptor = new FipsAES.OperatorFactory().createOutputEncryptor((SymmetricKey)new SymmetricSecretKey((Algorithm)FipsAES.ALGORITHM, byArray2), FipsAES.ECB);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray3.length);
                CipherOutputStream cipherOutputStream = fipsOutputEncryptor.getEncryptingStream((OutputStream)byteArrayOutputStream);
                cipherOutputStream.write(byArray3, 0, byArray3.length);
                cipherOutputStream.close();
                System.arraycopy(byteArrayOutputStream.toByteArray(), 0, byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException.toString(), iOException);
            }
        }
    }

    static class Shake128MatrixGenerator
    extends FrodoMatrixGenerator {
        public Shake128MatrixGenerator(int n, int n2) {
            super(n, n2);
        }

        short[] genMatrix(byte[] byArray) {
            short[] sArray = new short[this.n * this.n];
            byte[] byArray2 = new byte[16 * this.n / 8];
            FipsSHS.XOFOperatorFactory xOFOperatorFactory = new FipsSHS.XOFOperatorFactory();
            for (short s = 0; s < this.n; s = (short)(s + 1)) {
                byte[] byArray3 = Arrays.concatenate((byte[])Utils.shortToLittleEndian(s), (byte[])byArray);
                FipsOutputXOFCalculator fipsOutputXOFCalculator = xOFOperatorFactory.createOutputXOFCalculator(FipsSHS.SHAKE128);
                UpdateOutputStream updateOutputStream = fipsOutputXOFCalculator.getFunctionStream();
                updateOutputStream.update(byArray3, 0, byArray3.length);
                try {
                    updateOutputStream.close();
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("xof close fails!", iOException);
                }
                fipsOutputXOFCalculator.getFunctionOutput(byArray2, 0, byArray2.length);
                for (int n = 0; n < this.n; n = (int)((short)(n + 1))) {
                    sArray[s * this.n + n] = (short)(Utils.littleEndianToShort(byArray2, 2 * n) % this.q);
                }
            }
            return sArray;
        }
    }
}

