/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.addon;

import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.pqc.addon.FrodoEngine;
import org.bouncycastle.pqc.addon.FrodoMatrixGenerator;
import org.bouncycastle.pqc.addon.KEMParameters;

class FrodoParameters
implements KEMParameters {
    private static final short[] cdf_table640 = new short[]{4643, 13363, 20579, 25843, 29227, 31145, 32103, 32525, 32689, 32745, 32762, 32766, Short.MAX_VALUE};
    private static final short[] cdf_table976 = new short[]{5638, 15915, 23689, 28571, 31116, 32217, 32613, 32731, 32760, 32766, Short.MAX_VALUE};
    private static final short[] cdf_table1344 = new short[]{9142, 23462, 30338, 32361, 32725, 32765, Short.MAX_VALUE};
    public static final FrodoParameters frodokem19888r3 = new FrodoParameters("frodokem19888", 640, 15, 2, cdf_table640, FipsSHS.SHAKE128, new FrodoMatrixGenerator.Aes128MatrixGenerator(640, 32768), 64);
    public static final FrodoParameters frodokem19888shaker3 = new FrodoParameters("frodokem19888shake", 640, 15, 2, cdf_table640, FipsSHS.SHAKE128, new FrodoMatrixGenerator.Shake128MatrixGenerator(640, 32768), 64);
    public static final FrodoParameters frodokem31296r3 = new FrodoParameters("frodokem31296", 976, 16, 3, cdf_table976, FipsSHS.SHAKE256, new FrodoMatrixGenerator.Aes128MatrixGenerator(976, 65536), 96);
    public static final FrodoParameters frodokem31296shaker3 = new FrodoParameters("frodokem31296shake", 976, 16, 3, cdf_table976, FipsSHS.SHAKE256, new FrodoMatrixGenerator.Shake128MatrixGenerator(976, 65536), 96);
    public static final FrodoParameters frodokem43088r3 = new FrodoParameters("frodokem43088", 1344, 16, 4, cdf_table1344, FipsSHS.SHAKE256, new FrodoMatrixGenerator.Aes128MatrixGenerator(1344, 65536), 128);
    public static final FrodoParameters frodokem43088shaker3 = new FrodoParameters("frodokem43088shake", 1344, 16, 4, cdf_table1344, FipsSHS.SHAKE256, new FrodoMatrixGenerator.Shake128MatrixGenerator(1344, 65536), 128);
    private final String name;
    private final int n;
    private final int D;
    private final int B;
    private final short[] cdf_table;
    private final FipsSHS.Parameters digest;
    private final FrodoMatrixGenerator mGen;
    private final int defaultKeySize;
    private final FrodoEngine engine;

    public FrodoParameters(String string, int n, int n2, int n3, short[] sArray, FipsSHS.Parameters parameters, FrodoMatrixGenerator frodoMatrixGenerator, int n4) {
        this.name = string;
        this.n = n;
        this.D = n2;
        this.B = n3;
        this.cdf_table = sArray;
        this.digest = parameters;
        this.mGen = frodoMatrixGenerator;
        this.defaultKeySize = n4;
        this.engine = new FrodoEngine(n, n2, n3, sArray, parameters, frodoMatrixGenerator);
    }

    FrodoEngine getEngine() {
        return this.engine;
    }

    public int getN() {
        return this.n;
    }

    public String getName() {
        return this.name;
    }

    public int getD() {
        return this.D;
    }

    public int getB() {
        return this.B;
    }

    public short[] getCdf_table() {
        return this.cdf_table;
    }

    public FipsSHS.Parameters getDigest() {
        return this.digest;
    }

    public int getDefaultKeySize() {
        return this.defaultKeySize;
    }

    public FrodoMatrixGenerator getmGen() {
        return this.mGen;
    }
}

