/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.addon;

import java.security.SecureRandom;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.util.DEROtherInfo;
import org.bouncycastle.pqc.addon.AsymmetricCipherKeyPair;
import org.bouncycastle.pqc.addon.ExchangePair;
import org.bouncycastle.pqc.addon.NHAgreement;
import org.bouncycastle.pqc.addon.NHExchangePairGenerator;
import org.bouncycastle.pqc.addon.NHKeyPairGenerator;
import org.bouncycastle.pqc.addon.NHPrivateKeyParameters;
import org.bouncycastle.pqc.addon.NHPublicKeyParameters;
import org.bouncycastle.pqc.addon.NHUtils;

public class NHOtherInfoGenerator {
    protected final DEROtherInfo.Builder otherInfoBuilder;
    protected final SecureRandom random;
    protected boolean used = false;

    public NHOtherInfoGenerator(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        this.otherInfoBuilder = new DEROtherInfo.Builder(algorithmIdentifier, byArray, byArray2);
        this.random = secureRandom;
    }

    public static class PartyU
    extends NHOtherInfoGenerator {
        private AsymmetricCipherKeyPair aKp;
        private NHAgreement agreement = new NHAgreement();

        public PartyU(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
            super(algorithmIdentifier, byArray, byArray2, secureRandom);
            NHKeyPairGenerator nHKeyPairGenerator = new NHKeyPairGenerator();
            nHKeyPairGenerator.init(secureRandom);
            this.aKp = nHKeyPairGenerator.generateKeyPair();
            this.agreement.init((NHPrivateKeyParameters)this.aKp.getPrivate());
        }

        public NHOtherInfoGenerator withSuppPubInfo(byte[] byArray) {
            this.otherInfoBuilder.withSuppPubInfo(byArray);
            return this;
        }

        public byte[] getSuppPrivInfoPartA() {
            return NHUtils.getEncoded((NHPublicKeyParameters)this.aKp.getPublic());
        }

        public DEROtherInfo generate(byte[] byArray) {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            this.otherInfoBuilder.withSuppPrivInfo(this.agreement.calculateAgreement(NHUtils.getPublicKey(byArray)));
            return this.otherInfoBuilder.build();
        }
    }

    public static class PartyV
    extends NHOtherInfoGenerator {
        public PartyV(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
            super(algorithmIdentifier, byArray, byArray2, secureRandom);
        }

        public NHOtherInfoGenerator withSuppPubInfo(byte[] byArray) {
            this.otherInfoBuilder.withSuppPubInfo(byArray);
            return this;
        }

        public byte[] getSuppPrivInfoPartB(byte[] byArray) {
            NHExchangePairGenerator nHExchangePairGenerator = new NHExchangePairGenerator(this.random);
            ExchangePair exchangePair = nHExchangePairGenerator.generateExchange(NHUtils.getPublicKey(byArray));
            this.otherInfoBuilder.withSuppPrivInfo(exchangePair.getSharedValue());
            return NHUtils.getEncoded((NHPublicKeyParameters)exchangePair.getPublicKey());
        }

        public DEROtherInfo generate() {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            return this.otherInfoBuilder.build();
        }
    }
}

