/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.addon;

import java.security.SecureRandom;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.util.DEROtherInfo;
import org.bouncycastle.pqc.addon.AsymmetricCipherKeyPair;
import org.bouncycastle.pqc.addon.CMCEKEMExtractor;
import org.bouncycastle.pqc.addon.CMCEKEMGenerator;
import org.bouncycastle.pqc.addon.CMCEKeyGenerationParameters;
import org.bouncycastle.pqc.addon.CMCEKeyPairGenerator;
import org.bouncycastle.pqc.addon.CMCEParameters;
import org.bouncycastle.pqc.addon.CMCEPrivateKeyParameters;
import org.bouncycastle.pqc.addon.CMCEPublicKeyParameters;
import org.bouncycastle.pqc.addon.EncapsulatedSecretExtractor;
import org.bouncycastle.pqc.addon.FrodoKEMExtractor;
import org.bouncycastle.pqc.addon.FrodoKEMGenerator;
import org.bouncycastle.pqc.addon.FrodoKeyGenerationParameters;
import org.bouncycastle.pqc.addon.FrodoKeyPairGenerator;
import org.bouncycastle.pqc.addon.FrodoParameters;
import org.bouncycastle.pqc.addon.FrodoPrivateKeyParameters;
import org.bouncycastle.pqc.addon.FrodoPublicKeyParameters;
import org.bouncycastle.pqc.addon.KEMParameters;
import org.bouncycastle.pqc.addon.SecretWithEncapsulationImpl;

public class PQCOtherInfoGenerator {
    protected final DEROtherInfo.Builder otherInfoBuilder;
    protected final SecureRandom random;
    protected final KEMParameters kemParameters;

    public PQCOtherInfoGenerator(KEMParameters kEMParameters, AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        this.kemParameters = kEMParameters;
        this.otherInfoBuilder = new DEROtherInfo.Builder(algorithmIdentifier, byArray, byArray2);
        this.random = secureRandom;
    }

    public static class PartyU
    extends PQCOtherInfoGenerator {
        private AsymmetricCipherKeyPair aKp;
        private EncapsulatedSecretExtractor extractor;

        public PartyU(KEMParameters kEMParameters, AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
            super(kEMParameters, algorithmIdentifier, byArray, byArray2, secureRandom);
            if (kEMParameters instanceof CMCEParameters) {
                CMCEKeyPairGenerator cMCEKeyPairGenerator = new CMCEKeyPairGenerator();
                cMCEKeyPairGenerator.init(new CMCEKeyGenerationParameters(secureRandom, (CMCEParameters)kEMParameters));
                this.aKp = cMCEKeyPairGenerator.generateKeyPair();
                this.extractor = new CMCEKEMExtractor((CMCEPrivateKeyParameters)this.aKp.getPrivate());
            } else {
                FrodoKeyPairGenerator frodoKeyPairGenerator = new FrodoKeyPairGenerator();
                frodoKeyPairGenerator.init(new FrodoKeyGenerationParameters(secureRandom, (FrodoParameters)kEMParameters));
                this.aKp = frodoKeyPairGenerator.generateKeyPair();
                this.extractor = new FrodoKEMExtractor((FrodoPrivateKeyParameters)this.aKp.getPrivate());
            }
        }

        public PQCOtherInfoGenerator withSuppPubInfo(byte[] byArray) {
            this.otherInfoBuilder.withSuppPubInfo(byArray);
            return this;
        }

        public byte[] getSuppPrivInfoPartA() {
            Object object = this.aKp.getPublic();
            if (object instanceof CMCEPublicKeyParameters) {
                return ((CMCEPublicKeyParameters)object).getEncoded();
            }
            return ((FrodoPublicKeyParameters)object).getEncoded();
        }

        public DEROtherInfo generate(byte[] byArray) {
            byte[] byArray2 = this.extractor.extractSecret(byArray);
            this.otherInfoBuilder.withSuppPrivInfo(byArray2);
            Arrays.fill(byArray2, (byte)0);
            return this.otherInfoBuilder.build();
        }
    }

    public static class PartyV
    extends PQCOtherInfoGenerator {
        private SecretWithEncapsulationImpl secretWithEncapsulation;

        public PartyV(KEMParameters kEMParameters, AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
            super(kEMParameters, algorithmIdentifier, byArray, byArray2, secureRandom);
        }

        public PQCOtherInfoGenerator withSuppPubInfo(byte[] byArray) {
            this.otherInfoBuilder.withSuppPubInfo(byArray);
            return this;
        }

        public byte[] getSuppPrivInfoPartB(byte[] byArray) {
            if (this.kemParameters instanceof CMCEParameters) {
                CMCEPublicKeyParameters cMCEPublicKeyParameters = new CMCEPublicKeyParameters((CMCEParameters)this.kemParameters, byArray);
                CMCEKEMGenerator cMCEKEMGenerator = new CMCEKEMGenerator(this.random);
                this.secretWithEncapsulation = (SecretWithEncapsulationImpl)cMCEKEMGenerator.generateEncapsulated(cMCEPublicKeyParameters);
            } else {
                FrodoPublicKeyParameters frodoPublicKeyParameters = new FrodoPublicKeyParameters((FrodoParameters)this.kemParameters, byArray);
                FrodoKEMGenerator frodoKEMGenerator = new FrodoKEMGenerator(this.random);
                this.secretWithEncapsulation = (SecretWithEncapsulationImpl)frodoKEMGenerator.generateEncapsulated(frodoPublicKeyParameters);
            }
            return this.secretWithEncapsulation.getEncapsulation();
        }

        public DEROtherInfo generate() {
            this.otherInfoBuilder.withSuppPrivInfo(this.secretWithEncapsulation.getSecret());
            try {
                this.secretWithEncapsulation.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                throw new IllegalStateException("unable to clean up secret data: " + destroyFailedException.getMessage(), destroyFailedException);
            }
            return this.otherInfoBuilder.build();
        }
    }
}

