/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.addon;

import java.io.IOException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsOutputXOFCalculator;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.pqc.addon.AsymmetricCipherKeyPair;
import org.bouncycastle.pqc.addon.CMCEKEMExtractor;
import org.bouncycastle.pqc.addon.CMCEKEMGenerator;
import org.bouncycastle.pqc.addon.CMCEKeyGenerationParameters;
import org.bouncycastle.pqc.addon.CMCEKeyPairGenerator;
import org.bouncycastle.pqc.addon.CMCEParameters;
import org.bouncycastle.pqc.addon.CMCEPrivateKeyParameters;
import org.bouncycastle.pqc.addon.CMCEPublicKeyParameters;
import org.bouncycastle.pqc.addon.EncapsulatedSecretExtractor;
import org.bouncycastle.pqc.addon.FrodoKEMExtractor;
import org.bouncycastle.pqc.addon.FrodoKEMGenerator;
import org.bouncycastle.pqc.addon.FrodoKeyGenerationParameters;
import org.bouncycastle.pqc.addon.FrodoKeyPairGenerator;
import org.bouncycastle.pqc.addon.FrodoParameters;
import org.bouncycastle.pqc.addon.FrodoPrivateKeyParameters;
import org.bouncycastle.pqc.addon.FrodoPublicKeyParameters;
import org.bouncycastle.pqc.addon.KEMParameters;
import org.bouncycastle.pqc.addon.SecretKeyProcessor;
import org.bouncycastle.pqc.addon.SecretWithEncapsulationImpl;
import org.bouncycastle.util.Arrays;

public class PQCSecretKeyProcessor
implements SecretKeyProcessor {
    private final FipsOutputXOFCalculator xofOperator;

    private PQCSecretKeyProcessor(byte[] byArray, byte[] byArray2) {
        FipsSHS.XOFOperatorFactory xOFOperatorFactory = new FipsSHS.XOFOperatorFactory();
        this.xofOperator = xOFOperatorFactory.createOutputXOFCalculator((FipsParameters)FipsSHS.SHAKE256);
        try {
            UpdateOutputStream updateOutputStream = this.xofOperator.getFunctionStream();
            updateOutputStream.write(byArray);
            if (byArray2 != null) {
                updateOutputStream.write(byArray2);
            }
            updateOutputStream.close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to initialize XOF: " + iOException.getMessage(), iOException);
        }
        Arrays.fill((byte[])byArray, (byte)0);
    }

    public SecretKey processKey(SecretKey secretKey) {
        byte[] byArray = secretKey.getEncoded();
        byte[] byArray2 = this.xofOperator.getFunctionOutput(byArray.length);
        PQCSecretKeyProcessor.xor(byArray, byArray2);
        Arrays.fill((byte[])byArray2, (byte)0);
        return new SecretKeySpec(byArray, secretKey.getAlgorithm());
    }

    private static void xor(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i != byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[i]);
        }
    }

    public static class PartyUBuilder {
        private final AsymmetricCipherKeyPair aKp;
        private final EncapsulatedSecretExtractor extractor;
        private byte[] sharedInfo = null;

        public PartyUBuilder(KEMParameters kEMParameters, SecureRandom secureRandom) {
            if (kEMParameters instanceof CMCEParameters) {
                CMCEKeyPairGenerator cMCEKeyPairGenerator = new CMCEKeyPairGenerator();
                cMCEKeyPairGenerator.init(new CMCEKeyGenerationParameters(secureRandom, (CMCEParameters)kEMParameters));
                this.aKp = cMCEKeyPairGenerator.generateKeyPair();
                this.extractor = new CMCEKEMExtractor((CMCEPrivateKeyParameters)this.aKp.getPrivate());
            } else {
                FrodoKeyPairGenerator frodoKeyPairGenerator = new FrodoKeyPairGenerator();
                frodoKeyPairGenerator.init(new FrodoKeyGenerationParameters(secureRandom, (FrodoParameters)kEMParameters));
                this.aKp = frodoKeyPairGenerator.generateKeyPair();
                this.extractor = new FrodoKEMExtractor((FrodoPrivateKeyParameters)this.aKp.getPrivate());
            }
        }

        public PartyUBuilder withSharedInfo(byte[] byArray) {
            this.sharedInfo = Arrays.clone((byte[])byArray);
            return this;
        }

        public byte[] getPartA() {
            Object object = this.aKp.getPublic();
            if (object instanceof CMCEPublicKeyParameters) {
                return ((CMCEPublicKeyParameters)object).getEncoded();
            }
            return ((FrodoPublicKeyParameters)object).getEncoded();
        }

        public SecretKeyProcessor build(byte[] byArray) {
            return new PQCSecretKeyProcessor(this.extractor.extractSecret(byArray), this.sharedInfo);
        }
    }

    public static class PartyVBuilder {
        private final KEMParameters kemParameters;
        protected final SecureRandom random;
        private byte[] sharedInfo = null;
        private byte[] sharedSecret = null;
        private SecretWithEncapsulationImpl secretWithEncapsulation;
        private boolean used = false;

        public PartyVBuilder(KEMParameters kEMParameters, SecureRandom secureRandom) {
            this.kemParameters = kEMParameters;
            this.random = secureRandom;
        }

        public PartyVBuilder withSharedInfo(byte[] byArray) {
            this.sharedInfo = Arrays.clone((byte[])byArray);
            return this;
        }

        public byte[] getPartB(byte[] byArray) {
            if (this.kemParameters instanceof CMCEParameters) {
                CMCEPublicKeyParameters cMCEPublicKeyParameters = new CMCEPublicKeyParameters((CMCEParameters)this.kemParameters, byArray);
                CMCEKEMGenerator cMCEKEMGenerator = new CMCEKEMGenerator(this.random);
                this.secretWithEncapsulation = (SecretWithEncapsulationImpl)cMCEKEMGenerator.generateEncapsulated(cMCEPublicKeyParameters);
            } else {
                FrodoPublicKeyParameters frodoPublicKeyParameters = new FrodoPublicKeyParameters((FrodoParameters)this.kemParameters, byArray);
                FrodoKEMGenerator frodoKEMGenerator = new FrodoKEMGenerator(this.random);
                this.secretWithEncapsulation = (SecretWithEncapsulationImpl)frodoKEMGenerator.generateEncapsulated(frodoPublicKeyParameters);
            }
            return this.secretWithEncapsulation.getEncapsulation();
        }

        public SecretKeyProcessor build() {
            PQCSecretKeyProcessor pQCSecretKeyProcessor = new PQCSecretKeyProcessor(this.secretWithEncapsulation.getSecret(), this.sharedInfo);
            try {
                this.secretWithEncapsulation.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                throw new IllegalStateException("unable to clean up secret data: " + destroyFailedException.getMessage(), destroyFailedException);
            }
            return pQCSecretKeyProcessor;
        }
    }
}

