/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.addon;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.DestroyFailedException;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.util.Arrays;

public class SecretWithEncapsulationImpl
implements SecretWithEncapsulation {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final byte[] sessionKey;
    private final byte[] cipher_text;

    public SecretWithEncapsulationImpl(byte[] byArray, byte[] byArray2) {
        this.sessionKey = byArray;
        this.cipher_text = byArray2;
    }

    public byte[] getSecret() {
        this.checkDestroyed();
        return Arrays.clone((byte[])this.sessionKey);
    }

    public byte[] getEncapsulation() {
        this.checkDestroyed();
        return Arrays.clone((byte[])this.cipher_text);
    }

    public void destroy() throws DestroyFailedException {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            Arrays.fill((byte[])this.sessionKey, (byte)0);
            Arrays.fill((byte[])this.cipher_text, (byte)0);
        }
    }

    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    void checkDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("data has been destroyed");
        }
    }
}

