/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import java.util.Random;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecT283FieldElement;
import org.bouncycastle.math.ec.custom.sec.SecT283R1Point;
import org.bouncycastle.util.encoders.Hex;

public class SecT283R1Curve
extends ECCurve.AbstractF2m {
    private static final int SecT283R1_DEFAULT_COORDS = 6;
    protected SecT283R1Point infinity = new SecT283R1Point(this, null, null);

    public SecT283R1Curve() {
        super(283, 5, 7, 12);
        this.a = this.fromBigInteger(BigInteger.valueOf(1L));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("027B680AC8B8596DA5A4AF8A19A0303FCA97FD7645309FA2A581485AF6263E313B79A2F5")));
        this.order = new BigInteger(1, Hex.decode("03FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEF90399660FC938A90165B042A7CEFADB307"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT283R1Curve();
    }

    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return 283;
    }

    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecT283FieldElement(x);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, boolean withCompression) {
        return new SecT283R1Point((ECCurve)this, x, y, withCompression);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs, boolean withCompression) {
        return new SecT283R1Point(this, x, y, zs, withCompression);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return false;
    }

    protected ECPoint decompressPoint(int yTilde, BigInteger X1) {
        ECFieldElement x = this.fromBigInteger(X1);
        ECFieldElement y = null;
        if (x.isZero()) {
            y = this.b.sqrt();
        } else {
            ECFieldElement beta = x.square().invert().multiply(this.b).add(this.a).add(x);
            ECFieldElement z = this.solveQuadraticEquation(beta);
            if (z != null) {
                if (z.testBitZero() != (yTilde == 1)) {
                    z = z.addOne();
                }
                switch (this.getCoordinateSystem()) {
                    case 5: 
                    case 6: {
                        y = z.add(x);
                        break;
                    }
                    default: {
                        y = z.multiply(x);
                    }
                }
            }
        }
        if (y == null) {
            throw new IllegalArgumentException("Invalid point compression");
        }
        return this.createRawPoint(x, y, true);
    }

    private ECFieldElement solveQuadraticEquation(ECFieldElement beta) {
        if (beta.isZero()) {
            return beta;
        }
        ECFieldElement zeroElement = this.fromBigInteger(ECConstants.ZERO);
        ECFieldElement z = null;
        ECFieldElement gamma = null;
        Random rand = new Random();
        do {
            ECFieldElement t = this.fromBigInteger(new BigInteger(283, rand));
            z = zeroElement;
            ECFieldElement w = beta;
            for (int i = 1; i < 283; ++i) {
                ECFieldElement w2 = w.square();
                z = z.square().add(w2.multiply(t));
                w = w2.add(beta);
            }
            if (w.isZero()) continue;
            return null;
        } while ((gamma = z.square().add(z)).isZero());
        return z;
    }

    public int getM() {
        return 283;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 5;
    }

    public int getK2() {
        return 7;
    }

    public int getK3() {
        return 12;
    }
}

