/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.KeccakDigest;

public class SHAKEDigest
extends KeccakDigest
implements Xof {
    private static int checkBitLength(int bitLength) {
        switch (bitLength) {
            case 128: 
            case 256: {
                return bitLength;
            }
        }
        throw new IllegalArgumentException("'bitLength' " + bitLength + " not supported for SHAKE");
    }

    public SHAKEDigest() {
        this(128);
    }

    public SHAKEDigest(int bitLength) {
        super(SHAKEDigest.checkBitLength(bitLength));
    }

    public SHAKEDigest(SHAKEDigest source) {
        super(source);
    }

    public String getAlgorithmName() {
        return "SHAKE" + this.fixedOutputLength;
    }

    public int doFinal(byte[] out, int outOff) {
        return this.doFinal(out, outOff, this.getDigestSize());
    }

    public int doFinal(byte[] out, int outOff, int outLen) {
        int length = this.doOutput(out, outOff, outLen);
        this.reset();
        return length;
    }

    public int doOutput(byte[] out, int outOff, int outLen) {
        if (!this.squeezing) {
            this.absorb(new byte[]{15}, 0, 4L);
        }
        this.squeeze(out, outOff, (long)outLen * 8L);
        return outLen;
    }

    protected int doFinal(byte[] out, int outOff, byte partialByte, int partialBits) {
        return this.doFinal(out, outOff, this.getDigestSize(), partialByte, partialBits);
    }

    protected int doFinal(byte[] out, int outOff, int outLen, byte partialByte, int partialBits) {
        if (partialBits < 0 || partialBits > 7) {
            throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
        }
        int finalInput = partialByte & (1 << partialBits) - 1 | 15 << partialBits;
        int finalBits = partialBits + 4;
        if (finalBits >= 8) {
            this.oneByte[0] = (byte)finalInput;
            this.absorb(this.oneByte, 0, 8L);
            finalBits -= 8;
            finalInput >>>= 8;
        }
        if (finalBits > 0) {
            this.oneByte[0] = (byte)finalInput;
            this.absorb(this.oneByte, 0, finalBits);
        }
        this.squeeze(out, outOff, (long)outLen * 8L);
        this.reset();
        return outLen;
    }
}

