/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.RandomDSAKCalculator;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.util.BigIntegers;

public class SM2Signer
implements DSA,
ECConstants {
    private final DSAKCalculator kCalculator = new RandomDSAKCalculator();
    private byte[] userID;
    private int curveLength;
    private ECDomainParameters ecParams;
    private ECPoint pubPoint;
    private ECKeyParameters ecKey;
    private SecureRandom random;

    public void init(boolean forSigning, CipherParameters param) {
        CipherParameters baseParam;
        if (param instanceof ParametersWithID) {
            baseParam = ((ParametersWithID)param).getParameters();
            this.userID = ((ParametersWithID)param).getID();
        } else {
            baseParam = param;
            this.userID = new byte[0];
        }
        if (forSigning) {
            if (baseParam instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)baseParam;
                this.ecKey = (ECKeyParameters)rParam.getParameters();
                this.ecParams = this.ecKey.getParameters();
                this.kCalculator.init(this.ecParams.getN(), rParam.getRandom());
            } else {
                this.ecKey = (ECKeyParameters)baseParam;
                this.ecParams = this.ecKey.getParameters();
                this.kCalculator.init(this.ecParams.getN(), new SecureRandom());
            }
            this.pubPoint = this.ecParams.getG().multiply(((ECPrivateKeyParameters)this.ecKey).getD()).normalize();
        } else {
            this.ecKey = (ECKeyParameters)baseParam;
            this.ecParams = this.ecKey.getParameters();
            this.pubPoint = ((ECPublicKeyParameters)this.ecKey).getQ();
        }
        this.curveLength = (this.ecParams.getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger[] generateSignature(byte[] message) {
        BigInteger s;
        BigInteger r;
        SM3Digest digest = new SM3Digest();
        byte[] z = this.getZ(digest);
        digest.update(z, 0, z.length);
        digest.update(message, 0, message.length);
        byte[] eHash = new byte[digest.getDigestSize()];
        digest.doFinal(eHash, 0);
        BigInteger n = this.ecParams.getN();
        BigInteger e = this.calculateE(eHash);
        BigInteger d = ((ECPrivateKeyParameters)this.ecKey).getD();
        ECMultiplier basePointMultiplier = this.createBasePointMultiplier();
        while (true) {
            BigInteger k = this.kCalculator.nextK();
            ECPoint p = basePointMultiplier.multiply(this.ecParams.getG(), k).normalize();
            r = e.add(p.getAffineXCoord().toBigInteger()).mod(n);
            if (r.equals(ZERO) || r.add(k).equals(n)) continue;
            BigInteger dPlus1ModN = d.add(ONE).modInverse(n);
            s = k.subtract(r.multiply(d)).mod(n);
            if (!(s = dPlus1ModN.multiply(s).mod(n)).equals(ZERO)) break;
        }
        return new BigInteger[]{r, s};
    }

    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        BigInteger n = this.ecParams.getN();
        if (r.compareTo(ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        ECPoint q = ((ECPublicKeyParameters)this.ecKey).getQ();
        SM3Digest digest = new SM3Digest();
        byte[] z = this.getZ(digest);
        digest.update(z, 0, z.length);
        digest.update(message, 0, message.length);
        byte[] eHash = new byte[digest.getDigestSize()];
        digest.doFinal(eHash, 0);
        BigInteger e = this.calculateE(eHash);
        BigInteger t = r.add(s).mod(n);
        if (t.equals(ZERO)) {
            return false;
        }
        ECPoint x1y1 = this.ecParams.getG().multiply(s);
        x1y1 = x1y1.add(q.multiply(t)).normalize();
        return r.equals(e.add(x1y1.getAffineXCoord().toBigInteger()).mod(n));
    }

    private byte[] getZ(Digest digest) {
        this.addUserID(digest, this.userID);
        this.addFieldElement(digest, this.ecParams.getCurve().getA());
        this.addFieldElement(digest, this.ecParams.getCurve().getB());
        this.addFieldElement(digest, this.ecParams.getG().getAffineXCoord());
        this.addFieldElement(digest, this.ecParams.getG().getAffineYCoord());
        this.addFieldElement(digest, this.pubPoint.getAffineXCoord());
        this.addFieldElement(digest, this.pubPoint.getAffineYCoord());
        byte[] rv = new byte[digest.getDigestSize()];
        digest.doFinal(rv, 0);
        return rv;
    }

    private void addUserID(Digest digest, byte[] userID) {
        int len = userID.length * 8;
        digest.update((byte)(len >> 8 & 0xFF));
        digest.update((byte)(len & 0xFF));
        digest.update(userID, 0, userID.length);
    }

    private void addFieldElement(Digest digest, ECFieldElement v) {
        byte[] p = BigIntegers.asUnsignedByteArray(this.curveLength, v.toBigInteger());
        digest.update(p, 0, p.length);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    protected BigInteger calculateE(byte[] message) {
        return new BigInteger(1, message);
    }
}

