/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.math.BigInteger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Properties {
    private static final ThreadLocal threadProperties = new ThreadLocal();

    private Properties() {
    }

    public static boolean isOverrideSet(String propertyName) {
        try {
            String p = Properties.getPropertyValue(propertyName);
            return "true".equalsIgnoreCase(p);
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public static boolean setThreadOverride(String propertyName, boolean enable) {
        boolean isSet = Properties.isOverrideSet(propertyName);
        HashMap<String, String> localProps = (HashMap<String, String>)threadProperties.get();
        if (localProps == null) {
            localProps = new HashMap<String, String>();
            threadProperties.set(localProps);
        }
        localProps.put(propertyName, enable ? "true" : "false");
        return isSet;
    }

    public static boolean removeThreadOverride(String propertyName) {
        String p;
        Map localProps = (Map)threadProperties.get();
        if (localProps != null && (p = (String)localProps.remove(propertyName)) != null) {
            if (localProps.isEmpty()) {
                threadProperties.remove();
            }
            return "true".equalsIgnoreCase(p);
        }
        return false;
    }

    public static BigInteger asBigInteger(String propertyName) {
        String p = Properties.getPropertyValue(propertyName);
        if (p != null) {
            return new BigInteger(p);
        }
        return null;
    }

    public static Set<String> asKeySet(String propertyName) {
        HashSet<String> set = new HashSet<String>();
        String p = Properties.getPropertyValue(propertyName);
        if (p != null) {
            StringTokenizer sTok = new StringTokenizer(p, ",");
            while (sTok.hasMoreElements()) {
                set.add(Strings.toLowerCase(sTok.nextToken()).trim());
            }
        }
        return Collections.unmodifiableSet(set);
    }

    public static String getPropertyValue(final String propertyName) {
        String p;
        String val = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty(propertyName);
            }
        });
        if (val != null) {
            return val;
        }
        Map localProps = (Map)threadProperties.get();
        if (localProps != null && (p = (String)localProps.get(propertyName)) != null) {
            return p;
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propertyName);
            }
        });
    }
}

