/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.encodings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;

public class PKCS1Encoding
implements AsymmetricBlockCipher {
    public static final String STRICT_LENGTH_ENABLED_PROPERTY = "org.bouncycastle.pkcs1.strict";
    public static final String NOT_STRICT_LENGTH_ENABLED_PROPERTY = "org.bouncycastle.pkcs1.not_strict";
    private static final int HEADER_LENGTH = 10;
    private SecureRandom random;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private boolean useStrictLength;
    private int pLen = -1;
    private byte[] fallback = null;
    private byte[] blockBuffer;

    public PKCS1Encoding(AsymmetricBlockCipher cipher) {
        this.engine = cipher;
        this.useStrictLength = this.useStrict();
    }

    public PKCS1Encoding(AsymmetricBlockCipher cipher, int pLen) {
        this.engine = cipher;
        this.useStrictLength = this.useStrict();
        this.pLen = pLen;
    }

    public PKCS1Encoding(AsymmetricBlockCipher cipher, byte[] fallback) {
        this.engine = cipher;
        this.useStrictLength = this.useStrict();
        this.fallback = fallback;
        this.pLen = fallback.length;
    }

    private boolean useStrict() {
        if (Properties.isOverrideSetTo(NOT_STRICT_LENGTH_ENABLED_PROPERTY, true)) {
            return false;
        }
        return !Properties.isOverrideSetTo(STRICT_LENGTH_ENABLED_PROPERTY, false);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean forEncryption, CipherParameters param) {
        AsymmetricKeyParameter kParam;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.random = rParam.getRandom();
            kParam = (AsymmetricKeyParameter)rParam.getParameters();
        } else {
            kParam = (AsymmetricKeyParameter)param;
            if (!kParam.isPrivate() && forEncryption) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
        }
        this.engine.init(forEncryption, param);
        this.forPrivateKey = kParam.isPrivate();
        this.forEncryption = forEncryption;
        this.blockBuffer = new byte[this.engine.getOutputBlockSize()];
        if (this.pLen > 0 && this.fallback == null && this.random == null) {
            throw new IllegalArgumentException("encoder requires random");
        }
    }

    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize - 10;
        }
        return baseBlockSize;
    }

    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize;
        }
        return baseBlockSize - 10;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    private byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (inLen > this.getInputBlockSize()) {
            throw new IllegalArgumentException("input data too large");
        }
        byte[] block = new byte[this.engine.getInputBlockSize()];
        if (this.forPrivateKey) {
            block[0] = 1;
            for (int i = 1; i != block.length - inLen - 1; ++i) {
                block[i] = -1;
            }
        } else {
            this.random.nextBytes(block);
            block[0] = 2;
            for (int i = 1; i != block.length - inLen - 1; ++i) {
                while (block[i] == 0) {
                    block[i] = (byte)this.random.nextInt();
                }
            }
        }
        block[block.length - inLen - 1] = 0;
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        return this.engine.processBlock(block, 0, block.length);
    }

    private static int checkPkcs1Encoding1(byte[] buf) {
        int foundZeroMask = 0;
        int lastPadPos = 0;
        int badPadSign = -(buf[0] & 0xFF ^ 1);
        for (int i = 1; i < buf.length; ++i) {
            int padByte = buf[i] & 0xFF;
            int is0x00Mask = (padByte ^ 0) - 1 >> 31;
            int is0xFFMask = (padByte ^ 0xFF) - 1 >> 31;
            lastPadPos ^= i & ~foundZeroMask & is0x00Mask;
            badPadSign |= ~((foundZeroMask |= is0x00Mask) | is0xFFMask);
        }
        int plaintextLength = buf.length - 1 - lastPadPos;
        return plaintextLength | (badPadSign |= lastPadPos - 9) >> 31;
    }

    private static int checkPkcs1Encoding2(byte[] buf) {
        int foundZeroMask = 0;
        int lastPadPos = 0;
        int badPadSign = -(buf[0] & 0xFF ^ 2);
        for (int i = 1; i < buf.length; ++i) {
            int padByte = buf[i] & 0xFF;
            int is0x00Mask = (padByte ^ 0) - 1 >> 31;
            lastPadPos ^= i & ~foundZeroMask & is0x00Mask;
            foundZeroMask |= is0x00Mask;
        }
        int plaintextLength = buf.length - 1 - lastPadPos;
        return plaintextLength | (badPadSign |= lastPadPos - 9) >> 31;
    }

    private static int checkPkcs1Encoding2(byte[] buf, int plaintextLength) {
        int badPadSign = -(buf[0] & 0xFF ^ 2);
        int lastPadPos = buf.length - 1 - plaintextLength;
        badPadSign |= lastPadPos - 9;
        for (int i = 1; i < lastPadPos; ++i) {
            badPadSign |= (buf[i] & 0xFF) - 1;
        }
        return (badPadSign |= -(buf[lastPadPos] & 0xFF)) >> 31;
    }

    private byte[] decodeBlockOrRandom(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] block;
        if (!this.forPrivateKey) {
            throw new InvalidCipherTextException("sorry, this method is only for decryption, not for signing");
        }
        int plaintextLength = this.pLen;
        byte[] random = this.fallback;
        if (this.fallback == null) {
            random = new byte[plaintextLength];
            this.random.nextBytes(random);
        }
        int badPadMask = 0;
        int strictBlockSize = this.engine.getOutputBlockSize();
        byte[] data = block = this.engine.processBlock(in, inOff, inLen);
        if (block.length != strictBlockSize && (this.useStrictLength || block.length < strictBlockSize)) {
            data = this.blockBuffer;
        }
        badPadMask |= PKCS1Encoding.checkPkcs1Encoding2(data, plaintextLength);
        int dataOff = data.length - plaintextLength;
        byte[] result = new byte[plaintextLength];
        for (int i = 0; i < plaintextLength; ++i) {
            result[i] = (byte)(data[dataOff + i] & ~badPadMask | random[i] & badPadMask);
        }
        Arrays.fill(block, (byte)0);
        Arrays.fill(this.blockBuffer, 0, Math.max(0, this.blockBuffer.length - block.length), (byte)0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forPrivateKey && this.pLen != -1) {
            return this.decodeBlockOrRandom(in, inOff, inLen);
        }
        int strictBlockSize = this.engine.getOutputBlockSize();
        byte[] block = this.engine.processBlock(in, inOff, inLen);
        boolean incorrectLength = this.useStrictLength & block.length != strictBlockSize;
        byte[] data = block;
        if (block.length < strictBlockSize) {
            data = this.blockBuffer;
        }
        int plaintextLength = this.forPrivateKey ? PKCS1Encoding.checkPkcs1Encoding2(data) : PKCS1Encoding.checkPkcs1Encoding1(data);
        try {
            if (plaintextLength < 0) {
                throw new InvalidCipherTextException("block incorrect");
            }
            if (incorrectLength) {
                throw new InvalidCipherTextException("block incorrect size");
            }
            byte[] result = new byte[plaintextLength];
            System.arraycopy(data, data.length - plaintextLength, result, 0, plaintextLength);
            byte[] byArray = result;
            return byArray;
        }
        finally {
            Arrays.fill(block, (byte)0);
            Arrays.fill(this.blockBuffer, 0, Math.max(0, this.blockBuffer.length - block.length), (byte)0);
        }
    }
}

