/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.Validity;

public class Certificate
extends ASN1Object {
    ASN1Sequence seq;
    TBSCertificate tbsCert;
    AlgorithmIdentifier sigAlgId;
    ASN1BitString sig;

    public static Certificate getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Certificate.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static Certificate getInstance(Object obj) {
        if (obj instanceof Certificate) {
            return (Certificate)obj;
        }
        if (obj != null) {
            return new Certificate(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private Certificate(ASN1Sequence seq) {
        this.seq = seq;
        if (seq.size() != 3) {
            throw new IllegalArgumentException("sequence wrong size for a certificate");
        }
        this.tbsCert = TBSCertificate.getInstance(seq.getObjectAt(0));
        this.sigAlgId = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        this.sig = ASN1BitString.getInstance(seq.getObjectAt(2));
    }

    public Certificate(TBSCertificate tbsCertificate, AlgorithmIdentifier signatureAlgorithm, ASN1BitString signature) {
        if (tbsCertificate == null) {
            throw new NullPointerException("'tbsCertificate' cannot be null");
        }
        if (signatureAlgorithm == null) {
            throw new NullPointerException("'signatureAlgorithm' cannot be null");
        }
        if (signature == null) {
            throw new NullPointerException("'signature' cannot be null");
        }
        this.tbsCert = tbsCertificate;
        this.sigAlgId = signatureAlgorithm;
        this.sig = signature;
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        v.add(tbsCertificate);
        v.add(signatureAlgorithm);
        v.add(signature);
        this.seq = new DERSequence(v);
    }

    public TBSCertificate getTBSCertificate() {
        return this.tbsCert;
    }

    public ASN1Integer getVersion() {
        return this.tbsCert.getVersion();
    }

    public int getVersionNumber() {
        return this.tbsCert.getVersionNumber();
    }

    public ASN1Integer getSerialNumber() {
        return this.tbsCert.getSerialNumber();
    }

    public X500Name getIssuer() {
        return this.tbsCert.getIssuer();
    }

    public Validity getValidity() {
        return this.tbsCert.getValidity();
    }

    public Time getStartDate() {
        return this.tbsCert.getStartDate();
    }

    public Time getEndDate() {
        return this.tbsCert.getEndDate();
    }

    public X500Name getSubject() {
        return this.tbsCert.getSubject();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.tbsCert.getSubjectPublicKeyInfo();
    }

    public ASN1BitString getIssuerUniqueID() {
        return this.tbsCert.getIssuerUniqueId();
    }

    public ASN1BitString getSubjectUniqueID() {
        return this.tbsCert.getSubjectUniqueId();
    }

    public Extensions getExtensions() {
        return this.tbsCert.getExtensions();
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.sigAlgId;
    }

    public ASN1BitString getSignature() {
        return this.sig;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }
}

