/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.crypto.digests.SHAKEDigest;

abstract class Symmetric {
    final int stream128BlockBytes;
    final int stream256BlockBytes;

    Symmetric(int stream128, int stream256) {
        this.stream128BlockBytes = stream128;
        this.stream256BlockBytes = stream256;
    }

    abstract void stream128init(byte[] var1, short var2);

    abstract void stream256init(byte[] var1, short var2);

    abstract void stream128squeezeBlocks(byte[] var1, int var2, int var3);

    abstract void stream256squeezeBlocks(byte[] var1, int var2, int var3);

    static class ShakeSymmetric
    extends Symmetric {
        private final SHAKEDigest digest128 = new SHAKEDigest(128);
        private final SHAKEDigest digest256 = new SHAKEDigest(256);

        ShakeSymmetric() {
            super(168, 136);
        }

        private void streamInit(SHAKEDigest digest, byte[] seed, short nonce) {
            digest.reset();
            byte[] temp = new byte[]{(byte)nonce, (byte)(nonce >> 8)};
            digest.update(seed, 0, seed.length);
            digest.update(temp, 0, temp.length);
        }

        void stream128init(byte[] seed, short nonce) {
            this.streamInit(this.digest128, seed, nonce);
        }

        void stream256init(byte[] seed, short nonce) {
            this.streamInit(this.digest256, seed, nonce);
        }

        void stream128squeezeBlocks(byte[] output, int offset, int size) {
            this.digest128.doOutput(output, offset, size);
        }

        void stream256squeezeBlocks(byte[] output, int offset, int size) {
            this.digest256.doOutput(output, offset, size);
        }
    }
}

