/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.lms;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.jcajce.interfaces.LMSPrivateKey;
import org.bouncycastle.util.Arrays;

public class BCLMSPrivateKey
implements PrivateKey,
LMSPrivateKey {
    private static final long serialVersionUID = 8568701712864512338L;
    private transient LMSKeyParameters keyParams;
    private transient ASN1Set attributes;

    public BCLMSPrivateKey(LMSKeyParameters keyParams) {
        this.keyParams = keyParams instanceof HSSPrivateKeyParameters ? (HSSPrivateKeyParameters)keyParams : new HSSPrivateKeyParameters((LMSPrivateKeyParameters)keyParams, ((LMSPrivateKeyParameters)keyParams).getIndex(), (long)((LMSPrivateKeyParameters)keyParams).getIndex() + ((LMSPrivateKeyParameters)keyParams).getUsagesRemaining());
    }

    public BCLMSPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(PrivateKeyInfo keyInfo) throws IOException {
        this.attributes = keyInfo.getAttributes();
        this.keyParams = (LMSKeyParameters)PrivateKeyFactory.createKey(keyInfo);
    }

    public long getIndex() {
        if (this.getUsagesRemaining() == 0L) {
            throw new IllegalStateException("key exhausted");
        }
        if (this.keyParams instanceof LMSPrivateKeyParameters) {
            return ((LMSPrivateKeyParameters)this.keyParams).getIndex();
        }
        return ((HSSPrivateKeyParameters)this.keyParams).getIndex();
    }

    public long getUsagesRemaining() {
        if (this.keyParams instanceof LMSPrivateKeyParameters) {
            return ((LMSPrivateKeyParameters)this.keyParams).getUsagesRemaining();
        }
        return ((HSSPrivateKeyParameters)this.keyParams).getUsagesRemaining();
    }

    public LMSPrivateKey extractKeyShard(int usageCount) {
        if (this.keyParams instanceof LMSPrivateKeyParameters) {
            return new BCLMSPrivateKey(((LMSPrivateKeyParameters)this.keyParams).extractKeyShard(usageCount));
        }
        return new BCLMSPrivateKey(((HSSPrivateKeyParameters)this.keyParams).extractKeyShard(usageCount));
    }

    public String getAlgorithm() {
        return "LMS";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        try {
            PrivateKeyInfo pki = PrivateKeyInfoFactory.createPrivateKeyInfo(this.keyParams, this.attributes);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCLMSPrivateKey) {
            BCLMSPrivateKey otherKey = (BCLMSPrivateKey)o;
            try {
                return Arrays.areEqual(this.keyParams.getEncoded(), otherKey.keyParams.getEncoded());
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to perform equals");
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return Arrays.hashCode(this.keyParams.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to calculate hashCode");
        }
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    public int getLevels() {
        if (this.keyParams instanceof LMSPrivateKeyParameters) {
            return 1;
        }
        return ((HSSPrivateKeyParameters)this.keyParams).getL();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(PrivateKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

