/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.gemss;

import java.security.SecureRandom;
import org.bouncycastle.pqc.legacy.crypto.gemss.Pointer;

class PointerUnion
extends Pointer {
    protected int remainder;

    public PointerUnion(byte[] arr) {
        super((arr.length >> 3) + ((arr.length & 7) != 0 ? 1 : 0));
        int i = 0;
        for (int q = 0; i < arr.length && q < this.array.length; ++q) {
            for (int r = 0; r < 8 && i < arr.length; ++r, ++i) {
                int n = q;
                this.array[n] = this.array[n] | ((long)arr[i] & 0xFFL) << (r << 3);
            }
        }
        this.remainder = 0;
    }

    public PointerUnion(int p) {
        super((p >>> 3) + ((p & 7) != 0 ? 1 : 0));
        this.remainder = 0;
    }

    public PointerUnion(PointerUnion p) {
        super(p);
        this.remainder = p.remainder;
    }

    public PointerUnion(Pointer p) {
        super(p);
        this.remainder = 0;
    }

    public void moveNextBytes(int p) {
        this.remainder += p;
        this.cp += this.remainder >>> 3;
        this.remainder &= 7;
    }

    public void moveNextByte() {
        ++this.remainder;
        this.cp += this.remainder >>> 3;
        this.remainder &= 7;
    }

    public long get() {
        if (this.remainder == 0) {
            return this.array[this.cp];
        }
        return this.array[this.cp] >>> (this.remainder << 3) | this.array[this.cp + 1] << (8 - this.remainder << 3);
    }

    public long getWithCheck() {
        if (this.cp >= this.array.length) {
            return 0L;
        }
        if (this.remainder == 0) {
            return this.array[this.cp];
        }
        if (this.cp == this.array.length - 1) {
            return this.array[this.cp] >>> (this.remainder << 3);
        }
        return this.array[this.cp] >>> (this.remainder << 3) | this.array[this.cp + 1] << (8 - this.remainder << 3);
    }

    public long getWithCheck(int p) {
        if ((p += this.cp) >= this.array.length) {
            return 0L;
        }
        if (this.remainder == 0) {
            return this.array[p];
        }
        if (p == this.array.length - 1) {
            return this.array[p] >>> (this.remainder << 3);
        }
        return this.array[p] >>> (this.remainder << 3) | this.array[p + 1] << (8 - this.remainder << 3);
    }

    public long get(int q) {
        if (this.remainder == 0) {
            return this.array[this.cp + q];
        }
        return this.array[this.cp + q] >>> (this.remainder << 3) | this.array[this.cp + q + 1] << (8 - this.remainder << 3);
    }

    public byte getByte() {
        return (byte)(this.array[this.cp] >>> (this.remainder << 3));
    }

    public byte getByte(int p) {
        int q = this.cp + (p + this.remainder >>> 3);
        int r = this.remainder + p & 7;
        return (byte)(this.array[q] >>> (r << 3));
    }

    public void setRangeClear(int startPos, int endPos) {
        if (this.remainder == 0) {
            super.setRangeClear(startPos, endPos);
        } else {
            int n = this.cp + startPos;
            this.array[n] = this.array[n] & -1L >>> (8 - this.remainder << 3);
            super.setRangeClear(startPos + 1, endPos);
            int n2 = this.cp + endPos + 1;
            this.array[n2] = this.array[n2] & -1L << (this.remainder << 3);
        }
    }

    public void setAnd(int p, long v) {
        if (this.remainder == 0) {
            super.setAnd(p, v);
        } else {
            int shift1 = this.remainder << 3;
            int shift2 = 8 - this.remainder << 3;
            int n = this.cp + p;
            this.array[n] = this.array[n] & (v << shift1 | -1L >>> shift2);
            int n2 = this.cp + p + 1;
            this.array[n2] = this.array[n2] & (v >>> shift2 | -1L << shift1);
        }
    }

    public void indexReset() {
        this.cp = 0;
        this.remainder = 0;
    }

    public void setByteIndex(int p) {
        this.remainder = p & 7;
        this.cp = p >>> 3;
    }

    public byte[] toBytes(int length) {
        byte[] res = new byte[length];
        for (int i = this.remainder; i < res.length + this.remainder; ++i) {
            res[i - this.remainder] = (byte)(this.array[this.cp + (i >>> 3)] >>> ((i & 7) << 3));
        }
        return res;
    }

    public int toBytesMove(byte[] output, int outOff, int length) {
        for (int i = 0; i < length; ++i) {
            output[outOff++] = (byte)(this.array[this.cp] >>> (this.remainder++ << 3));
            if (this.remainder != 8) continue;
            this.remainder = 0;
            ++this.cp;
        }
        return outOff;
    }

    public void setXor(int p, long v) {
        if (this.remainder == 0) {
            super.setXor(p, v);
        } else {
            int n = this.cp + p;
            this.array[n] = this.array[n] ^ v << (this.remainder << 3);
            int n2 = this.cp + p + 1;
            this.array[n2] = this.array[n2] ^ v >>> (8 - this.remainder << 3);
        }
    }

    public void setXor(long v) {
        if (this.remainder == 0) {
            super.setXor(v);
        } else {
            int n = this.cp;
            this.array[n] = this.array[n] ^ v << (this.remainder << 3);
            int n2 = this.cp + 1;
            this.array[n2] = this.array[n2] ^ v >>> (8 - this.remainder << 3);
        }
    }

    public void setXorRangeAndMask(Pointer p, int len, long mask) {
        if (this.remainder == 0) {
            super.setXorRangeAndMask(p, len, mask);
            return;
        }
        int outOff = this.cp;
        int inOff = p.cp;
        int left = this.remainder << 3;
        int right = 8 - this.remainder << 3;
        for (int i = 0; i < len; ++i) {
            long v = p.array[inOff++] & mask;
            int n = outOff++;
            this.array[n] = this.array[n] ^ v << left;
            int n2 = outOff;
            this.array[n2] = this.array[n2] ^ v >>> right;
        }
    }

    public void setXorByte(int v) {
        int n = this.cp;
        this.array[n] = this.array[n] ^ ((long)v & 0xFFL) << (this.remainder << 3);
    }

    public void setAndByte(int p, long v) {
        int r = p + this.remainder + (this.cp << 3);
        int q = r >>> 3;
        int n = q;
        this.array[n] = this.array[n] & ((v & 0xFFL) << ((r &= 7) << 3) | 255L << (r << 3) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void setAndThenXorByte(int p, long v1, long v2) {
        int r = p + this.remainder + (this.cp << 3);
        int q = r >>> 3;
        int n = q;
        this.array[n] = this.array[n] & ((v1 & 0xFFL) << ((r &= 7) << 3) | 255L << (r << 3) ^ 0xFFFFFFFFFFFFFFFFL);
        int n2 = q;
        this.array[n2] = this.array[n2] ^ (v2 & 0xFFL) << (r << 3);
    }

    public void set(int p, long v) {
        if (this.remainder == 0) {
            super.setXor(p, v);
        } else {
            int shift1 = this.remainder << 3;
            int shift2 = 8 - this.remainder << 3;
            this.array[this.cp + p] = v << shift1 | this.array[this.cp + p] & -1L >>> shift2;
            this.array[this.cp + p + 1] = v >>> shift2 | this.array[this.cp + p + 1] & -1L << shift1;
        }
    }

    public void setByte(int v) {
        this.array[this.cp] = ((long)v & 0xFFL) << (this.remainder << 3) | this.array[this.cp] & -1L >>> (8 - this.remainder << 3);
    }

    public void fill(int shift, byte[] arr, int input_cp, int len) {
        if (this.remainder != 0) {
            int q = this.cp + shift;
            int r = this.remainder;
            int n = q;
            this.array[n] = this.array[n] & (-1L << (r << 3) ^ 0xFFFFFFFFFFFFFFFFL);
            for (int i = 0; r < 8 && i < len; ++i, ++r) {
                int n2 = q;
                this.array[n2] = this.array[n2] | ((long)arr[input_cp] & 0xFFL) << (r << 3);
                ++input_cp;
            }
            ++shift;
            len -= 8 - this.remainder;
        }
        super.fill(shift, arr, input_cp, len);
    }

    public void fillBytes(int shift, byte[] arr, int input_cp, int len) {
        int r = shift + this.remainder;
        int q = this.cp + (r >>> 3);
        if ((r &= 7) != 0) {
            int i;
            int n = q;
            this.array[n] = this.array[n] & (-1L << (r << 3) ^ 0xFFFFFFFFFFFFFFFFL);
            for (i = 0; r < 8 && i < len; ++i, ++r) {
                int n2 = q;
                this.array[n2] = this.array[n2] | ((long)arr[input_cp] & 0xFFL) << (r << 3);
                ++input_cp;
            }
            ++q;
            len -= i;
        }
        super.fill(q - this.cp, arr, input_cp, len);
    }

    public void fillRandomBytes(int shift, SecureRandom random, int length) {
        byte[] rv = new byte[length];
        random.nextBytes(rv);
        this.fillBytes(shift, rv, 0, rv.length);
    }

    public void changeIndex(PointerUnion p) {
        this.array = p.array;
        this.cp = p.cp;
        this.remainder = p.remainder;
    }
}

