/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.mlkem;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.KEM;
import javax.crypto.KEMSpi;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.jcajce.provider.asymmetric.mlkem.BCMLKEMPublicKey;
import org.bouncycastle.jcajce.spec.KTSParameterSpec;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMGenerator;
import org.bouncycastle.pqc.jcajce.provider.util.KdfUtil;

public class MLKEMEncapsulatorSpi
implements KEMSpi.EncapsulatorSpi {
    private final BCMLKEMPublicKey publicKey;
    private final KTSParameterSpec parameterSpec;
    private final MLKEMGenerator kemGen;

    public MLKEMEncapsulatorSpi(BCMLKEMPublicKey publicKey, KTSParameterSpec parameterSpec, SecureRandom random) {
        this.publicKey = publicKey;
        this.parameterSpec = parameterSpec;
        this.kemGen = new MLKEMGenerator(random);
    }

    @Override
    public KEM.Encapsulated engineEncapsulate(int from, int to, String algorithm) {
        Objects.checkFromToIndex(from, to, this.engineSecretSize());
        Objects.requireNonNull(algorithm, "null algorithm");
        if (!this.parameterSpec.getKeyAlgorithmName().equals("Generic") && algorithm.equals("Generic")) {
            algorithm = this.parameterSpec.getKeyAlgorithmName();
        }
        if (!this.parameterSpec.getKeyAlgorithmName().equals("Generic") && !this.parameterSpec.getKeyAlgorithmName().equals(algorithm)) {
            throw new UnsupportedOperationException(this.parameterSpec.getKeyAlgorithmName() + " does not match " + algorithm);
        }
        boolean useKDF = this.parameterSpec.getKdfAlgorithm() != null;
        SecretWithEncapsulation secEnc = this.kemGen.generateEncapsulated(this.publicKey.getKeyParams());
        byte[] encapsulation = secEnc.getEncapsulation();
        byte[] secret = secEnc.getSecret();
        byte[] secretKey = Arrays.copyOfRange(KdfUtil.makeKeyBytes(this.parameterSpec, secret), from, to);
        return new KEM.Encapsulated(new SecretKeySpec(secretKey, algorithm), encapsulation, null);
    }

    @Override
    public int engineSecretSize() {
        return this.parameterSpec.getKeySize() / 8;
    }

    @Override
    public int engineEncapsulationSize() {
        switch (this.publicKey.getKeyParams().getParameters().getName()) {
            case "ML-KEM-512": {
                return 768;
            }
            case "ML-KEM-768": {
                return 1088;
            }
            case "ML-KEM-1024": {
                return 1568;
            }
        }
        return -1;
    }
}

