/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.asn1;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FalconPublicKey
extends ASN1Object {
    private byte[] h;

    public FalconPublicKey(byte[] h) {
        this.h = h;
    }

    public byte[] getH() {
        return this.h;
    }

    public FalconPublicKey(ASN1Sequence seq) {
        this.h = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DEROctetString(this.h));
        return new DERSequence(v);
    }

    public static FalconPublicKey getInstance(Object o) {
        if (o instanceof FalconPublicKey) {
            return (FalconPublicKey)o;
        }
        if (o != null) {
            return new FalconPublicKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }
}

