/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.hqc;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.KEM;
import javax.crypto.KEMSpi;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.jcajce.spec.KTSParameterSpec;
import org.bouncycastle.pqc.crypto.hqc.HQCKEMGenerator;
import org.bouncycastle.pqc.jcajce.provider.hqc.BCHQCPublicKey;
import org.bouncycastle.pqc.jcajce.provider.util.KdfUtil;

public class HQCEncapsulatorSpi
implements KEMSpi.EncapsulatorSpi {
    private final BCHQCPublicKey publicKey;
    private final KTSParameterSpec parameterSpec;
    private final HQCKEMGenerator kemGen;

    public HQCEncapsulatorSpi(BCHQCPublicKey publicKey, KTSParameterSpec parameterSpec, SecureRandom random) {
        this.publicKey = publicKey;
        this.parameterSpec = parameterSpec;
        this.kemGen = new HQCKEMGenerator(random);
    }

    @Override
    public KEM.Encapsulated engineEncapsulate(int from, int to, String algorithm) {
        Objects.checkFromToIndex(from, to, this.engineSecretSize());
        Objects.requireNonNull(algorithm, "null algorithm");
        if (!this.parameterSpec.getKeyAlgorithmName().equals("Generic") && algorithm.equals("Generic")) {
            algorithm = this.parameterSpec.getKeyAlgorithmName();
        }
        if (!this.parameterSpec.getKeyAlgorithmName().equals("Generic") && !this.parameterSpec.getKeyAlgorithmName().equals(algorithm)) {
            throw new UnsupportedOperationException(this.parameterSpec.getKeyAlgorithmName() + " does not match " + algorithm);
        }
        boolean useKDF = this.parameterSpec.getKdfAlgorithm() != null;
        SecretWithEncapsulation secEnc = this.kemGen.generateEncapsulated(this.publicKey.getKeyParams());
        byte[] encapsulation = secEnc.getEncapsulation();
        byte[] secret = secEnc.getSecret();
        byte[] secretKey = Arrays.copyOfRange(KdfUtil.makeKeyBytes(this.parameterSpec, secret), from, to);
        return new KEM.Encapsulated(new SecretKeySpec(secretKey, algorithm), encapsulation, null);
    }

    @Override
    public int engineSecretSize() {
        return this.parameterSpec.getKeySize() / 8;
    }

    @Override
    public int engineEncapsulationSize() {
        switch (this.publicKey.getKeyParams().getParameters().getName()) {
            case "HQC-128": {
                return 128;
            }
            case "HQC-192": {
                return 192;
            }
            case "HQC-256": {
                return 256;
            }
        }
        return -1;
    }
}

