/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumParameters;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DilithiumPublicKeyParameters
extends DilithiumKeyParameters {
    final byte[] rho;
    final byte[] t1;

    static byte[] getEncoded(byte[] rho, byte[] t1) {
        return Arrays.concatenate(rho, t1);
    }

    public DilithiumPublicKeyParameters(DilithiumParameters params, byte[] encoding) {
        super(false, params);
        this.rho = Arrays.copyOfRange(encoding, 0, 32);
        this.t1 = Arrays.copyOfRange(encoding, 32, encoding.length);
    }

    public DilithiumPublicKeyParameters(DilithiumParameters params, byte[] rho, byte[] t1) {
        super(false, params);
        this.rho = Arrays.clone(rho);
        this.t1 = Arrays.clone(t1);
    }

    public byte[] getEncoded() {
        return DilithiumPublicKeyParameters.getEncoded(this.rho, this.t1);
    }

    public byte[] getRho() {
        return Arrays.clone(this.rho);
    }

    public byte[] getT1() {
        return Arrays.clone(this.t1);
    }
}

