/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MLDSAPublicKeyParameters
extends MLDSAKeyParameters {
    final byte[] rho;
    final byte[] t1;

    static byte[] getEncoded(byte[] rho, byte[] t1) {
        return Arrays.concatenate(rho, t1);
    }

    public MLDSAPublicKeyParameters(MLDSAParameters params, byte[] encoding) {
        super(false, params);
        this.rho = Arrays.copyOfRange(encoding, 0, 32);
        this.t1 = Arrays.copyOfRange(encoding, 32, encoding.length);
        if (this.t1.length == 0) {
            throw new IllegalArgumentException("encoding too short");
        }
    }

    public MLDSAPublicKeyParameters(MLDSAParameters params, byte[] rho, byte[] t1) {
        super(false, params);
        if (rho == null) {
            throw new NullPointerException("rho cannot be null");
        }
        if (t1 == null) {
            throw new NullPointerException("t1 cannot be null");
        }
        this.rho = Arrays.clone(rho);
        this.t1 = Arrays.clone(t1);
    }

    public byte[] getEncoded() {
        return MLDSAPublicKeyParameters.getEncoded(this.rho, this.t1);
    }

    public byte[] getRho() {
        return Arrays.clone(this.rho);
    }

    public byte[] getT1() {
        return Arrays.clone(this.t1);
    }
}

