/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.Poly;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class PolyVecK {
    private final Poly[] vec;

    PolyVecK(MLDSAEngine engine) {
        int dilithiumK = engine.getDilithiumK();
        this.vec = new Poly[dilithiumK];
        for (int i = 0; i < dilithiumK; ++i) {
            this.vec[i] = new Poly(engine);
        }
    }

    Poly getVectorIndex(int i) {
        return this.vec[i];
    }

    void setVectorIndex(int i, Poly p) {
        this.vec[i] = p;
    }

    public void uniformEta(byte[] seed, short nonce) {
        short n = nonce;
        for (int i = 0; i < this.vec.length; ++i) {
            short s = n;
            n = (short)(n + 1);
            this.vec[i].uniformEta(seed, s);
        }
    }

    public void reduce() {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).reduce();
        }
    }

    public void invNttToMont() {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).invNttToMont();
        }
    }

    public void addPolyVecK(PolyVecK b) {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).addPoly(b.getVectorIndex(i));
        }
    }

    public void conditionalAddQ() {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).conditionalAddQ();
        }
    }

    public void power2Round(PolyVecK pvk) {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).power2Round(pvk.getVectorIndex(i));
        }
    }

    public void polyVecNtt() {
        for (int i = 0; i < this.vec.length; ++i) {
            this.vec[i].polyNtt();
        }
    }

    public void decompose(PolyVecK v) {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).decompose(v.getVectorIndex(i));
        }
    }

    public void packW1(MLDSAEngine engine, byte[] r, int rOff) {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).packW1(r, rOff + i * engine.getDilithiumPolyW1PackedBytes());
        }
    }

    public void pointwisePolyMontgomery(Poly a, PolyVecK v) {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).pointwiseMontgomery(a, v.getVectorIndex(i));
        }
    }

    public void subtract(PolyVecK inpVec) {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).subtract(inpVec.getVectorIndex(i));
        }
    }

    public boolean checkNorm(int bound) {
        for (int i = 0; i < this.vec.length; ++i) {
            if (!this.getVectorIndex(i).checkNorm(bound)) continue;
            return true;
        }
        return false;
    }

    public int makeHint(PolyVecK v0, PolyVecK v1) {
        int s = 0;
        for (int i = 0; i < this.vec.length; ++i) {
            s += this.getVectorIndex(i).polyMakeHint(v0.getVectorIndex(i), v1.getVectorIndex(i));
        }
        return s;
    }

    public void useHint(PolyVecK u, PolyVecK h) {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).polyUseHint(u.getVectorIndex(i), h.getVectorIndex(i));
        }
    }

    public void shiftLeft() {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).shiftLeft();
        }
    }

    public String toString() {
        Object out = "[";
        for (int i = 0; i < this.vec.length; ++i) {
            out = (String)out + i + " " + this.getVectorIndex(i).toString();
            if (i == this.vec.length - 1) continue;
            out = (String)out + ",\n";
        }
        out = (String)out + "]";
        return out;
    }

    public String toString(String name) {
        return name + ": " + this.toString();
    }
}

