/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecK;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecL;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class PolyVecMatrix {
    private final PolyVecL[] matrix;

    PolyVecMatrix(MLDSAEngine engine) {
        int K = engine.getDilithiumK();
        this.matrix = new PolyVecL[K];
        for (int i = 0; i < K; ++i) {
            this.matrix[i] = new PolyVecL(engine);
        }
    }

    public void pointwiseMontgomery(PolyVecK t, PolyVecL v) {
        for (int i = 0; i < this.matrix.length; ++i) {
            t.getVectorIndex(i).pointwiseAccountMontgomery(this.matrix[i], v);
        }
    }

    public void expandMatrix(byte[] rho) {
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i].uniformBlocks(rho, i << 8);
        }
    }

    private String addString() {
        Object out = "[";
        for (int i = 0; i < this.matrix.length; ++i) {
            out = (String)out + "Outer Matrix " + i + " [";
            out = (String)out + this.matrix[i].toString();
            out = i == this.matrix.length - 1 ? (String)out + "]\n" : (String)out + "],\n";
        }
        out = (String)out + "]\n";
        return out;
    }

    public String toString(String name) {
        return name.concat(": \n" + this.addString());
    }
}

