/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mlkem;

import org.bouncycastle.pqc.crypto.mlkem.MLKEMEngine;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MLKEMPrivateKeyParameters
extends MLKEMKeyParameters {
    public static final int BOTH = 0;
    public static final int SEED_ONLY = 1;
    public static final int EXPANDED_KEY = 2;
    final byte[] s;
    final byte[] hpk;
    final byte[] nonce;
    final byte[] t;
    final byte[] rho;
    final byte[] seed;
    private final int prefFormat;

    public MLKEMPrivateKeyParameters(MLKEMParameters params, byte[] s, byte[] hpk, byte[] nonce, byte[] t, byte[] rho) {
        this(params, s, hpk, nonce, t, rho, null);
    }

    public MLKEMPrivateKeyParameters(MLKEMParameters params, byte[] s, byte[] hpk, byte[] nonce, byte[] t, byte[] rho, byte[] seed) {
        super(true, params);
        this.s = Arrays.clone(s);
        this.hpk = Arrays.clone(hpk);
        this.nonce = Arrays.clone(nonce);
        this.t = Arrays.clone(t);
        this.rho = Arrays.clone(rho);
        this.seed = Arrays.clone(seed);
        this.prefFormat = 0;
    }

    public MLKEMPrivateKeyParameters(MLKEMParameters params, byte[] encoding) {
        this(params, encoding, null);
    }

    public MLKEMPrivateKeyParameters(MLKEMParameters params, byte[] encoding, MLKEMPublicKeyParameters pubKey) {
        super(true, params);
        MLKEMEngine eng = params.getEngine();
        if (encoding.length == 64) {
            byte[][] keyData = eng.generateKemKeyPairInternal(Arrays.copyOfRange(encoding, 0, 32), Arrays.copyOfRange(encoding, 32, encoding.length));
            this.s = keyData[2];
            this.hpk = keyData[3];
            this.nonce = keyData[4];
            this.t = keyData[0];
            this.rho = keyData[1];
            this.seed = keyData[5];
        } else {
            int index = 0;
            this.s = Arrays.copyOfRange(encoding, 0, eng.getKyberIndCpaSecretKeyBytes());
            this.t = Arrays.copyOfRange(encoding, index += eng.getKyberIndCpaSecretKeyBytes(), index + eng.getKyberIndCpaPublicKeyBytes() - 32);
            this.rho = Arrays.copyOfRange(encoding, index += eng.getKyberIndCpaPublicKeyBytes() - 32, index + 32);
            this.hpk = Arrays.copyOfRange(encoding, index += 32, index + 32);
            this.nonce = Arrays.copyOfRange(encoding, index += 32, index + 32);
            this.seed = null;
        }
        if (!(pubKey == null || Arrays.constantTimeAreEqual(this.t, pubKey.t) && Arrays.constantTimeAreEqual(this.rho, pubKey.rho))) {
            throw new IllegalArgumentException("passed in public key does not match private values");
        }
        this.prefFormat = this.seed == null ? 2 : 0;
    }

    private MLKEMPrivateKeyParameters(MLKEMPrivateKeyParameters params, int preferredFormat) {
        super(true, params.getParameters());
        this.s = params.s;
        this.t = params.t;
        this.rho = params.rho;
        this.hpk = params.hpk;
        this.nonce = params.nonce;
        this.seed = params.seed;
        this.prefFormat = preferredFormat;
    }

    public MLKEMPrivateKeyParameters getParametersWithFormat(int format) {
        if (this.prefFormat == format) {
            return this;
        }
        switch (format) {
            case 0: 
            case 1: {
                if (this.seed != null) break;
                throw new IllegalStateException("no seed available");
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown format");
            }
        }
        return new MLKEMPrivateKeyParameters(this, format);
    }

    public int getPreferredFormat() {
        return this.prefFormat;
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(new byte[][]{this.s, this.t, this.rho, this.hpk, this.nonce});
    }

    public byte[] getHPK() {
        return Arrays.clone(this.hpk);
    }

    public byte[] getNonce() {
        return Arrays.clone(this.nonce);
    }

    public byte[] getPublicKey() {
        return MLKEMPublicKeyParameters.getEncoded(this.t, this.rho);
    }

    public MLKEMPublicKeyParameters getPublicKeyParameters() {
        return new MLKEMPublicKeyParameters(this.getParameters(), this.t, this.rho);
    }

    public byte[] getRho() {
        return Arrays.clone(this.rho);
    }

    public byte[] getS() {
        return Arrays.clone(this.s);
    }

    public byte[] getT() {
        return Arrays.clone(this.t);
    }

    public byte[] getSeed() {
        return Arrays.clone(this.seed);
    }
}

