/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.snova;

import org.bouncycastle.pqc.crypto.snova.MapGroup1;
import org.bouncycastle.pqc.crypto.snova.MapGroup2;
import org.bouncycastle.pqc.crypto.snova.SnovaParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SnovaKeyElements {
    public final MapGroup1 map1;
    public final byte[][][] T12;
    public final MapGroup2 map2;

    public SnovaKeyElements(SnovaParameters params) {
        int o = params.getO();
        int v = params.getV();
        int lsq = params.getLsq();
        this.map1 = new MapGroup1(params);
        this.T12 = new byte[v][o][lsq];
        this.map2 = new MapGroup2(params);
    }

    static int copy3d(byte[][][] alpha, byte[] output, int outOff) {
        for (int i = 0; i < alpha.length; ++i) {
            for (int j = 0; j < alpha[i].length; ++j) {
                System.arraycopy(alpha[i][j], 0, output, outOff, alpha[i][j].length);
                outOff += alpha[i][j].length;
            }
        }
        return outOff;
    }

    static int copy4d(byte[][][][] alpha, byte[] output, int outOff) {
        for (int i = 0; i < alpha.length; ++i) {
            outOff = SnovaKeyElements.copy3d(alpha[i], output, outOff);
        }
        return outOff;
    }

    static int copy3d(byte[] input, int inOff, byte[][][] alpha) {
        for (int i = 0; i < alpha.length; ++i) {
            for (int j = 0; j < alpha[i].length; ++j) {
                System.arraycopy(input, inOff, alpha[i][j], 0, alpha[i][j].length);
                inOff += alpha[i][j].length;
            }
        }
        return inOff;
    }

    static int copy4d(byte[] input, int inOff, byte[][][][] alpha) {
        for (int i = 0; i < alpha.length; ++i) {
            for (int j = 0; j < alpha[i].length; ++j) {
                for (int k = 0; k < alpha[i][j].length; ++k) {
                    System.arraycopy(input, inOff, alpha[i][j][k], 0, alpha[i][j][k].length);
                    inOff += alpha[i][j][k].length;
                }
            }
        }
        return inOff;
    }
}

