/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.Validity;

public class DeltaCertificateDescriptor
extends ASN1Object {
    private final ASN1Integer serialNumber;
    private final AlgorithmIdentifier signature;
    private final X500Name issuer;
    private final Validity validity;
    private final X500Name subject;
    private final SubjectPublicKeyInfo subjectPublicKeyInfo;
    private final Extensions extensions;
    private final ASN1BitString signatureValue;

    public static DeltaCertificateDescriptor getInstance(Object obj) {
        if (obj instanceof DeltaCertificateDescriptor) {
            return (DeltaCertificateDescriptor)obj;
        }
        if (obj != null) {
            return new DeltaCertificateDescriptor(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static DeltaCertificateDescriptor fromExtensions(Extensions extensions) {
        return DeltaCertificateDescriptor.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.deltaCertificateDescriptor));
    }

    private DeltaCertificateDescriptor(ASN1Sequence seq) {
        ASN1Integer serialNumber = ASN1Integer.getInstance(seq.getObjectAt(0));
        int idx = 1;
        ASN1Encodable next = seq.getObjectAt(idx++);
        AlgorithmIdentifier signature = null;
        X500Name issuer = null;
        Validity validity = null;
        X500Name subject = null;
        while (next instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagged = ASN1TaggedObject.getInstance(next);
            switch (tagged.getTagNo()) {
                case 0: {
                    signature = AlgorithmIdentifier.getInstance(tagged, true);
                    break;
                }
                case 1: {
                    issuer = X500Name.getInstance(tagged, true);
                    break;
                }
                case 2: {
                    validity = Validity.getInstance(tagged, true);
                    break;
                }
                case 3: {
                    subject = X500Name.getInstance(tagged, true);
                }
            }
            next = seq.getObjectAt(idx++);
        }
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(next);
        next = seq.getObjectAt(idx);
        Extensions extensions = null;
        while (next instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagged = ASN1TaggedObject.getInstance(next);
            switch (tagged.getTagNo()) {
                case 4: {
                    extensions = Extensions.getInstance(tagged, true);
                }
            }
            next = seq.getObjectAt(idx++);
        }
        ASN1BitString signatureValue = ASN1BitString.getInstance(next);
        this.serialNumber = serialNumber;
        this.signature = signature;
        this.issuer = issuer;
        this.validity = validity;
        this.subject = subject;
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
        this.extensions = extensions;
        this.signatureValue = signatureValue;
    }

    public DeltaCertificateDescriptor(ASN1Integer serialNumber, AlgorithmIdentifier signature, X500Name issuer, Validity validity, X500Name subject, SubjectPublicKeyInfo subjectPublicKeyInfo, Extensions extensions, ASN1BitString signatureValue) {
        if (serialNumber == null) {
            throw new NullPointerException("'serialNumber' cannot be null");
        }
        if (subjectPublicKeyInfo == null) {
            throw new NullPointerException("'subjectPublicKeyInfo' cannot be null");
        }
        if (signatureValue == null) {
            throw new NullPointerException("'signatureValue' cannot be null");
        }
        this.serialNumber = serialNumber;
        this.signature = signature;
        this.issuer = issuer;
        this.validity = validity;
        this.subject = subject;
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
        this.extensions = extensions;
        this.signatureValue = signatureValue;
    }

    public ASN1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public ASN1Sequence getValidity() {
        return (ASN1Sequence)this.validity.toASN1Primitive();
    }

    public Validity getValidityObject() {
        return this.validity;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public ASN1BitString getSignatureValue() {
        return this.signatureValue;
    }

    public DeltaCertificateDescriptor trimTo(TBSCertificate baseTbsCertificate, Extensions tbsExtensions) {
        return DeltaCertificateDescriptor.trimDeltaCertificateDescriptor(this, baseTbsCertificate, tbsExtensions);
    }

    private static DeltaCertificateDescriptor trimDeltaCertificateDescriptor(DeltaCertificateDescriptor descriptor, TBSCertificate tbsCertificate, Extensions tbsExtensions) {
        X500Name subject;
        Validity validity;
        X500Name issuer;
        ASN1Integer serialNumber = descriptor.getSerialNumber();
        AlgorithmIdentifier signature = descriptor.getSignature();
        if (signature != null && signature.equals(tbsCertificate.getSignature())) {
            signature = null;
        }
        if ((issuer = descriptor.getIssuer()) != null && issuer.equals(tbsCertificate.getIssuer())) {
            issuer = null;
        }
        if ((validity = descriptor.getValidityObject()) != null && validity.equals(tbsCertificate.getValidity())) {
            validity = null;
        }
        if ((subject = descriptor.getSubject()) != null && subject.equals(tbsCertificate.getSubject())) {
            subject = null;
        }
        SubjectPublicKeyInfo subjectPublicKeyInfo = descriptor.getSubjectPublicKeyInfo();
        Extensions extensions = descriptor.getExtensions();
        if (extensions != null) {
            ExtensionsGenerator generator = new ExtensionsGenerator();
            Enumeration extEn = tbsExtensions.oids();
            while (extEn.hasMoreElements()) {
                Extension deltaExtension;
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)extEn.nextElement();
                if (Extension.deltaCertificateDescriptor.equals(oid) || (deltaExtension = extensions.getExtension(oid)) == null || deltaExtension.equals(tbsExtensions.getExtension(oid))) continue;
                generator.addExtension(deltaExtension);
            }
            extensions = generator.isEmpty() ? null : generator.generate();
        }
        ASN1BitString signatureValue = descriptor.getSignatureValue();
        return new DeltaCertificateDescriptor(serialNumber, signature, issuer, validity, subject, subjectPublicKeyInfo, extensions, signatureValue);
    }

    private void addOptional(ASN1EncodableVector v, int tag, boolean explicit, ASN1Object obj) {
        if (obj != null) {
            v.add(new DERTaggedObject(explicit, tag, (ASN1Encodable)obj));
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(8);
        v.add(this.serialNumber);
        this.addOptional(v, 0, true, this.signature);
        this.addOptional(v, 1, true, this.issuer);
        this.addOptional(v, 2, true, this.validity);
        this.addOptional(v, 3, true, this.subject);
        v.add(this.subjectPublicKeyInfo);
        this.addOptional(v, 4, true, this.extensions);
        v.add(this.signatureValue);
        return new DERSequence(v);
    }
}

