/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.digests.ISAPDigest;
import org.bouncycastle.util.Longs;

public class AsconPermutationFriend {
    public static AsconPermutation getAsconPermutation(ISAPDigest.Friend friend) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by ISAPDigest or Ascon Digest");
        }
        return new AsconPermutation();
    }

    public static class AsconPermutation {
        public long x0;
        public long x1;
        public long x2;
        public long x3;
        public long x4;

        AsconPermutation() {
        }

        public void round(long C) {
            this.x2 ^= C;
            long x0x4 = this.x0 ^ this.x4;
            long x1x2c = this.x1 ^ this.x2;
            long x1orx2c = this.x1 | this.x2;
            long t0 = this.x3 ^ x1orx2c ^ this.x0 ^ this.x1 & x0x4;
            long t1 = x0x4 ^ (x1orx2c | this.x3) ^ this.x1 & this.x2 & this.x3;
            long t2 = x1x2c ^ this.x4 & (this.x3 ^ 0xFFFFFFFFFFFFFFFFL);
            long t3 = (this.x0 | this.x3 ^ this.x4) ^ x1x2c;
            long t4 = this.x3 ^ (this.x1 | this.x4) ^ this.x0 & this.x1;
            this.x0 = t0 ^ Longs.rotateRight(t0, 19) ^ Longs.rotateRight(t0, 28);
            this.x1 = t1 ^ Longs.rotateRight(t1, 39) ^ Longs.rotateRight(t1, 61);
            this.x2 = t2 ^ Longs.rotateRight(t2, 1) ^ Longs.rotateRight(t2, 6) ^ 0xFFFFFFFFFFFFFFFFL;
            this.x3 = t3 ^ Longs.rotateRight(t3, 10) ^ Longs.rotateRight(t3, 17);
            this.x4 = t4 ^ Longs.rotateRight(t4, 7) ^ Longs.rotateRight(t4, 41);
        }

        public void p(int nr) {
            if (nr == 12) {
                this.round(240L);
                this.round(225L);
                this.round(210L);
                this.round(195L);
            }
            if (nr >= 8) {
                this.round(180L);
                this.round(165L);
            }
            this.round(150L);
            this.round(135L);
            this.round(120L);
            this.round(105L);
            this.round(90L);
            this.round(75L);
        }

        public void set(long x0, long x1, long x2, long x3, long x4) {
            this.x0 = x0;
            this.x1 = x1;
            this.x2 = x2;
            this.x3 = x3;
            this.x4 = x4;
        }
    }
}

